/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.rsvp.objects.ErrorSpec;
import java.net.Inet6Address;
import java.net.UnknownHostException;

public class ErrorSpecIPv6
extends ErrorSpec {
    protected Inet6Address errorNodeAddress;
    protected int flags;
    protected int errorCode;
    protected int errorValue;

    public ErrorSpecIPv6() {
        this.classNum = 6;
        this.cType = 2;
        this.length = 24;
        this.flags = 0;
        this.errorCode = 0;
        this.errorValue = 0;
    }

    public ErrorSpecIPv6(Inet6Address errorNodeAddress, int flags, int errorCode, int errorValue) {
        this.classNum = 6;
        this.cType = 2;
        this.errorNodeAddress = errorNodeAddress;
        this.flags = flags;
        this.errorCode = errorCode;
        this.errorValue = errorValue;
    }

    public ErrorSpecIPv6(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode(bytes, offset);
    }

    @Override
    public void encode() {
        this.length = 24;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        byte[] addr = this.errorNodeAddress.getAddress();
        System.arraycopy(addr, 0, this.getBytes(), 4, addr.length);
        this.bytes[20] = (byte)(this.flags & 0xFF);
        this.bytes[21] = (byte)(this.errorCode & 0xFF);
        this.bytes[22] = (byte)(this.errorValue >> 8 & 0xFF);
        this.bytes[23] = (byte)(this.errorValue & 0xFF);
    }

    @Override
    public void decode(byte[] bytes, int offset) {
        this.length = bytes[offset] | bytes[offset + 1];
        int headerSize = 4;
        int unprocessedBytes = this.length - headerSize;
        int currentIndex = offset + headerSize;
        if (unprocessedBytes > 0) {
            byte[] readAddress = new byte[16];
            System.arraycopy(bytes, currentIndex, readAddress, 0, 16);
            try {
                this.errorNodeAddress = (Inet6Address)Inet6Address.getByAddress(readAddress);
                currentIndex += 16;
                unprocessedBytes -= 16;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (unprocessedBytes > 0) {
                this.flags = bytes[currentIndex];
                ++currentIndex;
                if (--unprocessedBytes > 0) {
                    this.errorCode = bytes[currentIndex];
                    ++currentIndex;
                    if (--unprocessedBytes > 0) {
                        this.errorValue = bytes[currentIndex] | bytes[currentIndex + 1];
                        currentIndex += 2;
                        unprocessedBytes -= 2;
                    }
                }
            }
        }
    }

    public Inet6Address getErrorNodeAddress() {
        return this.errorNodeAddress;
    }

    public void setErrorNodeAddress(Inet6Address errorNodeAddress) {
        this.errorNodeAddress = errorNodeAddress;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getErrorValue() {
        return this.errorValue;
    }

    public void setErrorValue(int errorValue) {
        this.errorValue = errorValue;
    }
}

