/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.pce.pcep.objects.subobjects.SREROSubobject;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.RSVPObject;
import es.tid.rsvp.objects.subobjects.ASNumberEROSubobject;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv6prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.LabelEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.rsvp.objects.subobjects.WavebandLabelEROSubobject;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ERO
extends RSVPObject {
    private LinkedList<EROSubobject> eroSubobjects;
    private static final Logger log = LoggerFactory.getLogger("ROADM");

    public ERO() {
        this.classNum = 20;
        this.cType = 1;
        this.length = 4;
        this.eroSubobjects = new LinkedList();
        log.debug("ERO Object Created");
    }

    public ERO(byte[] bytes, int offset) {
        super(bytes, offset);
        log.debug("ERO Object Created");
        try {
            this.decode(bytes, offset);
        }
        catch (RSVPProtocolViolationException e) {
            e.printStackTrace();
        }
    }

    public void addEROSubobject(EROSubobject eroSO) {
        this.eroSubobjects.add(eroSO);
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        this.length = 4;
        int subObjectsNumber = this.eroSubobjects.size();
        for (int j = 0; j < subObjectsNumber; ++j) {
            EROSubobject eroSO = this.eroSubobjects.get(j);
            eroSO.encode();
            this.length += eroSO.getErosolength();
        }
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = 4;
        for (int i = 0; i < subObjectsNumber; ++i) {
            EROSubobject eroSO = this.eroSubobjects.get(i);
            System.arraycopy(eroSO.getSubobject_bytes(), 0, this.bytes, currentIndex, eroSO.getErosolength());
            currentIndex += eroSO.getErosolength();
        }
    }

    public void decode(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        this.eroSubobjects = new LinkedList();
        int unprocessedBytes = this.length - 4;
        offset += 4;
        while (unprocessedBytes > 0) {
            int subojectclass = EROSubobject.getType(bytes, offset);
            int subojectlength = EROSubobject.getLength(bytes, offset);
            block0 : switch (subojectclass) {
                case 1: {
                    IPv4prefixEROSubobject sobjt4 = new IPv4prefixEROSubobject(bytes, offset);
                    this.addEROSubobject(sobjt4);
                    break;
                }
                case 2: {
                    IPv6prefixEROSubobject sobjt6 = new IPv6prefixEROSubobject(bytes, offset);
                    this.addEROSubobject(sobjt6);
                    break;
                }
                case 32: {
                    ASNumberEROSubobject sobjas = new ASNumberEROSubobject(bytes, offset);
                    this.addEROSubobject(sobjas);
                    break;
                }
                case 4: {
                    UnnumberIfIDEROSubobject subun = new UnnumberIfIDEROSubobject(bytes, offset);
                    this.addEROSubobject(subun);
                    break;
                }
                case 36: {
                    SREROSubobject sreroso = new SREROSubobject(bytes, offset);
                    this.addEROSubobject(sreroso);
                    break;
                }
                case 3: {
                    int ctype = LabelEROSubobject.getCType(bytes, offset);
                    switch (ctype) {
                        case 2: {
                            GeneralizedLabelEROSubobject subgl = new GeneralizedLabelEROSubobject(bytes, offset);
                            this.addEROSubobject(subgl);
                            break block0;
                        }
                        case 3: {
                            WavebandLabelEROSubobject subwl = new WavebandLabelEROSubobject(bytes, offset);
                            this.addEROSubobject(subwl);
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    log.error("ERO Subobject Unknown");
                }
            }
            unprocessedBytes -= subojectlength;
            offset += subojectlength;
        }
    }

    public LinkedList<EROSubobject> getEroSubobjects() {
        return this.eroSubobjects;
    }

    public void setEroSubobjects(LinkedList<EROSubobject> eroSubobjects) {
        this.eroSubobjects = eroSubobjects;
    }
}

