/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.messages.te;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.FFFlowDescriptor;
import es.tid.rsvp.constructs.FlowDescriptor;
import es.tid.rsvp.constructs.SEFlowDescriptor;
import es.tid.rsvp.constructs.te.FFFlowDescriptorTE;
import es.tid.rsvp.constructs.te.SEFlowDescriptorTE;
import es.tid.rsvp.messages.RSVPResvMessage;
import es.tid.rsvp.objects.Integrity;
import es.tid.rsvp.objects.PolicyData;
import es.tid.rsvp.objects.RSVPHopIPv4;
import es.tid.rsvp.objects.RSVPHopIPv6;
import es.tid.rsvp.objects.RSVPObject;
import es.tid.rsvp.objects.ResvConfirmIPv4;
import es.tid.rsvp.objects.ResvConfirmIPv6;
import es.tid.rsvp.objects.ScopeIPv4;
import es.tid.rsvp.objects.ScopeIPv6;
import es.tid.rsvp.objects.SessionLSPTunnelIPv4;
import es.tid.rsvp.objects.SessionLSPTunnelIPv6;
import es.tid.rsvp.objects.Style;
import es.tid.rsvp.objects.TimeValues;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSVPTEResvMessage
extends RSVPResvMessage {
    private static final Logger log = LoggerFactory.getLogger("ROADM");

    public RSVPTEResvMessage() {
        this.vers = 1;
        this.flags = 0;
        this.msgType = 2;
        this.rsvpChecksum = 255;
        this.sendTTL = 0;
        this.reserved = 0;
        this.length = 8;
        this.policyData = new LinkedList();
        this.flowDescriptors = new LinkedList();
        log.debug("RSVP-TE Resv Message Created");
    }

    public RSVPTEResvMessage(byte[] bytes, int length) {
        this.bytes = bytes;
        this.length = length;
        this.policyData = new LinkedList();
        this.flowDescriptors = new LinkedList();
        log.debug("RSVP-TE Resv Message Created");
    }

    @Override
    public void encodeHeader() {
        this.bytes[0] = (byte)(this.vers << 4 & 0xF0 | this.flags & 0xF);
        this.bytes[1] = (byte)this.msgType;
        this.bytes[2] = (byte)(this.rsvpChecksum >> 8 & 0xFF);
        this.bytes[3] = (byte)(this.rsvpChecksum & 0xFF);
        this.bytes[4] = (byte)this.sendTTL;
        this.bytes[5] = (byte)this.reserved;
        this.bytes[6] = (byte)(this.length >> 8 & 0xFF);
        this.bytes[7] = (byte)(this.length & 0xFF);
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        int i;
        log.debug("Starting RSVP-TE Resv Message encode");
        int commonHeaderSize = 8;
        if (this.integrity != null) {
            this.length += this.integrity.getLength();
            log.debug("Integrity RSVP Object found");
        }
        if (this.session != null) {
            this.length += this.session.getLength();
        } else {
            log.error("Session RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Session RSVP Object found");
        if (this.rsvpHop != null) {
            this.length += this.rsvpHop.getLength();
        } else {
            log.error("Hop RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Hop RSVP Object found");
        if (this.timeValues != null) {
            this.length += this.timeValues.getLength();
        } else {
            log.error("Time Values RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Time Values RSVP Object found");
        if (this.resvConfirm != null) {
            this.length += this.resvConfirm.getLength();
            log.debug("ResvConfirm RSVP Object found");
        }
        if (this.scope != null) {
            this.length += this.scope.getLength();
            log.debug("Scope RSVP Object found");
        }
        int pdSize = this.policyData.size();
        for (int i2 = 0; i2 < pdSize; ++i2) {
            PolicyData pd = (PolicyData)this.policyData.get(i2);
            this.length += pd.getLength();
            log.debug("Policy Data RSVP Object found");
        }
        if (this.style != null) {
            this.length += this.style.getLength();
        } else {
            log.error("Style RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Style RSVP Object found");
        int fdSize = this.flowDescriptors.size();
        for (int i3 = 0; i3 < fdSize; ++i3) {
            FlowDescriptor fd = (FlowDescriptor)this.flowDescriptors.get(i3);
            this.length += fd.getLength();
            log.debug("Flow Descriptor RSVP Construct found");
        }
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = commonHeaderSize;
        if (this.integrity != null) {
            this.integrity.encode();
            System.arraycopy(this.integrity.getBytes(), 0, this.bytes, currentIndex, this.integrity.getLength());
            currentIndex += this.integrity.getLength();
        }
        this.session.encode();
        System.arraycopy(this.session.getBytes(), 0, this.bytes, currentIndex, this.session.getLength());
        this.rsvpHop.encode();
        System.arraycopy(this.rsvpHop.getBytes(), 0, this.bytes, currentIndex += this.session.getLength(), this.rsvpHop.getLength());
        this.timeValues.encode();
        System.arraycopy(this.timeValues.getBytes(), 0, this.bytes, currentIndex += this.rsvpHop.getLength(), this.timeValues.getLength());
        currentIndex += this.timeValues.getLength();
        if (this.resvConfirm != null) {
            this.resvConfirm.encode();
            System.arraycopy(this.resvConfirm.getBytes(), 0, this.bytes, currentIndex, this.resvConfirm.getLength());
            currentIndex += this.resvConfirm.getLength();
        }
        if (this.scope != null) {
            this.scope.encode();
            System.arraycopy(this.scope.getBytes(), 0, this.bytes, currentIndex, this.scope.getLength());
            currentIndex += this.scope.getLength();
        }
        for (i = 0; i < pdSize; ++i) {
            PolicyData pd = (PolicyData)this.policyData.get(i);
            pd.encode();
            System.arraycopy(pd.getBytes(), 0, this.bytes, currentIndex, pd.getLength());
            currentIndex += pd.getLength();
        }
        this.style.encode();
        System.arraycopy(this.style.getBytes(), 0, this.bytes, currentIndex, this.style.getLength());
        currentIndex += this.style.getLength();
        for (i = 0; i < fdSize; ++i) {
            FlowDescriptor fd = (FlowDescriptor)this.flowDescriptors.get(i);
            try {
                fd.encode();
                System.arraycopy(fd.getBytes(), 0, this.bytes, currentIndex, fd.getLength());
                currentIndex += fd.getLength();
                continue;
            }
            catch (RSVPProtocolViolationException e) {
                log.error("Errors during Flow Descriptor number " + i + " encoding");
            }
        }
        log.debug("RSVP-TE Resv Message encoding accomplished");
    }

    @Override
    public void decode() throws RSVPProtocolViolationException {
        this.decodeHeader();
        int offset = 8;
        while (offset < this.length) {
            int classNum = RSVPObject.getClassNum(this.bytes, offset);
            if (classNum == 1) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 7) {
                    this.session = new SessionLSPTunnelIPv4(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                if (cType == 8) {
                    this.session = new SessionLSPTunnelIPv6(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 3) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.rsvpHop = new RSVPHopIPv4(this.bytes, offset);
                    offset += this.rsvpHop.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.rsvpHop = new RSVPHopIPv6(this.bytes, offset);
                    offset += this.rsvpHop.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 4) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.integrity = new Integrity(this.bytes, offset);
                    offset += this.integrity.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 5) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.timeValues = new TimeValues(this.bytes, offset);
                    offset += this.timeValues.getLength();
                    continue;
                }
                log.error("Error Deconding Time Values");
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 15) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.resvConfirm = new ResvConfirmIPv4(this.bytes, offset);
                    offset += this.resvConfirm.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.resvConfirm = new ResvConfirmIPv6(this.bytes, offset);
                    offset += this.resvConfirm.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 7) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.scope = new ScopeIPv4(this.bytes, offset);
                    offset += this.scope.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.scope = new ScopeIPv6(this.bytes, offset);
                    offset += this.scope.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 13) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    PolicyData pd = new PolicyData(this.bytes, offset);
                    offset += pd.getLength();
                    this.policyData.add(pd);
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 8) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.style = new Style(this.bytes, offset);
                    offset += this.style.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 9) {
                if (this.style != null) {
                    if (this.style.getOptionVector() == 10) {
                        FFFlowDescriptorTE fffd = new FFFlowDescriptorTE(true);
                        ((FFFlowDescriptor)fffd).decode(this.bytes, offset);
                        offset += fffd.getLength();
                        this.flowDescriptors.add(fffd);
                        while (offset < this.length) {
                            FFFlowDescriptorTE fffd2 = new FFFlowDescriptorTE(false);
                            ((FFFlowDescriptor)fffd2).decode(this.bytes, offset);
                            offset += fffd2.getLength();
                            this.flowDescriptors.add(fffd2);
                        }
                        continue;
                    }
                    if (this.style.getOptionVector() != 18) continue;
                    while (offset < this.length) {
                        SEFlowDescriptorTE sefd = new SEFlowDescriptorTE();
                        ((SEFlowDescriptor)sefd).decode(this.bytes, offset);
                        offset += sefd.getLength();
                        this.flowDescriptors.add(sefd);
                    }
                    continue;
                }
                log.error("Malformed RSVP-TE Resv Message, Style Object not Found");
                throw new RSVPProtocolViolationException();
            }
            log.error("Malformed RSVP-TE Resv Message, Object classNum incorrect");
            throw new RSVPProtocolViolationException();
        }
    }
}

