/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.messages;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.FFFlowDescriptor;
import es.tid.rsvp.constructs.FlowDescriptor;
import es.tid.rsvp.constructs.SEFlowDescriptor;
import es.tid.rsvp.constructs.WFFlowDescriptor;
import es.tid.rsvp.messages.RSVPMessage;
import es.tid.rsvp.objects.Integrity;
import es.tid.rsvp.objects.RSVPHop;
import es.tid.rsvp.objects.RSVPHopIPv4;
import es.tid.rsvp.objects.RSVPHopIPv6;
import es.tid.rsvp.objects.RSVPObject;
import es.tid.rsvp.objects.Scope;
import es.tid.rsvp.objects.ScopeIPv4;
import es.tid.rsvp.objects.ScopeIPv6;
import es.tid.rsvp.objects.Session;
import es.tid.rsvp.objects.SessionIPv4;
import es.tid.rsvp.objects.SessionIPv6;
import es.tid.rsvp.objects.Style;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSVPResvTearMessage
extends RSVPMessage {
    private Integrity integrity;
    private Session session;
    private RSVPHop rsvpHop;
    private Scope scope;
    private Style style;
    private LinkedList<FlowDescriptor> flowDescriptors;
    private static final Logger log = LoggerFactory.getLogger("ROADM");

    public RSVPResvTearMessage() {
        this.vers = 1;
        this.flags = 0;
        this.msgType = 6;
        this.rsvpChecksum = 255;
        this.sendTTL = 0;
        this.reserved = 0;
        this.length = 8;
        this.flowDescriptors = new LinkedList();
        log.debug("RSVP Resv Message Created");
    }

    public RSVPResvTearMessage(byte[] bytes, int length) throws RSVPProtocolViolationException {
        super(bytes);
        this.decode();
        log.debug("RSVP Path Message Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        int commonHeaderSize;
        log.debug("Starting RSVP Resv TearDown Message encode");
        this.rsvpChecksum = 255;
        this.length = commonHeaderSize = 8;
        if (this.integrity != null) {
            this.integrity.encode();
            this.length += this.integrity.getLength();
            log.debug("Integrity RSVP Object found");
        }
        if (this.session != null) {
            this.session.encode();
            this.length += this.session.getLength();
        } else {
            log.error("Session RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Session RSVP Object found");
        if (this.rsvpHop != null) {
            this.rsvpHop.encode();
            this.length += this.rsvpHop.getLength();
        } else {
            log.error("Hop RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Hop RSVP Object found");
        if (this.scope != null) {
            this.scope.encode();
            this.length += this.scope.getLength();
            log.debug("Scope RSVP Object found");
        }
        if (this.style != null) {
            this.style.encode();
            this.length += this.style.getLength();
        } else {
            log.error("Style RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Style RSVP Object found");
        int fdSize = this.flowDescriptors.size();
        for (int i = 0; i < fdSize; ++i) {
            FlowDescriptor fd = this.flowDescriptors.get(i);
            try {
                fd.encode();
            }
            catch (RSVPProtocolViolationException e) {
                log.error("Errors during Flow Descriptor number " + i + " encoding");
            }
            this.length += fd.getLength();
            log.debug("Sender Descriptor RSVP Construct found");
        }
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = commonHeaderSize;
        if (this.integrity != null) {
            System.arraycopy(this.integrity.getBytes(), 0, this.bytes, currentIndex, this.integrity.getLength());
            currentIndex += this.integrity.getLength();
        }
        System.arraycopy(this.session.getBytes(), 0, this.bytes, currentIndex, this.session.getLength());
        System.arraycopy(this.rsvpHop.getBytes(), 0, this.bytes, currentIndex += this.session.getLength(), this.rsvpHop.getLength());
        currentIndex += this.rsvpHop.getLength();
        if (this.scope != null) {
            System.arraycopy(this.scope.getBytes(), 0, this.bytes, currentIndex, this.scope.getLength());
            currentIndex += this.scope.getLength();
        }
        System.arraycopy(this.style.getBytes(), 0, this.bytes, currentIndex, this.style.getLength());
        currentIndex += this.style.getLength();
        for (int i = 0; i < fdSize; ++i) {
            FlowDescriptor fd = this.flowDescriptors.get(i);
            System.arraycopy(fd.getBytes(), 0, this.bytes, currentIndex, fd.getLength());
            currentIndex += fd.getLength();
        }
        log.debug("RSVP Resv Message encoding accomplished");
    }

    @Override
    public void decode() throws RSVPProtocolViolationException {
        this.decodeHeader();
        this.flowDescriptors = new LinkedList();
        int offset = 8;
        while (offset < this.length) {
            int classNum = RSVPObject.getClassNum(this.bytes, offset);
            if (classNum == 1) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.session = new SessionIPv4(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.session = new SessionIPv6(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 3) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.rsvpHop = new RSVPHopIPv4(this.bytes, offset);
                    offset += this.rsvpHop.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.rsvpHop = new RSVPHopIPv6(this.bytes, offset);
                    offset += this.rsvpHop.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 4) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.integrity = new Integrity(this.bytes, offset);
                    offset += this.integrity.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 7) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.scope = new ScopeIPv4(this.bytes, offset);
                    offset += this.scope.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.scope = new ScopeIPv6(this.bytes, offset);
                    offset += this.scope.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 8) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.style = new Style(this.bytes, offset);
                    offset += this.style.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 9) {
                if (this.style != null) {
                    if (this.style.getOptionVector() == 10) {
                        FFFlowDescriptor fffd = new FFFlowDescriptor(true);
                        fffd.decode(this.bytes, offset);
                        offset += fffd.getLength();
                        this.flowDescriptors.add(fffd);
                        while (offset < this.length) {
                            FFFlowDescriptor fffd2 = new FFFlowDescriptor(true);
                            fffd2.decode(this.bytes, offset);
                            offset += fffd2.getLength();
                            this.flowDescriptors.add(fffd2);
                        }
                        continue;
                    }
                    if (this.style.getOptionVector() == 17) {
                        while (offset < this.length) {
                            WFFlowDescriptor wffd = new WFFlowDescriptor();
                            wffd.decode(this.bytes, offset);
                            offset += wffd.getLength();
                            this.flowDescriptors.add(wffd);
                        }
                        continue;
                    }
                    if (this.style.getOptionVector() != 18) continue;
                    while (offset < this.length) {
                        SEFlowDescriptor sefd = new SEFlowDescriptor();
                        sefd.decode(this.bytes, offset);
                        offset += sefd.getLength();
                        this.flowDescriptors.add(sefd);
                    }
                    continue;
                }
                log.error("Malformed RSVP Resv Message, Style Object not Found");
                throw new RSVPProtocolViolationException();
            }
            log.error("Malformed RSVP Resv Message, Object classNum incorrect");
            throw new RSVPProtocolViolationException();
        }
    }

    public Integrity getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(Integrity integrity) {
        this.integrity = integrity;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public RSVPHop getRsvpHop() {
        return this.rsvpHop;
    }

    public void setRsvpHop(RSVPHop rsvpHop) {
        this.rsvpHop = rsvpHop;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public LinkedList<FlowDescriptor> getFlowDescriptors() {
        return this.flowDescriptors;
    }

    public void setFlowDescriptors(LinkedList<FlowDescriptor> flowDescriptors) {
        this.flowDescriptors = flowDescriptors;
    }
}

