/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.messages;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.SenderDescriptor;
import es.tid.rsvp.constructs.te.SenderDescriptorTE;
import es.tid.rsvp.messages.RSVPMessage;
import es.tid.rsvp.objects.Integrity;
import es.tid.rsvp.objects.RSVPHop;
import es.tid.rsvp.objects.RSVPHopIPv4;
import es.tid.rsvp.objects.RSVPHopIPv6;
import es.tid.rsvp.objects.RSVPObject;
import es.tid.rsvp.objects.Session;
import es.tid.rsvp.objects.SessionIPv4;
import es.tid.rsvp.objects.SessionIPv6;
import es.tid.rsvp.objects.SessionLSPTunnelIPv4;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSVPPathTearMessage
extends RSVPMessage {
    private Integrity integrity;
    private Session session;
    private RSVPHop rsvpHop;
    private LinkedList<SenderDescriptor> senderDescriptors;
    private static final Logger log = LoggerFactory.getLogger("ROADM");

    public RSVPPathTearMessage() {
        this.vers = 1;
        this.flags = 0;
        this.msgType = 5;
        this.rsvpChecksum = 255;
        this.sendTTL = 0;
        this.reserved = 0;
        this.length = 8;
        this.senderDescriptors = new LinkedList();
        log.debug("RSVP Path Teardown Message Created");
    }

    public RSVPPathTearMessage(byte[] bytes, int length) throws RSVPProtocolViolationException {
        super(bytes);
        this.decode();
        log.debug("RSVP Path Message Created");
    }

    @Override
    public void encodeHeader() {
        this.bytes[0] = (byte)(this.vers << 4 & 0xF0 | this.flags & 0xF);
        this.bytes[1] = (byte)this.msgType;
        this.bytes[2] = (byte)(this.rsvpChecksum >> 8 & 0xFF);
        this.bytes[3] = (byte)(this.rsvpChecksum & 0xFF);
        this.bytes[4] = (byte)this.sendTTL;
        this.bytes[5] = (byte)this.reserved;
        this.bytes[6] = (byte)(this.length >> 8 & 0xFF);
        this.bytes[7] = (byte)(this.length & 0xFF);
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        int commonHeaderSize;
        log.debug("Starting RSVP Path TearDown Message encode");
        this.rsvpChecksum = 255;
        this.length = commonHeaderSize = 8;
        if (this.integrity != null) {
            this.integrity.encode();
            this.length += this.integrity.getLength();
            log.debug("Integrity RSVP Object found");
        }
        if (this.session != null) {
            this.session.encode();
            this.length += this.session.getLength();
        } else {
            log.error("Session RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Session RSVP Object found");
        if (this.rsvpHop != null) {
            this.rsvpHop.encode();
            this.length += this.rsvpHop.getLength();
        } else {
            log.error("Hop RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Hop RSVP Object found");
        int sdSize = this.senderDescriptors.size();
        for (int i = 0; i < sdSize; ++i) {
            SenderDescriptor sd = this.senderDescriptors.get(i);
            try {
                sd.encode();
                this.length += sd.getLength();
                log.debug("Sender Descriptor RSVP Construct found");
                continue;
            }
            catch (RSVPProtocolViolationException e) {
                log.error("Errors during Sender Descriptor number " + i + " encoding");
            }
        }
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = commonHeaderSize;
        if (this.integrity != null) {
            System.arraycopy(this.integrity.getBytes(), 0, this.bytes, currentIndex, this.integrity.getLength());
            currentIndex += this.integrity.getLength();
        }
        System.arraycopy(this.session.getBytes(), 0, this.bytes, currentIndex, this.session.getLength());
        System.arraycopy(this.rsvpHop.getBytes(), 0, this.bytes, currentIndex += this.session.getLength(), this.rsvpHop.getLength());
        currentIndex += this.rsvpHop.getLength();
        for (int i = 0; i < sdSize; ++i) {
            SenderDescriptor sd = this.senderDescriptors.get(i);
            System.arraycopy(sd.getBytes(), 0, this.bytes, currentIndex, sd.getLength());
            currentIndex += sd.getLength();
        }
        log.debug("RSVP Path TearDown Message encoding accomplished");
    }

    @Override
    public void decode() throws RSVPProtocolViolationException {
        this.decodeHeader();
        this.senderDescriptors = new LinkedList();
        int offset = 8;
        while (offset < this.length) {
            int cType;
            int classNum = RSVPObject.getClassNum(this.bytes, offset);
            if (classNum == 1) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.session = new SessionIPv4(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.session = new SessionIPv6(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                if (cType == 7) {
                    this.session = new SessionLSPTunnelIPv4(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 3) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.rsvpHop = new RSVPHopIPv4(this.bytes, offset);
                    offset += this.rsvpHop.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.rsvpHop = new RSVPHopIPv6(this.bytes, offset);
                    offset += this.rsvpHop.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 4) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.integrity = new Integrity(this.bytes, offset);
                    offset += this.integrity.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 11) {
                SenderDescriptor sd;
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 7 || cType == 8) {
                    sd = new SenderDescriptorTE();
                    ((SenderDescriptorTE)sd).decode(this.bytes, offset);
                    offset += sd.getLength();
                    this.addSenderDescriptor(sd);
                    continue;
                }
                if (cType == 1 || cType == 2 || cType == 3) {
                    sd = new SenderDescriptor();
                    sd.decode(this.bytes, offset);
                    offset += sd.getLength();
                    this.addSenderDescriptor(sd);
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            throw new RSVPProtocolViolationException();
        }
    }

    public void addSenderDescriptor(SenderDescriptor senderDescriptor) {
        this.senderDescriptors.add(senderDescriptor);
    }

    public Integrity getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(Integrity integrity) {
        this.integrity = integrity;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public RSVPHop getRsvpHop() {
        return this.rsvpHop;
    }

    public void setRsvpHop(RSVPHop rsvpHop) {
        this.rsvpHop = rsvpHop;
    }

    public LinkedList<SenderDescriptor> getSenderDescriptors() {
        return this.senderDescriptors;
    }

    public void setSenderDescriptors(LinkedList<SenderDescriptor> senderDescriptors) {
        this.senderDescriptors = senderDescriptors;
    }
}

