/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.messages;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.SenderDescriptor;
import es.tid.rsvp.messages.RSVPMessage;
import es.tid.rsvp.objects.Integrity;
import es.tid.rsvp.objects.PolicyData;
import es.tid.rsvp.objects.RSVPHop;
import es.tid.rsvp.objects.RSVPHopIPv4;
import es.tid.rsvp.objects.RSVPHopIPv6;
import es.tid.rsvp.objects.RSVPObject;
import es.tid.rsvp.objects.Session;
import es.tid.rsvp.objects.SessionIPv4;
import es.tid.rsvp.objects.SessionIPv6;
import es.tid.rsvp.objects.TimeValues;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSVPPathMessage
extends RSVPMessage {
    protected Integrity integrity;
    protected Session session;
    protected RSVPHop rsvpHop;
    protected TimeValues timeValues;
    protected LinkedList<PolicyData> policyData;
    protected LinkedList<SenderDescriptor> senderDescriptors;
    private static final Logger log = LoggerFactory.getLogger("ROADM");

    public RSVPPathMessage() {
        this.vers = 1;
        this.flags = 0;
        this.msgType = 1;
        this.rsvpChecksum = 255;
        this.sendTTL = 0;
        this.reserved = 0;
        this.length = 8;
        this.policyData = new LinkedList();
        this.senderDescriptors = new LinkedList();
        log.debug("RSVP Path Message Created");
    }

    public RSVPPathMessage(byte[] bytes, int length) throws RSVPProtocolViolationException {
        super(bytes);
        log.debug("RSVP Path Message Created");
        this.decode();
    }

    public RSVPPathMessage(byte[] bytes) throws RSVPProtocolViolationException {
        super(bytes);
        log.debug("RSVP Path Message Created");
        this.decode();
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        int i;
        log.debug("Starting RSVP Path Message encode");
        this.rsvpChecksum = 255;
        this.length = 0;
        int commonHeaderSize = 8;
        this.length += commonHeaderSize;
        if (this.integrity != null) {
            this.integrity.encode();
            this.length += this.integrity.getLength();
            log.debug("Integrity RSVP Object found");
        }
        if (this.session != null) {
            this.session.encode();
            this.length += this.session.getLength();
        } else {
            log.error("Session RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Session RSVP Object found");
        if (this.rsvpHop != null) {
            this.rsvpHop.encode();
            this.length += this.rsvpHop.getLength();
        } else {
            log.error("Hop RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Hop RSVP Object found");
        if (this.timeValues != null) {
            this.timeValues.encode();
            this.length += this.timeValues.getLength();
        } else {
            log.error("Time Values RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Time Values RSVP Object found");
        int pdSize = this.policyData.size();
        for (int i2 = 0; i2 < pdSize; ++i2) {
            PolicyData pd = this.policyData.get(i2);
            pd.encode();
            this.length += pd.getLength();
            log.debug("Policy Data RSVP Object found");
        }
        int sdSize = this.senderDescriptors.size();
        for (int i3 = 0; i3 < sdSize; ++i3) {
            SenderDescriptor sd = this.senderDescriptors.get(i3);
            sd.encode();
            this.length += sd.getLength();
            log.debug("Sender Descriptor RSVP Construct found");
        }
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = commonHeaderSize;
        if (this.integrity != null) {
            System.arraycopy(this.integrity.getBytes(), 0, this.bytes, currentIndex, this.integrity.getLength());
            currentIndex += this.integrity.getLength();
        }
        System.arraycopy(this.session.getBytes(), 0, this.bytes, currentIndex, this.session.getLength());
        System.arraycopy(this.rsvpHop.getBytes(), 0, this.bytes, currentIndex += this.session.getLength(), this.rsvpHop.getLength());
        System.arraycopy(this.timeValues.getBytes(), 0, this.bytes, currentIndex += this.rsvpHop.getLength(), this.timeValues.getLength());
        currentIndex += this.timeValues.getLength();
        for (i = 0; i < pdSize; ++i) {
            PolicyData pd = this.policyData.get(i);
            System.arraycopy(pd.getBytes(), 0, this.bytes, currentIndex, pd.getLength());
            currentIndex += pd.getLength();
        }
        for (i = 0; i < sdSize; ++i) {
            SenderDescriptor sd = this.senderDescriptors.get(i);
            System.arraycopy(sd.getBytes(), 0, this.bytes, currentIndex, sd.getLength());
            currentIndex += sd.getLength();
        }
        log.debug("RSVP Path Message encoding accomplished");
    }

    @Override
    public void decode() throws RSVPProtocolViolationException {
        this.decodeHeader();
        this.policyData = new LinkedList();
        this.senderDescriptors = new LinkedList();
        int offset = 8;
        while (offset < this.length) {
            int cType;
            int classNum = RSVPObject.getClassNum(this.bytes, offset);
            if (classNum == 1) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.session = new SessionIPv4(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.session = new SessionIPv6(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 3) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.rsvpHop = new RSVPHopIPv4(this.bytes, offset);
                    offset += this.rsvpHop.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.rsvpHop = new RSVPHopIPv6(this.bytes, offset);
                    offset += this.rsvpHop.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 4) {
                cType = RSVPObject.getcType(this.bytes, offset);
                this.integrity = new Integrity(this.bytes, offset);
                offset += this.integrity.getLength();
                continue;
            }
            if (classNum == 5) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.timeValues = new TimeValues(this.bytes, offset);
                    offset += this.timeValues.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 14) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    PolicyData pd = new PolicyData(this.bytes, offset);
                    offset += pd.getLength();
                    this.policyData.add(pd);
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 11) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1 || cType == 2 || cType == 3) {
                    SenderDescriptor sd = new SenderDescriptor();
                    sd.decode(this.bytes, offset);
                    offset += sd.getLength();
                    this.addSenderDescriptor(sd);
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            throw new RSVPProtocolViolationException();
        }
    }

    public void addSenderDescriptor(SenderDescriptor senderDescriptor) {
        this.senderDescriptors.add(senderDescriptor);
    }

    public Integrity getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(Integrity integrity) {
        this.integrity = integrity;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public RSVPHop getRsvpHop() {
        return this.rsvpHop;
    }

    public void setRsvpHop(RSVPHop rsvpHop) {
        this.rsvpHop = rsvpHop;
    }

    public TimeValues getTimeValues() {
        return this.timeValues;
    }

    public void setTimeValues(TimeValues timeValues) {
        this.timeValues = timeValues;
    }

    public LinkedList<PolicyData> getPolicyData() {
        return this.policyData;
    }

    public void setPolicyData(LinkedList<PolicyData> policyData) {
        this.policyData = policyData;
    }

    public LinkedList<SenderDescriptor> getSenderDescriptors() {
        return this.senderDescriptors;
    }

    public void setSenderDescriptors(LinkedList<SenderDescriptor> senderDescriptors) {
        this.senderDescriptors = senderDescriptors;
    }
}

