/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.messages;

import es.tid.rsvp.RSVPElement;
import es.tid.rsvp.RSVPProtocolViolationException;
import java.util.Arrays;

public abstract class RSVPMessage
implements RSVPElement {
    protected int vers;
    protected int flags;
    protected int msgType;
    protected int rsvpChecksum;
    protected int sendTTL;
    protected int reserved;
    protected int length;
    protected byte[] bytes;

    public RSVPMessage() {
        this.vers = 1;
        this.flags = 0;
        this.msgType = 1;
        this.rsvpChecksum = 0;
        this.sendTTL = 0;
        this.reserved = 0;
        this.length = 0;
    }

    public RSVPMessage(byte[] bytes_input) {
        this.length = (bytes_input[6] & 0xFF) << 8 & 0xFF00 | bytes_input[7] & 0xFF;
        this.bytes = new byte[this.length];
        System.arraycopy(bytes_input, 0, this.bytes, 0, this.length);
        this.decodeHeader();
    }

    @Override
    public abstract void encode() throws RSVPProtocolViolationException;

    public void decodeHeader() {
        this.vers = this.bytes[0] >> 4 & 0xF;
        this.flags = this.bytes[0] & 0xF;
        this.msgType = this.bytes[1];
        this.rsvpChecksum = this.bytes[2] | this.bytes[3];
        this.sendTTL = this.bytes[4];
        this.reserved = this.bytes[5];
        this.length = (this.bytes[6] & 0xFF) << 8 & 0xFF00 | this.bytes[7] & 0xFF;
    }

    public void encodeHeader() {
        this.bytes[0] = (byte)(this.vers << 4 & 0xF0 | this.flags & 0xF);
        this.bytes[1] = (byte)this.msgType;
        this.bytes[2] = (byte)(this.rsvpChecksum >> 8 & 0xFF);
        this.bytes[3] = (byte)(this.rsvpChecksum & 0xFF);
        this.bytes[4] = (byte)this.sendTTL;
        this.bytes[5] = (byte)this.reserved;
        this.bytes[6] = (byte)(this.length >> 8 & 0xFF);
        this.bytes[7] = (byte)(this.length & 0xFF);
    }

    public abstract void decode() throws RSVPProtocolViolationException;

    public void calculateChecksum() {
        byte[] var = new byte[this.length];
        for (int i = 0; i < this.length; ++i) {
            int m3 = ~this.bytes[i];
            var[i] = (byte)(m3 &= 0xFF);
        }
        int sum = 0;
        for (int j = 0; j < this.length; ++j) {
            sum += var[j];
        }
        this.rsvpChecksum = ~sum & 0xFF;
        this.bytes[2] = (byte)(this.rsvpChecksum >> 8 & 0xFF);
        this.bytes[3] = (byte)(this.rsvpChecksum & 0xFF);
    }

    public int getVers() {
        return this.vers;
    }

    public void setVers(int vers) {
        this.vers = vers;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public int getRsvpChecksum() {
        return this.rsvpChecksum;
    }

    public void setRsvpChecksum(int rsvpChecksum) {
        this.rsvpChecksum = rsvpChecksum;
    }

    public int getSendTTL() {
        return this.sendTTL;
    }

    public void setSendTTL(int sendTTL) {
        this.sendTTL = sendTTL;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int reserved) {
        this.reserved = reserved;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public static int getMsgType(byte[] bytes) {
        return bytes[1];
    }

    public static int getMsgLength(byte[] bytes) {
        return (bytes[6] & 0xFF) << 8 & 0xFF00 | bytes[7] & 0xFF;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes);
        result = 31 * result + this.flags;
        result = 31 * result + this.length;
        result = 31 * result + this.msgType;
        result = 31 * result + this.reserved;
        result = 31 * result + this.rsvpChecksum;
        result = 31 * result + this.sendTTL;
        result = 31 * result + this.vers;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RSVPMessage other = (RSVPMessage)obj;
        if (!Arrays.equals(this.bytes, other.bytes)) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.msgType != other.msgType) {
            return false;
        }
        if (this.reserved != other.reserved) {
            return false;
        }
        if (this.rsvpChecksum != other.rsvpChecksum) {
            return false;
        }
        if (this.sendTTL != other.sendTTL) {
            return false;
        }
        return this.vers == other.vers;
    }
}

