/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.constructs.te;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.SenderDescriptor;
import es.tid.rsvp.objects.IntservADSPEC;
import es.tid.rsvp.objects.IntservSenderTSpec;
import es.tid.rsvp.objects.RRO;
import es.tid.rsvp.objects.RSVPObject;
import es.tid.rsvp.objects.SSONSenderTSpec;
import es.tid.rsvp.objects.SenderTemplate;
import es.tid.rsvp.objects.SenderTemplateLSPTunnelIPv4;
import es.tid.rsvp.objects.SenderTemplateLSPTunnelIPv6;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderDescriptorTE
extends SenderDescriptor {
    private RRO rro;
    private static final Logger log = LoggerFactory.getLogger("ROADM");

    public SenderDescriptorTE() {
        log.debug("Sender Descriptor TE Created");
    }

    public SenderDescriptorTE(SenderTemplate senderTemplate, IntservSenderTSpec senderTSPEC, IntservADSPEC adspec, RRO rro) throws RSVPProtocolViolationException {
        this.senderTemplate = senderTemplate;
        this.senderTSPEC = senderTSPEC;
        this.rro = rro;
        this.adspec = adspec;
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        this.length = 0;
        if (this.senderTemplate != null) {
            this.senderTemplate.encode();
            this.length += this.senderTemplate.getLength();
        } else {
            log.error("Sender Template not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Sender Template found");
        if (this.senderTSPEC != null) {
            this.senderTSPEC.encode();
            this.length += this.senderTSPEC.getLength();
        } else {
            log.error("Intserv Sender TSpec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Intserv Sender TSpec found");
        if (this.adspec != null) {
            this.adspec.encode();
            this.length += this.adspec.getLength();
            log.debug("Intserv ADSPEC found");
        }
        if (this.rro != null) {
            this.rro.encode();
            this.length += this.rro.getLength();
            log.debug("RRO found");
        }
        log.debug("Sender Descriptor TE Created");
        log.debug("Starting Sender Descriptor TE Encode");
        this.bytes = new byte[this.length];
        int offset = 0;
        System.arraycopy(this.senderTemplate.getBytes(), 0, this.bytes, offset, this.senderTemplate.getLength());
        System.arraycopy(this.senderTSPEC.getBytes(), 0, this.bytes, offset += this.senderTemplate.getLength(), this.senderTSPEC.getLength());
        offset += this.senderTSPEC.getLength();
        if (this.adspec != null) {
            System.arraycopy(this.adspec.getBytes(), 0, this.bytes, offset, this.adspec.getLength());
            offset += this.adspec.getLength();
        }
        if (this.rro != null) {
            System.arraycopy(this.rro.getBytes(), 0, this.bytes, offset, this.rro.getLength());
        }
        log.debug("Encoding Sender Descriptor TE Accomplished");
    }

    @Override
    public void decode(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        log.debug("Starting Sender Descriptor TE Decode");
        int classNum = RSVPObject.getClassNum(bytes, offset);
        int cType = RSVPObject.getcType(bytes, offset);
        this.length = 0;
        int bytesLeft = bytes.length - offset;
        if (classNum == 11) {
            if (cType == 7) {
                this.senderTemplate = new SenderTemplateLSPTunnelIPv4(bytes, offset);
            } else if (cType == 8) {
                this.senderTemplate = new SenderTemplateLSPTunnelIPv6(bytes, offset);
            } else {
                log.error("Malformed Sender Template cType field");
                throw new RSVPProtocolViolationException();
            }
            this.length += this.senderTemplate.getLength();
            offset += this.senderTemplate.getLength();
        } else {
            log.error("Sender Template not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Sender Template decoded");
        if ((bytesLeft -= this.senderTemplate.getLength()) <= 0) {
            log.error("Incomplete Sender Descriptor");
            throw new RSVPProtocolViolationException();
        }
        classNum = RSVPObject.getClassNum(bytes, offset);
        cType = RSVPObject.getcType(bytes, offset);
        if (classNum == 12) {
            if (cType == 2) {
                this.senderTSPEC = new IntservSenderTSpec(bytes, offset);
            } else if (cType == 8) {
                this.senderTSPEC = new SSONSenderTSpec(bytes, offset);
            } else {
                log.error("Malformed Sender TSPEC cType field");
                throw new RSVPProtocolViolationException();
            }
            offset += this.senderTSPEC.getLength();
            this.length += this.senderTSPEC.getLength();
        } else {
            log.error("Sender TSPEC not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Sender TSPEC decoded");
        if ((bytesLeft -= this.senderTSPEC.getLength()) > 0) {
            classNum = RSVPObject.getClassNum(bytes, offset);
            cType = RSVPObject.getcType(bytes, offset);
            if (classNum == 13) {
                if (cType != 2) {
                    log.error("Malformed ADSPEC cType field");
                    throw new RSVPProtocolViolationException();
                }
                this.adspec = new IntservADSPEC(bytes, offset);
                offset += this.adspec.getLength();
                this.length += this.adspec.getLength();
                log.debug("ADSPEC decoded");
            }
        }
        if (bytesLeft > 0) {
            classNum = RSVPObject.getClassNum(bytes, offset);
            cType = RSVPObject.getcType(bytes, offset);
            if (classNum == 21) {
                if (cType != 1) {
                    log.error("Malformed RRO cType field");
                    throw new RSVPProtocolViolationException();
                }
                this.rro = new RRO(bytes, offset);
                offset += this.rro.getLength();
                this.length += this.rro.getLength();
                log.debug("RRO decoded");
            }
        }
        this.setLength(this.length);
        log.debug("Decoding Sender Descriptor TE Accomplished");
    }

    public RRO getRro() {
        return this.rro;
    }

    public void setRro(RRO rro) {
        this.rro = rro;
    }
}

