/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.constructs.te;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.RSVPConstruct;
import es.tid.rsvp.objects.FilterSpec;
import es.tid.rsvp.objects.FilterSpecLSPTunnelIPv4;
import es.tid.rsvp.objects.FilterSpecLSPTunnelIPv6;
import es.tid.rsvp.objects.Label;
import es.tid.rsvp.objects.RRO;
import es.tid.rsvp.objects.RSVPObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterSpecTE
extends RSVPConstruct {
    private FilterSpec filterSpec;
    private Label label;
    private RRO rro;
    private static final Logger log = LoggerFactory.getLogger("ROADM");

    public FilterSpecTE() {
        log.debug("SE Filter Spec Created");
    }

    public FilterSpecTE(FilterSpec filterSpec, Label label, RRO rro) throws RSVPProtocolViolationException {
        if (filterSpec != null) {
            this.length += filterSpec.getLength();
        } else {
            log.error("Filter Spec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        this.filterSpec = filterSpec;
        log.debug("Filter Spec found");
        if (label != null) {
            this.length += label.getLength();
        } else {
            log.error("Label not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        this.label = label;
        log.debug("Label found");
        if (rro != null) {
            this.length += rro.getLength();
            this.rro = rro;
            log.debug("RRO found");
        }
        log.debug("FilterSpec Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        log.debug("Starting Filter Spec Construct Encode");
        this.bytes = new byte[this.length];
        int offset = 0;
        if (this.filterSpec != null) {
            this.filterSpec.encode();
            System.arraycopy(this.filterSpec.getBytes(), 0, this.bytes, offset, this.filterSpec.getLength());
            offset += this.filterSpec.getLength();
        } else {
            log.error("Mandatory field Filter Spec not found");
            throw new RSVPProtocolViolationException();
        }
        if (this.label != null) {
            this.label.encode();
            System.arraycopy(this.label.getBytes(), 0, this.bytes, offset, this.label.getLength());
            offset += this.label.getLength();
        } else {
            log.error("Mandatory field Label not found");
            throw new RSVPProtocolViolationException();
        }
        if (this.rro != null) {
            this.rro.encode();
            System.arraycopy(this.rro.getBytes(), 0, this.bytes, offset, this.rro.getLength());
            offset += this.rro.getLength();
        }
        log.debug("Encoding Filter Spec Construct Accomplished");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void decode(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        log.debug("Filter Spec Construct Decode");
        int classNum = RSVPObject.getClassNum(bytes, offset);
        int cType = RSVPObject.getcType(bytes, offset);
        int length = 0;
        int bytesLeft = bytes.length - offset;
        if (classNum != 10) {
            log.error("Malformed Filter Spec, Filter Spec object not found");
            throw new RSVPProtocolViolationException();
        }
        if (cType == 7) {
            this.filterSpec = new FilterSpecLSPTunnelIPv4(bytes, offset);
        } else {
            if (cType != 8) {
                log.error("Malformed Filter Spec cType field");
                throw new RSVPProtocolViolationException();
            }
            this.filterSpec = new FilterSpecLSPTunnelIPv6(bytes, offset);
        }
        length += this.filterSpec.getLength();
        bytesLeft -= this.filterSpec.getLength();
        log.debug("Filter Spec decoded");
        classNum = RSVPObject.getClassNum(bytes, offset += this.filterSpec.getLength());
        cType = RSVPObject.getcType(bytes, offset);
        if (classNum != 16) {
            log.error("Malformed Filter Spec, Label object not found");
            throw new RSVPProtocolViolationException();
        }
        if (cType != 1) {
            log.error("Malformed Label cType field");
            throw new RSVPProtocolViolationException();
        }
        this.label = new Label(bytes, offset);
        offset += this.label.getLength();
        length += this.label.getLength();
        bytesLeft -= this.label.getLength();
        log.debug("Label decoded");
        if (classNum == 21) {
            if (cType != 1) {
                log.error("Malformed RRO cType field");
                throw new RSVPProtocolViolationException();
            }
            this.rro = new RRO(bytes, offset);
            offset += this.rro.getLength();
            length += this.rro.getLength();
            bytesLeft -= this.rro.getLength();
            log.debug("RRO decoded");
        }
        this.setLength(length);
        log.debug("Decoding Filter Spec Accomplished");
    }

    public FilterSpec getFilterSpec() {
        return this.filterSpec;
    }

    public void setFilterSpec(FilterSpec filterSpec) {
        this.filterSpec = filterSpec;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public RRO getRro() {
        return this.rro;
    }

    public void setRro(RRO rro) {
        this.rro = rro;
    }
}

