/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.constructs.te;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.FFFlowDescriptor;
import es.tid.rsvp.objects.FilterSpec;
import es.tid.rsvp.objects.FilterSpecLSPTunnelIPv4;
import es.tid.rsvp.objects.FilterSpecLSPTunnelIPv6;
import es.tid.rsvp.objects.FlowSpec;
import es.tid.rsvp.objects.Label;
import es.tid.rsvp.objects.RRO;
import es.tid.rsvp.objects.RSVPObject;
import es.tid.rsvp.objects.gmpls.GeneralizedLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFFlowDescriptorTE
extends FFFlowDescriptor {
    private Label label;
    private RRO rro;
    private static final Logger log = LoggerFactory.getLogger("ROADM");
    private boolean first;

    public FFFlowDescriptorTE(boolean first) {
        super(first);
        this.first = first;
        log.debug("FF Flow Descriptor Created");
    }

    public FFFlowDescriptorTE(FlowSpec flowSpec, FilterSpec filterSpec, Label label, RRO rro, boolean first) throws RSVPProtocolViolationException {
        super(first);
        this.first = first;
        if (first) {
            if (flowSpec != null) {
                this.length += flowSpec.getLength();
                this.flowSpec = flowSpec;
                log.debug("Flow Spec found");
            } else {
                log.error("Flow Spec not found, It is mandatory");
                throw new RSVPProtocolViolationException();
            }
        }
        if (filterSpec != null) {
            this.length += filterSpec.getLength();
        } else {
            log.error("Filter Spec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        this.filterSpec = filterSpec;
        log.debug("Filter Spec found");
        if (label != null) {
            this.length += label.getLength();
        } else {
            log.error("Label not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        this.label = label;
        log.debug("Label found");
        if (rro != null) {
            this.length += rro.getLength();
            this.rro = rro;
            log.debug("RRO found");
        }
        log.debug("FF Flow Descriptor TE Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        log.debug("Starting FF Flow Descriptor TE Encode");
        this.bytes = new byte[this.length];
        int offset = 0;
        if (this.flowSpec != null) {
            this.flowSpec.encode();
            System.arraycopy(this.flowSpec.getBytes(), 0, this.bytes, offset, this.flowSpec.getLength());
            offset += this.flowSpec.getLength();
        } else if (this.first) {
            log.error("Mandatory field Flow Spec not found");
            throw new RSVPProtocolViolationException();
        }
        if (this.filterSpec != null) {
            this.filterSpec.encode();
            System.arraycopy(this.filterSpec.getBytes(), 0, this.bytes, offset, this.filterSpec.getLength());
            offset += this.filterSpec.getLength();
        } else {
            log.error("Mandatory field Filter Spec not found");
            throw new RSVPProtocolViolationException();
        }
        if (this.label != null) {
            this.label.encode();
            System.arraycopy(this.label.getBytes(), 0, this.bytes, offset, this.label.getLength());
            offset += this.label.getLength();
        } else {
            log.error("Mandatory field Label not found");
            throw new RSVPProtocolViolationException();
        }
        if (this.rro != null) {
            this.rro.encode();
            System.arraycopy(this.rro.getBytes(), 0, this.bytes, offset, this.rro.getLength());
            offset += this.rro.getLength();
        }
        log.debug("Encoding FF Flow Descriptor Accomplished");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void decode(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        log.debug("FF Flow Descriptor TE Decode");
        int classNum = RSVPObject.getClassNum(bytes, offset);
        int cType = RSVPObject.getcType(bytes, offset);
        int length = 0;
        int bytesLeft = bytes.length - offset;
        if (classNum == 9) {
            if (cType != 2) {
                log.error("Malformed Flow Spec cType field");
                throw new RSVPProtocolViolationException();
            }
            this.flowSpec = new FlowSpec(bytes, offset);
            offset += this.flowSpec.getLength();
            length += this.flowSpec.getLength();
            bytesLeft -= this.flowSpec.getLength();
            log.debug("Flow Spec decoded");
        }
        if (bytesLeft <= 0) {
            log.error("Filter Spec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        classNum = RSVPObject.getClassNum(bytes, offset);
        cType = RSVPObject.getcType(bytes, offset);
        if (classNum != 10) {
            log.error("Filter Spec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        if (cType == 7) {
            this.filterSpec = new FilterSpecLSPTunnelIPv4(bytes, offset);
            offset += this.filterSpec.getLength();
            length += this.filterSpec.getLength();
            bytesLeft -= this.filterSpec.getLength();
        } else {
            if (cType != 8) {
                log.error("Malformed Filter Spec cType field");
                throw new RSVPProtocolViolationException();
            }
            this.filterSpec = new FilterSpecLSPTunnelIPv6(bytes, offset);
            offset += this.filterSpec.getLength();
            length += this.filterSpec.getLength();
            bytesLeft -= this.filterSpec.getLength();
        }
        log.debug("Flow Spec decoded");
        if (bytesLeft <= 0) {
            log.error("Label not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        classNum = RSVPObject.getClassNum(bytes, offset);
        cType = RSVPObject.getcType(bytes, offset);
        if (classNum != 16) {
            log.error("Label not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        if (cType == 1) {
            this.label = new Label(bytes, offset);
            offset += this.label.getLength();
            length += this.label.getLength();
            bytesLeft -= this.label.getLength();
        } else {
            if (cType != 2) {
                log.error("Malformed Label cType field");
                throw new RSVPProtocolViolationException();
            }
            this.label = new GeneralizedLabel(bytes, offset);
            offset += this.label.getLength();
            length += this.label.getLength();
            bytesLeft -= this.label.getLength();
        }
        log.debug("Label decoded");
        if (bytesLeft > 0) {
            classNum = RSVPObject.getClassNum(bytes, offset);
            cType = RSVPObject.getcType(bytes, offset);
            if (classNum == 21) {
                if (cType != 1) {
                    log.error("Malformed RRO cType field");
                    throw new RSVPProtocolViolationException();
                }
                this.rro = new RRO(bytes, offset);
                offset += this.rro.getLength();
                length += this.rro.getLength();
                log.debug("RRO decoded");
            }
        }
        this.setLength(length);
        log.debug("Decoding FF Flow Descriptor TE Accomplished");
    }

    @Override
    public FlowSpec getFlowSpec() {
        return this.flowSpec;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public RRO getRro() {
        return this.rro;
    }

    public void setRro(RRO rro) {
        this.rro = rro;
    }

    @Override
    public void setFlowSpec(FlowSpec flowSpec) {
        this.flowSpec = flowSpec;
    }

    @Override
    public FilterSpec getFilterSpec() {
        return this.filterSpec;
    }

    @Override
    public void setFilterSpec(FilterSpec filterSpec) {
        this.filterSpec = filterSpec;
    }
}

