/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.constructs;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.RSVPConstruct;
import es.tid.rsvp.objects.FlowLabelSenderTemplateIPv6;
import es.tid.rsvp.objects.IntservADSPEC;
import es.tid.rsvp.objects.IntservSenderTSpec;
import es.tid.rsvp.objects.RSVPObject;
import es.tid.rsvp.objects.SSONSenderTSpec;
import es.tid.rsvp.objects.SenderTSpec;
import es.tid.rsvp.objects.SenderTemplate;
import es.tid.rsvp.objects.SenderTemplateIPv4;
import es.tid.rsvp.objects.SenderTemplateIPv6;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderDescriptor
extends RSVPConstruct {
    protected SenderTemplate senderTemplate;
    protected SenderTSpec senderTSPEC;
    protected IntservADSPEC adspec;
    private static final Logger log = LoggerFactory.getLogger("ROADM");

    public SenderDescriptor() {
        log.debug("Sender Descriptor Created");
    }

    public SenderDescriptor(SenderTemplate senderTemplate, IntservSenderTSpec senderTSPEC, IntservADSPEC adspec) throws RSVPProtocolViolationException {
        if (senderTemplate != null) {
            this.length += senderTemplate.getLength();
        } else {
            log.error("Sender Template not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        this.senderTemplate = senderTemplate;
        log.debug("Sender Template found");
        if (senderTSPEC != null) {
            this.length += senderTSPEC.getLength();
        } else {
            log.error("Intserv Sender TSpec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        this.senderTSPEC = senderTSPEC;
        log.debug("Intserv Sender TSpec found");
        if (adspec != null) {
            this.adspec = adspec;
            this.length += adspec.getLength();
            log.debug("Intserv ADSPEC found");
        }
        log.debug("Sender Descriptor Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        this.length = 0;
        log.debug("Starting Sender Descriptor Encode");
        if (this.senderTemplate != null) {
            this.senderTemplate.encode();
            this.length += this.senderTemplate.getLength();
        } else {
            log.error("Sender Template not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        if (this.senderTSPEC != null) {
            this.senderTSPEC.encode();
            this.length += this.senderTSPEC.getLength();
        } else {
            log.error("Intserv Sender TSpec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Intserv Sender TSpec found");
        if (this.adspec != null) {
            this.adspec.encode();
            this.length += this.adspec.getLength();
            log.debug("Intserv ADSPEC found");
        }
        this.bytes = new byte[this.length];
        int offset = 0;
        System.arraycopy(this.senderTemplate.getBytes(), 0, this.bytes, offset, this.senderTemplate.getLength());
        System.arraycopy(this.senderTSPEC.getBytes(), 0, this.bytes, offset += this.senderTemplate.getLength(), this.senderTSPEC.getLength());
        offset += this.senderTSPEC.getLength();
        if (this.adspec != null) {
            System.arraycopy(this.adspec.getBytes(), 0, this.bytes, offset, this.adspec.getLength());
        }
        log.debug("Encoding Sender Descriptor Accomplished");
    }

    @Override
    public void decode(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        log.debug("Starting Sender Descriptor Decode");
        int classNum = RSVPObject.getClassNum(bytes, offset);
        int cType = RSVPObject.getcType(bytes, offset);
        int length = 0;
        int bytesLeft = bytes.length - offset;
        if (classNum == 11) {
            if (cType == 1) {
                this.senderTemplate = new SenderTemplateIPv4(bytes, offset);
            } else if (cType == 2) {
                this.senderTemplate = new SenderTemplateIPv6(bytes, offset);
            } else if (cType == 3) {
                this.senderTemplate = new FlowLabelSenderTemplateIPv6(bytes, offset);
            } else {
                log.error("Malformed Sender Template cType field");
                throw new RSVPProtocolViolationException();
            }
            offset += this.senderTemplate.getLength();
            length += this.senderTemplate.getLength();
        } else {
            log.error("Sender Template not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Sender Template decoded");
        if ((bytesLeft -= this.senderTemplate.getLength()) <= 0) {
            log.error("Incomplete Sender Descriptor");
            throw new RSVPProtocolViolationException();
        }
        classNum = RSVPObject.getClassNum(bytes, offset);
        cType = RSVPObject.getcType(bytes, offset);
        if (classNum == 12) {
            if (cType == 2) {
                this.senderTSPEC = new IntservSenderTSpec();
            } else if (cType == 8) {
                this.senderTSPEC = new SSONSenderTSpec(bytes, offset);
            } else {
                log.error("Malformed Sender TSPEC cType field");
                throw new RSVPProtocolViolationException();
            }
            offset += this.senderTSPEC.getLength();
            length += this.senderTSPEC.getLength();
        } else {
            log.error("Sender Template not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Sender TSPEC decoded");
        if ((bytesLeft -= this.senderTSPEC.getLength()) > 0) {
            classNum = RSVPObject.getClassNum(bytes, offset);
            cType = RSVPObject.getcType(bytes, offset);
            if (classNum == 13) {
                if (cType != 2) {
                    log.error("Malformed ADSPEC cType field");
                    throw new RSVPProtocolViolationException();
                }
                this.adspec = new IntservADSPEC(bytes, offset);
                offset += this.adspec.getLength();
                length += this.adspec.getLength();
                log.debug("ADSPEC decoded");
            }
        }
        this.setLength(length);
        log.debug("Decoding Sender Descriptor Accomplished");
    }

    public SenderTemplate getSenderTemplate() {
        return this.senderTemplate;
    }

    public void setSenderTemplate(SenderTemplate senderTemplate) {
        this.senderTemplate = senderTemplate;
    }

    public SenderTSpec getSenderTSPEC() {
        return this.senderTSPEC;
    }

    public void setSenderTSPEC(SenderTSpec senderTSPEC) {
        this.senderTSPEC = senderTSPEC;
    }

    public IntservADSPEC getAdspec() {
        return this.adspec;
    }

    public void setAdspec(IntservADSPEC adspec) {
        this.adspec = adspec;
    }
}

