/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.constructs;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.FlowDescriptor;
import es.tid.rsvp.objects.FilterSpec;
import es.tid.rsvp.objects.FilterSpecIPv4;
import es.tid.rsvp.objects.FilterSpecIPv6;
import es.tid.rsvp.objects.FlowLabelFilterSpecIPv6;
import es.tid.rsvp.objects.FlowSpec;
import es.tid.rsvp.objects.RSVPObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFFlowDescriptor
extends FlowDescriptor {
    protected FlowSpec flowSpec;
    protected FilterSpec filterSpec;
    private static final Logger log = LoggerFactory.getLogger("ROADM");
    private boolean first;

    public FFFlowDescriptor(boolean first) {
        this.first = first;
        log.debug("FF Flow Descriptor Created");
    }

    public FFFlowDescriptor(FlowSpec flowSpec, FilterSpec filterSpec, boolean first) throws RSVPProtocolViolationException {
        this.first = first;
        if (flowSpec != null) {
            this.length += flowSpec.getLength();
        } else {
            log.error("Flow Spec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        this.flowSpec = flowSpec;
        log.debug("Flow Spec found");
        if (filterSpec != null) {
            this.length += filterSpec.getLength();
        } else {
            log.error("Filter Spec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        this.filterSpec = filterSpec;
        log.debug("Filter Spec found");
        log.debug("FF Flow Descriptor Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        log.debug("Starting WF Flow Descriptor Encode");
        this.bytes = new byte[this.length];
        int offset = 0;
        if (this.flowSpec != null) {
            this.flowSpec.encode();
            System.arraycopy(this.flowSpec.getBytes(), 0, this.bytes, offset, this.flowSpec.getLength());
            offset += this.flowSpec.getLength();
        } else if (this.first) {
            log.error("Mandatory field Flow Spec not found");
            throw new RSVPProtocolViolationException();
        }
        if (this.filterSpec != null) {
            this.filterSpec.encode();
            System.arraycopy(this.filterSpec.getBytes(), 0, this.bytes, offset, this.filterSpec.getLength());
            offset += this.filterSpec.getLength();
        } else {
            log.error("Mandatory field Filter Spec not found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Encoding FF Flow Descriptor Accomplished");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void decode(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        log.debug("FF Flow Descriptor Decode");
        int classNum = RSVPObject.getClassNum(bytes, offset);
        int cType = RSVPObject.getcType(bytes, offset);
        int length = 0;
        int bytesLeft = bytes.length - offset;
        if (classNum == 9) {
            if (cType != 2) {
                log.error("Malformed Flow Spec cType field");
                throw new RSVPProtocolViolationException();
            }
            this.flowSpec = new FlowSpec(bytes, offset);
            offset += this.flowSpec.getLength();
            length += this.flowSpec.getLength();
            bytesLeft -= this.flowSpec.getLength();
            log.debug("Sender Template decoded");
        }
        if (bytesLeft <= 0) {
            log.error("Flow Spec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        classNum = RSVPObject.getClassNum(bytes, offset);
        cType = RSVPObject.getcType(bytes, offset);
        if (classNum != 10) {
            log.error("Flow Spec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        if (cType == 1) {
            this.filterSpec = new FilterSpecIPv4(bytes, offset);
            offset += this.filterSpec.getLength();
            length += this.filterSpec.getLength();
            bytesLeft -= this.filterSpec.getLength();
        } else if (cType == 2) {
            this.filterSpec = new FilterSpecIPv6(bytes, offset);
            offset += this.filterSpec.getLength();
            length += this.filterSpec.getLength();
            bytesLeft -= this.filterSpec.getLength();
        } else {
            if (cType != 3) {
                log.error("Malformed Filter Spec cType field");
                throw new RSVPProtocolViolationException();
            }
            this.filterSpec = new FlowLabelFilterSpecIPv6(bytes, offset);
            offset += this.filterSpec.getLength();
            length += this.filterSpec.getLength();
            bytesLeft -= this.filterSpec.getLength();
        }
        log.debug("Flow Template decoded");
        this.setLength(length);
        log.debug("Decoding FF Flow Descriptor Accomplished");
    }

    public FlowSpec getFlowSpec() {
        return this.flowSpec;
    }

    public void setFlowSpec(FlowSpec flowSpec) {
        this.flowSpec = flowSpec;
    }

    public FilterSpec getFilterSpec() {
        return this.filterSpec;
    }

    public void setFilterSpec(FilterSpec filterSpec) {
        this.filterSpec = filterSpec;
    }
}

