/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server.management;

import es.tid.pce.server.DomainPCEServer;
import es.tid.pce.server.management.PCEManagementSession;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEManagementSever
extends Thread {
    private Logger log = LoggerFactory.getLogger("PCEServer");
    private DomainPCEServer domainPCEServer;
    private ServerSocket serverSocket;
    private boolean listening = true;

    public PCEManagementSever(DomainPCEServer domainPCEServer) {
        this.domainPCEServer = domainPCEServer;
    }

    @Override
    public void run() {
        try {
            this.log.info("Listening on port " + this.domainPCEServer.getParams().getPCEManagementPort());
            this.serverSocket = new ServerSocket(this.domainPCEServer.getParams().getPCEManagementPort(), 0, (Inet4Address)InetAddress.getByName(this.domainPCEServer.getParams().getLocalPceAddress()));
        }
        catch (Exception e) {
            this.log.error("Could not listen management on port " + this.domainPCEServer.getParams().getPCEManagementPort());
            e.printStackTrace();
            return;
        }
        try {
            while (this.listening) {
                new PCEManagementSession(this.serverSocket.accept(), this.domainPCEServer).start();
            }
            this.serverSocket.close();
        }
        catch (SocketException e) {
            if (!this.listening) {
                this.log.info("Socket closed due to controlled close");
            } else {
                this.log.error("Problem with the socket, exiting");
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopServer() {
        this.listening = false;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

