/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server.management;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPIntiatedLSP;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.constructs.UpdateRequest;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.pcep.messages.PCEPReport;
import es.tid.pce.pcep.messages.PCEPUpdate;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.LSP;
import es.tid.pce.pcep.objects.SRP;
import es.tid.pce.pcep.objects.subobjects.SREROSubobject;
import es.tid.pce.pcep.objects.tlvs.IPv4LSPIdentifiersTLV;
import es.tid.pce.pcep.objects.tlvs.LSPDatabaseVersionTLV;
import es.tid.pce.pcep.objects.tlvs.SymbolicPathNameTLV;
import es.tid.pce.server.DomainPCEServer;
import es.tid.pce.server.DomainPCESession;
import es.tid.pce.utils.StringToPCEP;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.util.UtilsFunctions;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEManagementSession
extends Thread {
    private boolean started = false;
    private Socket socket;
    private Logger log;
    private DomainPCEServer domainPCEServer;
    private PrintStream out;
    public static ArrayList<DomainPCESession> oneSession = new ArrayList();

    public PCEManagementSession(Socket s2, DomainPCEServer domainPCEServer) {
        this.socket = s2;
        this.domainPCEServer = domainPCEServer;
        this.log = LoggerFactory.getLogger("PCEServer");
    }

    @Override
    public void run() {
        this.log.info("Starting Management session");
        boolean running = true;
        try {
            this.out = new PrintStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            this.log.warn("Management session cancelled: " + e.getMessage());
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            while (running) {
                if (!this.started) {
                    this.out.print("\n");
                    this.out.print("   P               ,\r\n");
                    this.out.print("   C               |'.             ,\r\n");
                    this.out.print("   E               |  '-._        / )\r\n");
                    this.out.print("                 .'  .._  ',     /_'-,\r\n");
                    this.out.print("   C            '   /  _'.'_\\   /._)')\r\n");
                    this.out.print("   O           :   /  '_' '_'  /  _.'\r\n");
                    this.out.print("   N           |E |   |Q| |Q| /   /\r\n");
                    this.out.print("   T          .'  _\\  '-' '-'    /\r\n");
                    this.out.print("   R        .'--.(S     ,__` )  /\r\n");
                    this.out.print("   O              '-.     _.'  /\r\n");
                    this.out.print("   L            __.--'----(   /\r\n");
                    this.out.print("   L        _.-'     :   __\\ /\r\n");
                    this.out.print("   E       (      __.' :'  :Y\r\n");
                    this.out.print("   R        '.   '._,  :   :|\r\n");
                    this.out.print("              '.     ) :.__:|\r\n");
                    this.out.print("                \\    \\______/\r\n");
                    this.out.print("                 '._L/_H____]\r\n");
                    this.out.print("                  /_        /\r\n");
                    this.out.print("                 /  '-.__.-')\r\n");
                    this.out.print("                :      /   /\r\n");
                    this.out.print("                :     /   /\r\n");
                    this.out.print("              ,/_____/----;\r\n");
                    this.out.print("              '._____)----'\r\n");
                    this.out.print("              /     /   /\r\n");
                    this.out.print("             /     /   /\r\n");
                    this.out.print("           .'     /    \\\r\n");
                    this.out.print("          (______(-.____)\r\n");
                    this.out.print("***********************************************\n");
                    this.started = true;
                }
                this.out.print("Available commands:\r\n\n");
                this.out.print("\t0) show pcep sessions");
                this.out.print("\t1) show parent pce\r\n");
                this.out.print("\t2) show algorithms list\r\n");
                this.out.print("\t3) show topology\r\n");
                this.out.print("\t4) queue size\r\n");
                this.out.print("\t5) res size\r\n");
                this.out.print("\t6) show reachability\r\n");
                this.out.print("\t7) show lsps\r\n");
                this.out.print("\t8) send FAKE initiate\r\n");
                this.out.print("\t9) send report\r\n");
                this.out.print("\t10) send update \r\n");
                this.out.print("\n\tENTER) quit\r\n");
                this.out.print("PCE:>");
                String command = null;
                this.log.debug("Waiting for command ");
                try {
                    command = br.readLine();
                }
                catch (IOException ioe) {
                    this.log.warn("IO error trying to read your command");
                    return;
                }
                this.log.debug("read command " + command);
                if (command == null) continue;
                if (command.equals("quit") || command.equals("")) {
                    this.log.info("Ending Management Session");
                    this.out.println("bye!");
                    try {
                        this.out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        br.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (command.equals("show pcep sessions")) {
                    this.out.print(this.domainPCEServer.getPcepSessionsInformation().toString());
                    this.out.print("\r\n");
                    continue;
                }
                if (command.startsWith("update lsp")) {
                    this.update(command.substring(11));
                    this.out.print("\rUpdate sent");
                    this.out.print("\r\n");
                    continue;
                }
                if (command.startsWith("terminate lsp")) {
                    this.terminate(command.substring(14));
                    this.out.print("\rTerminate sent");
                    this.out.print("\r\n");
                    continue;
                }
                if (command.startsWith("initiate lsp")) {
                    this.initiate(command.substring(13));
                    this.out.print("\rUpdate sent");
                    this.out.print("\r\n");
                    continue;
                }
                if (command.equals("show parent pce") || command.equals("1") || command.equals("show topology") || command.equals("3")) continue;
                if (command.equals("queue size") || command.equals("4")) {
                    this.out.println("num pets " + this.domainPCEServer.getPCCRequestDispatcher().queueSize());
                    this.out.println("num petsR " + this.domainPCEServer.getPCCRequestDispatcher().retryQueueSize());
                    continue;
                }
                if (command.equals("res size") || command.equals("5") || command.equals("show reachability") || command.equals("6")) continue;
                if (command.equals("show lsps") || command.equals("7")) {
                    this.out.println("Enjoy watching the LSPs the PCE has in his database");
                    this.out.println(this.domainPCEServer.getSingleDomainLSPDB().toString());
                    continue;
                }
                if (command.equals("send initiate") || command.equals("8")) {
                    this.out.println("Sending between 192.168.1.1 and 192.168.1.4");
                    String string_ip_source = "192.168.1.1";
                    String string_ip_dest = "192.168.1.3";
                    Inet4Address ip_source = (Inet4Address)InetAddress.getByName(string_ip_source);
                    Inet4Address ip_dest = (Inet4Address)InetAddress.getByName(string_ip_dest);
                    PCEPInitiate pceInit = new PCEPInitiate();
                    PCEPIntiatedLSP pcepIntiatedLSPList = new PCEPIntiatedLSP();
                    SRP rsp = new SRP();
                    pcepIntiatedLSPList.setRsp(rsp);
                    LSP lsp = new LSP();
                    lsp.setLspId(0);
                    pcepIntiatedLSPList.setLsp(lsp);
                    EndPointsIPv4 endP_IP = new EndPointsIPv4();
                    endP_IP.setSourceIP(ip_source);
                    endP_IP.setDestIP(ip_dest);
                    pcepIntiatedLSPList.setEndPoint(endP_IP);
                    ExplicitRouteObject ero = new ExplicitRouteObject();
                    UnnumberIfIDEROSubobject eroso1 = new UnnumberIfIDEROSubobject();
                    eroso1.setInterfaceID(1L);
                    eroso1.setRouterID(ip_source);
                    UnnumberIfIDEROSubobject eroso2 = new UnnumberIfIDEROSubobject();
                    eroso2.setInterfaceID(3L);
                    eroso2.setRouterID(ip_dest);
                    IPv4prefixEROSubobject eroso3 = new IPv4prefixEROSubobject();
                    eroso3.setIpv4address((Inet4Address)InetAddress.getByName("192.168.1.4"));
                    eroso3.setPrefix(32);
                    ero.addEROSubobject(eroso1);
                    ero.addEROSubobject(eroso2);
                    ero.addEROSubobject(eroso3);
                    pcepIntiatedLSPList.setEro(ero);
                    pceInit.getPcepIntiatedLSPList().add(pcepIntiatedLSPList);
                    continue;
                }
                if (command.equals("send report")) {
                    this.log.info("Sending Repoooort");
                    PCEPReport rpt = new PCEPReport();
                    rpt.setStateReportList(new LinkedList<StateReport>());
                    rpt.getStateReportList().add(new StateReport());
                    rpt.getStateReportList().get(0).setLsp(new LSP());
                    rpt.getStateReportList().get(0).setSrp(new SRP());
                    rpt.getStateReportList().get(0).setPath(new Path());
                    rpt.getStateReportList().get(0).getPath().setEro(new ExplicitRouteObject());
                    try {
                        rpt.encode();
                    }
                    catch (PCEPProtocolViolationException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (command.startsWith("create candidatepath")) {
                    this.createCandidatePath(command.substring(20));
                    this.out.print("\rCreating candidate Path");
                    this.out.print("\r\n");
                    continue;
                }
                if (command.startsWith("delete candidatepath")) {
                    this.deleteCandidatePath(command.substring(20));
                    this.out.print("\rDeleting candidate Path");
                    this.out.print("\r\n");
                    continue;
                }
                if (command.startsWith("initiatewp")) {
                    this.initiatewp(command.substring(10));
                    this.out.print("\rCreating working or protecting lsp");
                    this.out.print("\r\n");
                    continue;
                }
                if (command.equals("help")) {
                    this.out.print("1) show parent pce\r\n");
                    this.out.print("2) show algorithms list\r\n");
                    this.out.print("3) show topology\r\n");
                    this.out.print("4) queue size\r\n");
                    this.out.print("5) res size\r\n");
                    this.out.print("6) show reachability\r\n");
                    this.out.print("7) show lsps\r\n");
                    this.out.print("8) send initiate\r\n");
                    this.out.print("9) send report\r\n");
                    this.out.print("10) send update \r\n");
                    this.out.print("0) quit\r\n");
                    continue;
                }
                this.out.print("invalid command\n");
                this.out.print("\n");
            }
        }
        catch (Exception e) {
            this.log.info(UtilsFunctions.exceptionToString(e));
            return;
        }
    }

    private void initiatewp(String inir) {
        Inet4Address ipp;
        int offset = 0;
        this.log.info("parsing " + inir);
        StringTokenizer st = new StringTokenizer(inir, " ");
        String name = st.nextToken();
        offset += name.length() + 1;
        String exclude = st.nextToken();
        offset += exclude.length() + 1;
        String id = st.nextToken();
        offset += id.length() + 1;
        String pcc = st.nextToken();
        Inet4Address ip_pcc = null;
        try {
            ip_pcc = (Inet4Address)Inet4Address.getByName(pcc);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        offset += pcc.length() + 1;
        EndPointsIPv4 ep = new EndPointsIPv4();
        String src_ip = st.nextToken();
        try {
            ipp = (Inet4Address)Inet4Address.getByName(src_ip);
            ep.setSourceIP(ipp);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String dst_ip = st.nextToken();
        try {
            ipp = (Inet4Address)Inet4Address.getByName(dst_ip);
            ep.setDestIP(ipp);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.log.info("parsing ero " + inir.substring(offset += src_ip.length() + 1 + dst_ip.length() + 1));
        ExplicitRouteObject ero = StringToPCEP.stringToExplicitRouteObject(inir.substring(offset));
        int signalingType = 0;
        if (ero.getEROSubobjectList().getFirst() instanceof SREROSubobject) {
            signalingType = 1;
        }
        this.domainPCEServer.getIniManager().initiateLSPWP(ep, ero, ip_pcc, signalingType, name, exclude, id);
    }

    private void deleteCandidatePath(String substring) {
        Inet4Address ip_pcc = null;
        StringTokenizer st = new StringTokenizer(substring, " ");
        String pcc = st.nextToken();
        this.log.info("PCC: " + pcc);
        try {
            ip_pcc = (Inet4Address)Inet4Address.getByName(pcc);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String lspid = st.nextToken();
        int lsp_id = Integer.parseInt(lspid);
        this.log.info("PLSP-ID: " + lsp_id);
        this.domainPCEServer.getIniManager().deleteCandidatePath(ip_pcc, lsp_id);
    }

    private void createCandidatePath(String substring) {
        Inet4Address ip_pcc = null;
        Inet4Address ip_dest = null;
        ExplicitRouteObject ero = null;
        int offset = 0;
        this.log.info("parsing PCC " + substring.substring(offset));
        StringTokenizer st = new StringTokenizer(substring, " ");
        String pcc = st.nextToken();
        offset += pcc.getBytes().length;
        String policyName = null;
        String preference = null;
        String candidatePathName = null;
        try {
            ip_pcc = (Inet4Address)Inet4Address.getByName(pcc);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.log.info("parsing DEST " + substring.substring(offset));
        String dest = st.nextToken();
        this.log.warn("DESTINO: " + dest);
        offset += dest.getBytes().length;
        try {
            ip_dest = (Inet4Address)Inet4Address.getByName(dest);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.log.info("parsing COLOR " + substring.substring(offset));
        String color = st.nextToken();
        this.log.warn("Color: " + color);
        int int_color = Integer.parseInt(color);
        this.log.info("parsing LSPID " + substring.substring(offset += color.getBytes().length));
        String lspid = st.nextToken();
        this.log.warn("LSP ID: " + lspid);
        offset += lspid.getBytes().length;
        int lsp_id = Integer.parseInt(lspid);
        policyName = "PCE-INIPOL-POLICYNAME-IGP" + lsp_id;
        preference = "100";
        this.log.info("parsing ero " + substring.substring(offset += 4));
        ero = StringToPCEP.stringToExplicitRouteObject(substring.substring(offset));
        boolean signalingType = false;
        if (ero.getEROSubobjectList().getFirst() instanceof SREROSubobject) {
            signalingType = true;
        }
        this.domainPCEServer.getIniManager().createCandidatePath(ip_pcc, int_color, ip_dest, lsp_id, policyName, candidatePathName, preference, ero);
    }

    private void terminate(String lsp_number) {
        this.log.info("parsing " + lsp_number);
        StringTokenizer st = new StringTokenizer(lsp_number, " ");
        String pcc = st.nextToken();
        Inet4Address ip_pcc = null;
        try {
            ip_pcc = (Inet4Address)Inet4Address.getByName(pcc);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String number = st.nextToken();
        int int_lsp_number = Integer.parseInt(number);
        this.domainPCEServer.getIniManager().terminateLSP(int_lsp_number, ip_pcc);
    }

    private void initiate(String inir) {
        Inet4Address ipp;
        int offset = 0;
        this.log.info("parsing " + inir);
        StringTokenizer st = new StringTokenizer(inir, " ");
        String name = st.nextToken();
        this.log.info("name " + name);
        this.log.info("offset " + (offset += name.length() + 1));
        this.log.info("st " + st);
        String pcc = st.nextToken();
        this.log.info("pcc " + pcc);
        Inet4Address ip_pcc = null;
        try {
            ip_pcc = (Inet4Address)Inet4Address.getByName(pcc);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        offset += pcc.length();
        EndPointsIPv4 ep = new EndPointsIPv4();
        String src_ip = st.nextToken();
        try {
            ipp = (Inet4Address)Inet4Address.getByName(src_ip);
            ep.setSourceIP(ipp);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String dst_ip = st.nextToken();
        try {
            ipp = (Inet4Address)Inet4Address.getByName(dst_ip);
            ep.setDestIP(ipp);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.log.info("parsing ero " + inir.substring(offset += src_ip.length() + 1 + dst_ip.length() + 1));
        ExplicitRouteObject ero = StringToPCEP.stringToExplicitRouteObject(inir.substring(offset));
        int signalingType = 0;
        if (ero.getEROSubobjectList().getFirst() instanceof SREROSubobject) {
            signalingType = 1;
        }
        this.domainPCEServer.getIniManager().initiateLSP(ep, ero, ip_pcc, signalingType, name);
    }

    private void easySendUpdate(LSPTEInfo val, DomainPCESession dm) throws UnknownHostException {
        PCEPUpdate update = new PCEPUpdate();
        for (int i = 0; i < val.pcepReport.getStateReportList().size(); ++i) {
            StateReport report = val.pcepReport.getStateReportList().get(i);
            update.getUpdateRequestList().add(new UpdateRequest());
            update.getUpdateRequestList().get(i).setLsp(report.getLsp());
            update.getUpdateRequestList().get(i).setSrp(report.getSrp());
            update.getUpdateRequestList().get(i).setPath(report.getPath());
        }
        dm.sendPCEPMessage(update);
        this.out.println("Update message sent!");
    }

    private void sendUpdate(LSPTEInfo val) throws UnknownHostException {
        SRP rsp = new SRP();
        rsp.setSRP_ID_number(1L);
        SymbolicPathNameTLV symPathName = new SymbolicPathNameTLV();
        String name = "test";
        symPathName.setSymbolicPathNameID(name.getBytes());
        rsp.setSymPathName(symPathName);
        PCEPUpdate m_update = new PCEPUpdate();
        UpdateRequest state_report = new UpdateRequest();
        LSP lsp = new LSP();
        lsp.setDelegateFlag(true);
        lsp.setSyncFlag(false);
        lsp.setOpFlags(1);
        lsp.setLspId(1);
        IPv4LSPIdentifiersTLV lspIdTLV = new IPv4LSPIdentifiersTLV();
        lspIdTLV.setTunnelID(1234);
        lspIdTLV.setTunnelSenderIPAddress((Inet4Address)Inet4Address.getLocalHost());
        lsp.setLspIdentifiers_tlv(lspIdTLV);
        SymbolicPathNameTLV symbPathName = new SymbolicPathNameTLV();
        symbPathName.setSymbolicPathNameID(ByteBuffer.allocate(8).putLong(lsp.getLspId()).array());
        lsp.setSymbolicPathNameTLV_tlv(symbPathName);
        LSPDatabaseVersionTLV lspdDTLV = new LSPDatabaseVersionTLV();
        lspdDTLV.setLSPStateDBVersion(2L);
        state_report.setLsp(lsp);
        state_report.setSrp(rsp);
        Path path = new Path();
        ExplicitRouteObject auxERO = new ExplicitRouteObject();
        path.setEro(auxERO);
        BandwidthRequested bw = new BandwidthRequested();
        bw.setBw(1.0f);
        path.setBandwidth(bw);
        state_report.setPath(path);
        m_update.addStateReport(state_report);
        this.out.println("Sending First PCEPUpdate message");
    }

    private void update(String update) throws UnknownHostException {
        int offset = 0;
        StringTokenizer st = new StringTokenizer(update, " ");
        String id_lsp_s = st.nextToken();
        offset += id_lsp_s.length() + 1;
        int id_lsp = Integer.parseInt(id_lsp_s);
        DataOutputStream out = null;
        Set<Long> keys = this.domainPCEServer.getPcepSessionsInformation().sessionList.keySet();
        for (Long key : keys) {
            System.out.println("Value of " + key + " is: " + this.domainPCEServer.getPcepSessionsInformation().sessionList.get(key));
            out = this.domainPCEServer.getPcepSessionsInformation().sessionList.get(key).getOut();
        }
        if (st.hasMoreTokens()) {
            ExplicitRouteObject ero = StringToPCEP.stringToExplicitRouteObject(update.substring(offset));
            this.domainPCEServer.getPCCReportDispatcher().getDm().updateDelegatedPath(id_lsp, false, ero, out);
        } else {
            this.domainPCEServer.getPCCReportDispatcher().getDm().updateDelegatedPath(id_lsp, true, null, out);
        }
    }

    public class LSPTEInfo {
        public PCEPReport pcepReport;

        LSPTEInfo(PCEPReport pcepReport) {
            this.pcepReport = pcepReport;
        }
    }
}

