/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server.lspdb;

import com.google.gson.Gson;
import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.server.lspdb.ReportDB_Simple;
import java.util.List;
import redis.clients.jedis.Jedis;

public class ReportDB_Redis
extends ReportDB_Simple {
    public static final String DEF_MODULE = "DEFAULT";
    private Jedis jedis;
    private boolean dbActive = true;

    public ReportDB_Redis() {
        super(DEF_MODULE);
        this.jedis = new Jedis("localhost");
        this.jedis.connect();
        if (this.jedis.isConnected()) {
            this.log.info("redis: connection stablished");
        }
    }

    public ReportDB_Redis(String moduleId) {
        super(moduleId);
        this.jedis = new Jedis("localhost");
        this.jedis.connect();
        if (this.jedis.isConnected()) {
            this.log.info("redis: connection stablished");
        }
    }

    public ReportDB_Redis(String moduleId, String host) {
        super(moduleId);
        this.log.info("redis: connecting to database..");
        this.jedis = new Jedis(host, 6379);
        this.jedis.connect();
        if (this.jedis.isConnected()) {
            this.log.info("redis: connection stablished");
        }
    }

    public void fillFromDB() {
        if (!this.jedis.isConnected()) {
            this.log.info("redis: couldn't establish connection...");
            return;
        }
        this.log.info("redis: filling from db");
        List<String> StateReports = this.jedis.hvals(this.getStateReportListKey());
        for (String StateReportString : StateReports) {
            this.log.info("redis: found StateReport: " + StateReportString);
            Gson gson = new Gson();
            byte[] rptBytes = gson.fromJson(StateReportString, byte[].class);
            try {
                StateReport rpt = new StateReport(rptBytes, 0);
                this.log.info("redis: StateReport:::with Id" + this.getKey(rpt));
                this.StateReportList.put(this.getKey(rpt), rpt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void fillFromXML(String path) {
    }

    @Override
    public void add(StateReport rpt) {
        super.add(rpt);
        if (this.dbActive && this.jedis.isConnected()) {
            int key = this.getKey(rpt);
            this.log.info("redis: key: " + this.getKey(rpt));
            try {
                rpt.encode();
                Gson gson = new Gson();
                byte[] rptBytes = rpt.getBytes();
                this.log.info("redis: bytes: " + gson.toJson(rptBytes));
                String rptInfoString = gson.toJson(rptBytes);
                this.jedis.hset(this.getStateReportListKey(), Integer.toString(key), rptInfoString);
                this.log.info("redis: added StateReport");
            }
            catch (PCEPProtocolViolationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public StateReport remove(int rptId) throws NullPointerException {
        if (this.dbActive) {
            this.jedis.hdel(this.getStateReportListKey(), Integer.toString(rptId));
            this.log.info("redis: removed StateReport with id: " + rptId);
        }
        return super.remove(rptId);
    }

    @Override
    public StateReport remove(StateReport rpt) throws NullPointerException {
        return this.remove(this.getKey(rpt));
    }

    public void clearStateReports() {
        super.clearReports();
        if (this.dbActive) {
            this.log.info("redis: clearing db " + this.getStateReportListKey());
            this.jedis.del(this.getStateReportListKey());
        }
    }

    @Override
    public void update(StateReport rpt) {
        this.add(rpt);
    }

    @Override
    public StateReport get(int rptId) {
        return (StateReport)this.StateReportList.get(rptId);
    }

    public String getStateReportListKey() {
        return this.moduleId + "_StateReport";
    }

    public boolean isDbActive() {
        return this.dbActive;
    }

    public void setDbActive(boolean dbActive) {
        this.dbActive = dbActive;
    }
}

