/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server.lspdb;

import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.messages.PCEPReport;
import es.tid.pce.pcep.objects.LSP;
import es.tid.pce.pcep.objects.OPEN;
import es.tid.pce.server.lspdb.ReportDB;
import es.tid.pce.server.lspdb.ReportDB_Redis;
import es.tid.pce.server.lspdb.ReportDB_Simple;
import java.net.Inet4Address;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class ReportDB_Handler {
    protected Hashtable<String, ReportDB> moduleList;
    private Logger log = LoggerFactory.getLogger("PCEPParser");
    private Jedis jedis;
    private String dbHost = "";
    private boolean dbActive = false;
    protected String handlerId = "";

    public ReportDB_Handler() {
        this.moduleList = new Hashtable();
    }

    public ReportDB_Handler(String handlerId, String dbHost) {
        this();
        this.dbHost = dbHost;
        this.handlerId = handlerId;
        this.jedis = new Jedis(dbHost, 6379);
        this.jedis.connect();
        if (this.jedis.isConnected()) {
            this.setDbActive(true);
            this.log.info("redis: connection stablished");
        }
    }

    public void fillFromDB(String handlerId, String dbHost) {
        Jedis j = new Jedis(dbHost);
        this.log.info("redis: filling from db host=" + dbHost + " id=" + handlerId);
        if (j.isConnected()) {
            Set<String> modules = j.keys(this.getModuleList(handlerId));
            this.log.info("modules: " + modules.toString());
            for (String modId : modules) {
                this.log.info("redis: module found: " + modId);
                ReportDB_Redis rptdb = new ReportDB_Redis(modId, dbHost);
                rptdb.fillFromDB();
                this.moduleList.put(modId, rptdb);
            }
        } else {
            this.log.info("redis: couldn't establish connection to fill from db");
        }
    }

    public void fillFromDB() {
        if (this.handlerId.length() == 0 || this.dbHost.length() == 0 || !this.dbActive || !this.jedis.isConnected()) {
            this.log.info("redis: couldn't fill from db, check your configuration");
            return;
        }
        Set<String> modules = this.jedis.keys(this.getModuleList(this.handlerId));
        this.log.info("redis: modules: " + modules.toString());
        Iterator<String> iterator = modules.iterator();
        while (iterator.hasNext()) {
            String modId = iterator.next().replace("_StateReport", "");
            this.log.info("redis: module found: " + modId);
            ReportDB_Redis rptdb = new ReportDB_Redis(modId, this.dbHost);
            rptdb.fillFromDB();
            this.moduleList.put(modId, rptdb);
        }
    }

    public void fillFromXML() {
    }

    public String getModuleList(String handlerId) {
        return handlerId + "_*_StateReport";
    }

    public String getStateReportDBList(Inet4Address ad) {
        return this.handlerId + "_" + ad.toString();
    }

    public String getModuleList() {
        return this.handlerId + "_MODULES";
    }

    public ReportDB getStateReportDB(String key) {
        return this.moduleList.get(key);
    }

    public void setStateReportDB(String key, ReportDB rptdb) {
        this.moduleList.put(key, rptdb);
    }

    public synchronized void processReport(PCEPReport pcepReport) {
        this.log.info("Adding PCEPReport to database,rpts:" + pcepReport.getStateReportList().size());
        for (int i = 0; i < pcepReport.getStateReportList().size(); ++i) {
            StateReport stateReport = pcepReport.getStateReportList().get(i);
            LSP lsp = stateReport.getLsp();
            if (lsp.getLspId() == 0) {
                this.log.info("sync lsp received, ignoring..");
                return;
            }
            Inet4Address adress = lsp.getLspIdentifiers_tlv().getTunnelSenderIPAddress();
            String dbId = this.getStateReportDBList(adress);
            ReportDB rptdb = this.moduleList.get(dbId);
            if (rptdb == null) {
                if (this.dbActive) {
                    this.log.info("redis: created new redis rptdb: " + dbId);
                    rptdb = new ReportDB_Redis(dbId, this.dbHost);
                } else {
                    this.log.info("created new simple rptdb: " + dbId);
                    rptdb = new ReportDB_Simple(dbId);
                }
                this.moduleList.put(adress.toString(), rptdb);
            }
            if (lsp.isRemoveFlag()) {
                rptdb.remove(stateReport);
                continue;
            }
            rptdb.add(stateReport);
        }
    }

    public synchronized void proccessOpen(OPEN open, Inet4Address address) {
        this.log.info("PCC database sync");
        ReportDB_Simple rptdb = new ReportDB_Simple(address.toString());
    }

    public boolean isDbActive() {
        return this.dbActive;
    }

    public void setDbActive(boolean dbActive) {
        if (dbActive && (this.handlerId.length() == 0 || this.dbHost.length() == 0)) {
            this.log.info("redis: can't set the db to active, there's no dbhost or/and handlerId");
            return;
        }
        this.dbActive = dbActive;
    }

    public int getPCCDatabaseVersion(Inet4Address address) {
        ReportDB rptdb = this.moduleList.get(this.getStateReportDBList(address));
        if (rptdb != null) {
            return rptdb.getVersion();
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.moduleList.size() * 100);
        sb.append("Report DB: ");
        Enumeration<ReportDB> db = this.moduleList.elements();
        while (db.hasMoreElements()) {
            sb.append(db.nextElement().toString());
        }
        return sb.toString();
    }
}

