/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server.delegation;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.constructs.UpdateRequest;
import es.tid.pce.pcep.messages.PCEPUpdate;
import es.tid.pce.pcep.objects.BandwidthExistingLSP;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.LSP;
import es.tid.pce.pcep.objects.SRP;
import es.tid.pce.pcep.objects.tlvs.PathSetupTLV;
import es.tid.pce.server.SD_LSP;
import es.tid.pce.server.lspdb.SingleDomainLSPDB;
import es.tid.pce.utils.StringToPCEP;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegationManager {
    private static int next_srp_id = 0;
    private SingleDomainLSPDB lsp_database;
    private boolean compute_path = false;
    private boolean getPathFromFile = true;
    private String file = "C:\\Users\\b.lcm\\eclipse-workspace\\FORK\\netphony-network-protocols\\update_path.txt";
    private Logger log;

    public DelegationManager(SingleDomainLSPDB lsp_database) {
        this.lsp_database = lsp_database;
        this.log = LoggerFactory.getLogger("PCEServer");
    }

    public void processReport(StateReport sr, DataOutputStream out) {
        int lsp_id = sr.getLsp().getLspId();
        boolean accept__delegations = true;
        this.log.debug("Processing report of LSP ID " + lsp_id);
        if (lsp_id == 0) {
            this.log.debug("LSP ID 0, no need to process");
            return;
        }
        if (accept__delegations) {
            if (sr.getLsp().isDelegateFlag()) {
                this.log.debug("The report has delegation flag true, checking if we need to delegate");
                SD_LSP lsp = this.lsp_database.getSingleDomain_LSP_list().get(lsp_id);
                boolean answer_delegation = false;
                if (lsp != null) {
                    this.log.debug("LSP in database");
                    if (!lsp.isDelegated()) {
                        this.log.debug("LSP not yet delegated. Proceed to accept delegation");
                        answer_delegation = true;
                        lsp.setDelegated(true);
                    }
                } else if (sr.getLsp().isCreateFlag()) {
                    this.log.debug("LSP not yet in database, but created by the PCE... add to db and do nothing");
                    answer_delegation = false;
                    lsp = new SD_LSP();
                    lsp.setStateRport(sr);
                    lsp.setCreated(true);
                    lsp.setDelegated(true);
                    this.lsp_database.getSingleDomain_LSP_list().put(lsp_id, lsp);
                } else {
                    this.log.debug("LSP not yet in database and it is not created by the PCE. Proceed to accept delegation and add to database");
                    lsp = new SD_LSP();
                    lsp.setStateRport(sr);
                    lsp.setDelegated(true);
                    this.lsp_database.getSingleDomain_LSP_list().put(lsp_id, lsp);
                    answer_delegation = true;
                }
                if (answer_delegation) {
                    PCEPUpdate pup = new PCEPUpdate();
                    UpdateRequest ur = new UpdateRequest();
                    SRP srp = new SRP();
                    srp.setSRP_ID_number(DelegationManager.getNextSRPID());
                    this.log.info("Checking LSP signalling type");
                    if (lsp.getStateRport().getSrp() != null && lsp.getStateRport().getSrp().getPathSetupTLV() != null) {
                        PathSetupTLV pst = new PathSetupTLV();
                        if (lsp.getStateRport().getSrp().getPathSetupTLV().isSR()) {
                            lsp.setSegmentRouting(true);
                            this.log.info("The LSP is Segment Routing signalled");
                            pst.setPST(1);
                        } else {
                            lsp.setSegmentRouting(false);
                            this.log.info("The LSP is RSVP-TE signalled");
                            pst.setPST(0);
                        }
                    }
                    ur.setSrp(srp);
                    PathSetupTLV sym = new PathSetupTLV();
                    sym.setPST(0);
                    sym.setTLVType(28);
                    srp.setPathSetupTLV(sym);
                    LSP ls = new LSP();
                    ls.setLspId(sr.getLsp().getLspId());
                    ls.setDelegateFlag(true);
                    ls.setAdministrativeFlag(true);
                    ls.setOpFlags(1);
                    String name = null;
                    if (sr.getLsp().getLspIdentifiers_tlv() != null) {
                        ls.setLspIdentifiers_tlv(sr.getLsp().getLspIdentifiers_tlv());
                    }
                    if (sr.getLsp().getSymbolicPathNameTLV_tlv() != null) {
                        name = new String(sr.getLsp().getSymbolicPathNameTLV_tlv().getSymbolicPathNameID());
                        this.log.info("LSP Name " + name);
                        ls.setSymbolicPathNameTLV_tlv(sr.getLsp().getSymbolicPathNameTLV_tlv());
                    }
                    ur.setLsp(ls);
                    this.log.debug("Prepare answer with the Path");
                    Path path = null;
                    if (this.getPathFromFile) {
                        this.log.debug("Getting path from a file");
                        path = this.getEroFromFile();
                    } else if (this.compute_path) {
                        path = this.computePath();
                    }
                    BandwidthExistingLSP bw = new BandwidthExistingLSP();
                    bw.setOT(1);
                    bw.setBw(100.0f);
                    path.setBandwidth(bw);
                    ur.setPath(path);
                    ur.setPath(path);
                    for (int i = 0; i < lsp.getStateRport().getAssociationList().size(); ++i) {
                        this.log.info("adding association");
                        ur.getAssociationList().add(lsp.getStateRport().getAssociationList().get(i));
                    }
                    this.log.info(sr.toString());
                    pup.getUpdateRequestList().add(ur);
                    try {
                        this.log.info(pup.toString());
                        pup.encode();
                    }
                    catch (PCEPProtocolViolationException e) {
                        this.log.error("PROBLEM ENCONDING UPDATE, CHECK CODE!!" + e.getMessage());
                    }
                    try {
                        this.log.info("DELEGATION processeed, about to send update with empty ero");
                        out.write(pup.getBytes());
                        out.flush();
                    }
                    catch (IOException e) {
                        this.log.warn("Could not send the UPDATE " + e.getMessage());
                    }
                }
            }
        } else {
            UpdateRequest ur = new UpdateRequest();
            PCEPUpdate pup = new PCEPUpdate();
            LSP ls = new LSP();
            ls.setDelegateFlag(false);
            ur.setLsp(ls);
        }
    }

    public static synchronized int getNextSRPID() {
        return ++next_srp_id;
    }

    public void updateDelegatedPath(int lsp_id, boolean compute, ExplicitRouteObject ero, DataOutputStream out) {
        SD_LSP lsp = this.lsp_database.getSingleDomain_LSP_list().get(lsp_id);
        StateReport sr = null;
        if (lsp != null) {
            sr = lsp.getStateRport();
        }
        PCEPUpdate pup = new PCEPUpdate();
        UpdateRequest ur = new UpdateRequest();
        SRP srp = new SRP();
        LSP ls = new LSP();
        ls.setAdministrativeFlag(true);
        ls.setOpFlags(1);
        this.log.debug("Prepare answer with intended path in the ERO");
        srp.setSRP_ID_number(this.getNextSRPID());
        if (sr != null) {
            ls.setLspId(sr.getLsp().getLspId());
        } else {
            ls.setLspId(lsp_id);
        }
        ls.setDelegateFlag(true);
        ur.setSrp(srp);
        if (sr != null) {
            this.log.info(sr.toString());
            if (sr.getLsp().getLspIdentifiers_tlv() != null) {
                ls.setLspIdentifiers_tlv(sr.getLsp().getLspIdentifiers_tlv());
            }
            if (sr.getLsp().getSymbolicPathNameTLV_tlv() != null) {
                ls.setSymbolicPathNameTLV_tlv(sr.getLsp().getSymbolicPathNameTLV_tlv());
            }
        }
        ur.setLsp(ls);
        Path path = new Path();
        if (!compute) {
            path.setEro(ero);
        }
        ur.setPath(path);
        pup.getUpdateRequestList().add(ur);
        try {
            this.log.info(pup.toString());
            pup.encode();
        }
        catch (PCEPProtocolViolationException e) {
            this.log.error("PROBLEM ENCONDING UPDATE, CHECK CODE!!" + e.getMessage());
        }
        try {
            this.log.info("DELEGATION processeed, about to send update with empty ero");
            out.write(pup.getBytes());
            out.flush();
        }
        catch (IOException e) {
            this.log.warn("Could not send the UPDATE " + e.getMessage());
        }
    }

    public SingleDomainLSPDB getLsp_database() {
        return this.lsp_database;
    }

    public void setLsp_database(SingleDomainLSPDB lsp_database) {
        this.lsp_database = lsp_database;
    }

    public Path getEroFromFile() {
        Path path = new Path();
        try {
            FileReader fr = new FileReader(this.file);
            BufferedReader reader = new BufferedReader(fr);
            String line = reader.readLine();
            this.log.info("Creating ERO " + line);
            ExplicitRouteObject ero = StringToPCEP.stringToExplicitRouteObject(line);
            path.setEro(ero);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }

    public Path computePath() {
        Path path = new Path();
        ExplicitRouteObject ero = new ExplicitRouteObject();
        path.setEro(ero);
        return path;
    }
}

