/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.computingEngine.InitiationRequest;
import es.tid.pce.computingEngine.SingleDomainIniProcessorThread;
import es.tid.pce.pcep.constructs.PCEPIntiatedLSP;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.server.IniPCCManager;
import es.tid.pce.server.lspdb.SingleDomainLSPDB;
import java.io.DataOutputStream;
import java.net.Inet4Address;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleDomainInitiateDispatcher {
    private LinkedBlockingQueue<InitiationRequest> lspIniRequestQueue;
    private Thread singleDomainIniProcessorThread;
    private IniPCCManager iniManager;
    private Logger log = LoggerFactory.getLogger("PCEServer");

    public SingleDomainInitiateDispatcher(SingleDomainLSPDB singleDomainLSPDB, IniPCCManager iniManager) {
        this.lspIniRequestQueue = new LinkedBlockingQueue();
        this.singleDomainIniProcessorThread = new SingleDomainIniProcessorThread(this.lspIniRequestQueue, singleDomainLSPDB, iniManager);
        this.singleDomainIniProcessorThread.start();
        this.iniManager = iniManager;
    }

    public void dispathInitiate(PCEPInitiate iniMessage, DataOutputStream out, Inet4Address remotePeerIP) {
        this.log.info("Dispatching Initiate message from " + remotePeerIP);
        this.log.info("XXX iniMessage: " + iniMessage);
        Iterator it = iniMessage.getPcepIntiatedLSPList().iterator();
        while (it.hasNext()) {
            this.log.info("Dispaaaatch");
            InitiationRequest ir = new InitiationRequest();
            ir.setOut(out);
            ir.setRemotePeerIP(remotePeerIP);
            ir.setLspIniRequest((PCEPIntiatedLSP)it.next());
            this.lspIniRequestQueue.add(ir);
        }
    }

    public IniPCCManager getIniManager() {
        return this.iniManager;
    }

    public void setIniManager(IniPCCManager iniManager) {
        this.iniManager = iniManager;
    }
}

