/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import com.google.gson.Gson;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.server.SD_LSP;
import es.tid.pce.server.SimpleLSP;
import es.tid.pce.server.SimpleLSPhop;
import es.tid.pce.server.lspdb.SingleDomainLSPDB;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.ETCEROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class SaveLSPinRedisSingleDom
implements Runnable {
    private Hashtable<Integer, SD_LSP> LSP_list;
    private Hashtable<Integer, SD_LSP> LSP_list_old;
    private Hashtable<Integer, SD_LSP> LSP_list_to_add;
    private Hashtable<Integer, SD_LSP> LSP_list_to_del;
    private Logger log = LoggerFactory.getLogger("BGP4Parser");
    Jedis jedis;

    public void configure(SingleDomainLSPDB singleDomainLSPDB, String host, int port) {
        this.jedis = new Jedis(host, port);
        this.jedis.connect();
        this.LSP_list = singleDomainLSPDB.getSingleDomain_LSP_list();
    }

    @Override
    public void run() {
        this.log.info("Going to save LSP in DB");
        this.LSP_list_to_add = new Hashtable();
        this.LSP_list_to_del = new Hashtable();
        if (this.LSP_list != null) {
            String key;
            Integer id;
            Enumeration<Integer> ids;
            if (this.LSP_list_old == null) {
                this.LSP_list_old = new Hashtable();
                ids = this.LSP_list.keys();
                while (ids.hasMoreElements()) {
                    id = ids.nextElement();
                    this.LSP_list_old.put(id, this.LSP_list.get(id));
                    this.LSP_list_to_add.put(id, this.LSP_list.get(id));
                }
            } else {
                ids = this.LSP_list.keys();
                while (ids.hasMoreElements()) {
                    id = ids.nextElement();
                    if (this.LSP_list_old.containsKey(id)) continue;
                    this.LSP_list_to_add.put(id, this.LSP_list.get(id));
                    this.LSP_list_old.put(id, this.LSP_list.get(id));
                }
                ids = this.LSP_list_old.keys();
                while (ids.hasMoreElements()) {
                    id = ids.nextElement();
                    if (this.LSP_list.containsKey(id)) continue;
                    this.LSP_list_to_del.put(id, this.LSP_list.get(id));
                }
                ids = this.LSP_list_to_del.keys();
                while (ids.hasMoreElements()) {
                    id = ids.nextElement();
                    this.LSP_list_old.remove(id);
                }
            }
            ids = this.LSP_list_to_add.keys();
            while (ids.hasMoreElements()) {
                id = ids.nextElement();
                key = "LSP:" + id;
                String value = this.lspToJSON(this.LSP_list_to_add.get(id));
                this.jedis.set(key, value);
                this.jedis.sadd("lsps", key);
            }
            ids = this.LSP_list_to_del.keys();
            while (ids.hasMoreElements()) {
                id = ids.nextElement();
                key = "LSP:" + id;
                this.jedis.del(key);
                this.jedis.srem("lsps", key);
            }
        }
    }

    public String lspToJSON(SD_LSP lsp) {
        Gson gson = new Gson();
        SimpleLSP slsp = new SimpleLSP();
        slsp.setLSP_Id(lsp.getpLSPID());
        ExplicitRouteObject ero = lsp.getFullERO();
        this.log.info("lsp.getFullERO(): " + ero.toString());
        Iterator erosolist = ero.getEROSubobjectList().iterator();
        int num = 0;
        while (erosolist.hasNext()) {
            EROSubobject eroso = (EROSubobject)erosolist.next();
            if (eroso instanceof UnnumberIfIDEROSubobject) {
                ++num;
                continue;
            }
            if (!(eroso instanceof IPv4prefixEROSubobject)) continue;
            ++num;
        }
        slsp.data = new SimpleLSPhop[num];
        erosolist = ero.getEROSubobjectList().iterator();
        int i = -1;
        while (erosolist.hasNext()) {
            EROSubobject eroso = (EROSubobject)erosolist.next();
            this.log.info("eroso: " + eroso.toString());
            this.log.info("ero num: eroso.getType(): " + eroso.getType());
            this.log.info("ero class " + eroso.getClass().getCanonicalName());
            if (eroso instanceof UnnumberIfIDEROSubobject) {
                this.log.info("EROSubObject: UnnumberIfIDEROSubobject");
                this.log.info("UnnumberIfIDEROSubobject i:" + ++i);
                slsp.data[i] = new SimpleLSPhop();
                slsp.data[i].routerID = ((UnnumberIfIDEROSubobject)eroso).routerID.getHostAddress();
                slsp.data[i].ifID = "" + ((UnnumberIfIDEROSubobject)eroso).interfaceID;
                this.log.info("UnnumberIfIDEROSubobject slsp.data[i].routerID is: " + slsp.data[i].routerID);
                this.log.info("UnnumberIfIDEROSubobject slsp.data[i].ifID is: " + slsp.data[i].ifID);
                continue;
            }
            if (eroso instanceof GeneralizedLabelEROSubobject) {
                this.log.info("EROSubObject: GeneralizedLabelEROSubobject");
                this.log.info("GeneralizedLabelEROSubobject i:" + i);
                if (slsp.data[i] == null) continue;
                slsp.data[i].n = "" + ((GeneralizedLabelEROSubobject)eroso).getDwdmWavelengthLabel().getN();
                slsp.data[i].m = "" + ((GeneralizedLabelEROSubobject)eroso).getDwdmWavelengthLabel().getM();
                this.log.info("GeneralizedLabelEROSubobject slsp.data[i].n is: " + slsp.data[i].n);
                this.log.info("GeneralizedLabelEROSubobject slsp.data[i].m is: " + slsp.data[i].m);
                continue;
            }
            if (eroso instanceof ETCEROSubobject) {
                this.log.info("EROSubObject: ETCEROSubobject");
                this.log.info("ETCEROSubobject i:" + i);
                if (slsp.data[i] == null) continue;
                slsp.data[i].transponder = "TX " + ((ETCEROSubobject)eroso).getSubTransponderList().get(0).getST_TLV_ModFormat().toString();
                continue;
            }
            if (!(eroso instanceof IPv4prefixEROSubobject)) continue;
            this.log.info("EROSubObject: IPv4prefixEROSubobject");
            this.log.info("IPv4prefixEROSubobject i:" + ++i);
            slsp.data[i] = new SimpleLSPhop();
            if (slsp.data[i] != null) {
                this.log.info("slsp.data[i] is: " + slsp.data[i]);
                slsp.data[i].routerID = ((IPv4prefixEROSubobject)eroso).getIpv4address().getHostAddress();
                this.log.info("slsp.data[i].routerID is: " + slsp.data[i].routerID);
                continue;
            }
            this.log.info("slsp.data[i] is: " + slsp.data[i]);
        }
        String json = gson.toJson(slsp);
        this.log.info("json:" + json.toString());
        return json;
    }

    public Hashtable<Integer, SD_LSP> getMultiDomain_LSP_list() {
        return this.LSP_list;
    }

    public void setMultiDomain_LSP_list(Hashtable<Integer, SD_LSP> LSP_list) {
        this.LSP_list = LSP_list;
    }
}

