/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.messages.PCEPRequest;
import es.tid.pce.pcep.messages.PCEPResponse;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.ParentPCERequestManager;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProcessor
implements Runnable {
    private PCEPRequest req;
    private DataOutputStream out;
    private Logger log = LoggerFactory.getLogger("PCEServer");
    private ParentPCERequestManager childPCERequestManager;

    public RequestProcessor(PCEPRequest req, DataOutputStream out, ParentPCERequestManager childPCERequestManager) {
        this.req = req;
        this.out = out;
        this.childPCERequestManager = childPCERequestManager;
    }

    @Override
    public void run() {
        this.log.info("Processing request");
        this.log.info("Choosing default algorithm");
        this.log.info("Obtaining Network Graph copy");
        EndPoints EP = null;
        Inet4Address source_router_id_addr = null;
        Inet4Address dest_router_id_addr = null;
        EP = this.req.getRequest(0).getEndPoints();
        source_router_id_addr = ((EndPointsIPv4)EP).getSourceIP();
        dest_router_id_addr = ((EndPointsIPv4)EP).getDestIP();
        this.log.info("Source: " + source_router_id_addr);
        this.log.info("Destination: " + dest_router_id_addr);
        this.log.info("Check if we have source and destination in our TED");
        if (this.childPCERequestManager != null) {
            this.log.info("Source or destination are NOT in the TED, asking the parent PCE");
            PCEPResponse resp = this.childPCERequestManager.newRequest(this.req);
            try {
                resp.encode();
                this.log.info("Request from Parent PCE processeed, about to send response");
                this.out.write(resp.getBytes());
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (PCEPProtocolViolationException e1) {
                this.log.error("Response from Parent PCE not valid!!!!!");
                return;
            }
            return;
        }
        this.log.warn("Source or destination are NOT in the TED");
        ComputingResponse m_resp = new ComputingResponse();
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setRequestID(this.req.getRequest(0).getRequestParameters().getRequestID());
        response.setRequestParameters(rp);
        NoPath noPath = new NoPath();
        noPath.setNatureOfIssue(0);
        NoPathTLV noPathTLV = new NoPathTLV();
        noPath.setNoPathTLV(noPathTLV);
        response.setNoPath(noPath);
        m_resp.addResponse(response);
        try {
            m_resp.encode();
        }
        catch (PCEPProtocolViolationException e1) {
            this.log.error("Response not valid!!!!!");
            return;
        }
        this.log.info("RequestProcessor: request processed");
        try {
            this.log.info("Request processeed, about to send response");
            this.out.write(m_resp.getBytes());
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.log.info("Response sent!!");
        long tiempoini = System.currentTimeMillis();
        ComputingResponse m_resp2 = new ComputingResponse();
        Response response2 = new Response();
        if (source_router_id_addr.equals(dest_router_id_addr)) {
            this.log.info("Source and destination are the same!");
            Path path = new Path();
            RequestParameters rp2 = new RequestParameters();
            rp2.setRequestID(this.req.getRequest(0).getRequestParameters().getRequestID());
            response2.setRequestParameters(rp2);
            ExplicitRouteObject ero = new ExplicitRouteObject();
            IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
            eroso.setIpv4address(source_router_id_addr);
            eroso.setPrefix(32);
            ero.addEROSubobject(eroso);
            path.setEro(ero);
            response2.addPath(path);
            long tiempofin = System.nanoTime();
            long tiempotot = tiempofin - tiempoini;
            m_resp2.addResponse(response2);
        } else {
            this.log.info("Computing path");
            long tiempofin = System.currentTimeMillis();
            long tiempotot = tiempofin - tiempoini;
            this.log.info("Ha tardado " + tiempotot + " milisegundos");
            this.log.info("Creating response");
            RequestParameters rp3 = new RequestParameters();
            rp3.setRequestID(this.req.getRequest(0).getRequestParameters().getRequestID());
            response2.setRequestParameters(rp3);
            m_resp2.addResponse(response2);
            Path path = new Path();
            ExplicitRouteObject ero = new ExplicitRouteObject();
            IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
            eroso.setPrefix(32);
            ero.addEROSubobject(eroso);
            path.setEro(ero);
            response2.addPath(path);
        }
        try {
            m_resp2.encode();
        }
        catch (PCEPProtocolViolationException e1) {
            this.log.error("Response not valid!!!!!");
            return;
        }
        this.log.info("RequestProcessor: request processed");
        try {
            this.log.info("Request processeed, about to send response");
            this.out.write(m_resp2.getBytes());
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.log.info("Response sent!!");
    }
}

