/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.computingEngine.AlgorithmRule;
import es.tid.pce.computingEngine.MapAlgoRule;
import es.tid.pce.server.Layer;
import es.tid.pce.server.lspdb.ReportDB_Handler;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.LinkedList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PCEServerParameters {
    private int PCEServerPort = 4189;
    private int PCEManagementPort = 6666;
    private long timerOSPFupdatesToParentPCE = 10000L;
    private boolean isCompletedAuxGraph = false;
    private boolean isSSOn = false;
    private boolean isWLAN = false;
    private long timeSendReachabilityTime = 100000L;
    private int OFCodeParentPCE = 0;
    private String parentPCEAddress = null;
    private int parentPCEPort = 4189;
    private int OSPFTCPPort = 7779;
    private int PCCRequestsProcessors = 1;
    private int ParentPCERequestProcessors = 1;
    private String PCEServerLogFile = "PCEServer.log";
    private String PCEPParserLogFile = "PCEPParser.log";
    private String TEDBParserLogFile = "TEDBParser.log";
    private String OSPFParserLogFile = "OSPFParser.log";
    private String networkDescriptionFile = "network_101.xml";
    private String ITnetworkDescriptionFile = "network_IT_101.xml";
    private int KeepAliveTimer = 30;
    private int minKeepAliveTimerPCCAccepted = 2;
    private int maxDeadTimerPCCAccepted = 30000;
    private boolean zeroDeadTimerPCCAccepted = false;
    private int DeadTimer = 120;
    private Layer defaultPCELayer;
    public boolean ITcapable = false;
    public LinkedList<Layer> PCElayers;
    public LinkedList<MapAlgoRule> algorithmRuleList;
    private String confFile;
    private boolean nodelay = false;
    private boolean optimizedRead = false;
    private boolean OSPFSession = false;
    private boolean OSPFTCPSession = false;
    private String OSPFListenerIP = "localhost";
    private boolean OSPFMulticast = false;
    private boolean OSPFUnicast = false;
    private boolean analyzeRequestTime = false;
    private boolean setTraces = true;
    private boolean reservation = false;
    private boolean useMaxQueingTime = false;
    private boolean multilayer = false;
    private boolean multidomain = false;
    private boolean isStateful = false;
    private boolean statefulDFlag = false;
    private boolean statefulTFlag = false;
    private boolean statefulSFlag = false;
    private boolean isSRCapable = false;
    private int MSD = 0;
    private ReportDB_Handler lspDB;
    private String controllerIP;
    private String controllerPORT;
    private String topologyPath;
    private String interDomainFile;
    private String controllerListFile;
    private String layer = null;
    private int lambdaIni = 0;
    private int lambdaEnd = Integer.MAX_VALUE;
    private boolean collaborativePCEs = false;
    private boolean primary = false;
    private String ipPrimaryPCE;
    private int portPrimaryPCE = 4191;
    private Inet4Address IPBackupPCE;
    private int idAlgo;
    private boolean topologyModuleOption;
    private boolean actingAsBGP4Peer;
    private String BGP4File = "BGP4Parameters.xml";
    private String localPceAddress = "127.0.0.1";
    public boolean initFromFile = true;
    protected boolean isActive = false;
    private String dbType = "_";
    private String dbName = "_";

    public boolean isSSOn() {
        return this.isSSOn;
    }

    public void setSSOn(boolean isSSOn) {
        this.isSSOn = isSSOn;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public PCEServerParameters() {
        this.confFile = "PCEServerConfiguration.xml";
    }

    public PCEServerParameters(String confFile) {
        if (confFile != null) {
            this.confFile = confFile;
        } else {
            confFile = "PCEServerConfiguration.xml";
        }
    }

    public void initialize() {
        this.algorithmRuleList = new LinkedList();
        this.PCElayers = new LinkedList();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){
                String tempVal;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equalsIgnoreCase("layer")) {
                        boolean defaultL;
                        Layer lay = new Layer();
                        String layer2 = attributes.getValue("type");
                        if (layer2.equals("gmpls")) {
                            lay.gmpls = true;
                            lay.encodingType = Integer.parseInt(attributes.getValue("encodingType"));
                            lay.switchingType = Integer.parseInt(attributes.getValue("switchingType"));
                        }
                        if (defaultL = Boolean.parseBoolean(attributes.getValue("default"))) {
                            PCEServerParameters.this.defaultPCELayer = lay;
                            PCEServerParameters.this.layer = layer2;
                        }
                        PCEServerParameters.this.PCElayers.add(lay);
                    } else if (qName.equalsIgnoreCase("algorithmRule")) {
                        MapAlgoRule mar = new MapAlgoRule();
                        AlgorithmRule ar = new AlgorithmRule();
                        String aname = attributes.getValue("name");
                        ar.of = Integer.parseInt(attributes.getValue("of"));
                        ar.svec = Boolean.parseBoolean(attributes.getValue("svec"));
                        mar.ar = ar;
                        mar.algoName = aname;
                        mar.isParentPCEAlgorithm = Boolean.parseBoolean(attributes.getValue("isParentPCEAlgorithm"));
                        mar.isWSONAlgorithm = Boolean.parseBoolean(attributes.getValue("isWSONAlgorithm"));
                        mar.isSSSONAlgorithm = Boolean.parseBoolean(attributes.getValue("isSSONAlgorithm"));
                        mar.isWLANAlgorithm = Boolean.parseBoolean(attributes.getValue("isWLANAlgorithm"));
                        PCEServerParameters.this.isSSOn = mar.isSSSONAlgorithm;
                        PCEServerParameters.this.isWLAN = mar.isWLANAlgorithm;
                        PCEServerParameters.this.algorithmRuleList.add(mar);
                    } else if (qName.equalsIgnoreCase("controller")) {
                        PCEServerParameters.this.controllerIP = attributes.getValue("ip");
                        PCEServerParameters.this.controllerPORT = attributes.getValue("port");
                        PCEServerParameters.this.topologyPath = attributes.getValue("topologyPath");
                        PCEServerParameters.this.interDomainFile = attributes.getValue("interDomainFile");
                        PCEServerParameters.this.controllerListFile = attributes.getValue("controllerListFile");
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equalsIgnoreCase("PCEServerPort")) {
                        PCEServerParameters.this.PCEServerPort = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("LocalPCEAddress")) {
                        PCEServerParameters.this.localPceAddress = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("PCEManagementPort")) {
                        PCEServerParameters.this.PCEManagementPort = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("OFCodeParentPCE")) {
                        PCEServerParameters.this.OFCodeParentPCE = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("parentPCEAddress")) {
                        PCEServerParameters.this.parentPCEAddress = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("parentPCEPort")) {
                        PCEServerParameters.this.parentPCEPort = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("PCCRequestsProcessors")) {
                        PCEServerParameters.this.PCCRequestsProcessors = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("KeepAliveTimer")) {
                        PCEServerParameters.this.KeepAliveTimer = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("DeadTimer")) {
                        PCEServerParameters.this.DeadTimer = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("ParentPCERequestProcessors")) {
                        PCEServerParameters.this.ParentPCERequestProcessors = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("PCEServerLogFile")) {
                        PCEServerParameters.this.PCEServerLogFile = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("nodelay")) {
                        PCEServerParameters.this.nodelay = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("multilayer")) {
                        PCEServerParameters.this.multilayer = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("multidomain")) {
                        PCEServerParameters.this.multidomain = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("useMaxReqTime")) {
                        PCEServerParameters.this.useMaxQueingTime = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("reservation")) {
                        PCEServerParameters.this.reservation = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("optimizedRead")) {
                        PCEServerParameters.this.optimizedRead = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("OSPFSession")) {
                        PCEServerParameters.this.OSPFSession = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("OSPFListenerIP")) {
                        PCEServerParameters.this.OSPFListenerIP = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("OSPFMulticast")) {
                        PCEServerParameters.this.OSPFMulticast = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("OSPFUnicast")) {
                        PCEServerParameters.this.OSPFUnicast = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("OSPFTCPSession")) {
                        PCEServerParameters.this.OSPFTCPSession = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("OSPFTCPPort")) {
                        PCEServerParameters.this.OSPFTCPPort = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("analyzeRequestTime")) {
                        PCEServerParameters.this.analyzeRequestTime = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("PCEPParserLogFile")) {
                        PCEServerParameters.this.PCEPParserLogFile = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("TEDBParserLogFile")) {
                        PCEServerParameters.this.PCEPParserLogFile = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("setTraces")) {
                        PCEServerParameters.this.setTraces = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("networkDescriptionFile")) {
                        PCEServerParameters.this.networkDescriptionFile = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("isActive")) {
                        PCEServerParameters.this.isActive = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("isStateful")) {
                        PCEServerParameters.this.isStateful = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("statefulDFlag")) {
                        PCEServerParameters.this.statefulDFlag = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("statefulSFlag")) {
                        PCEServerParameters.this.statefulSFlag = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("statefulTFlag")) {
                        PCEServerParameters.this.statefulTFlag = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("isSRCapable")) {
                        PCEServerParameters.this.isSRCapable = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("MSD")) {
                        PCEServerParameters.this.MSD = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("timeSendTopologyTask")) {
                        PCEServerParameters.this.timerOSPFupdatesToParentPCE = Long.parseLong(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("timeSendReachabilityTask")) {
                        PCEServerParameters.this.timeSendReachabilityTime = Long.parseLong(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("lambdaIni")) {
                        PCEServerParameters.this.lambdaIni = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("lambdaEnd")) {
                        PCEServerParameters.this.lambdaEnd = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("isCompletedAuxGraph")) {
                        PCEServerParameters.this.isCompletedAuxGraph = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("actingAsBGP4Peer")) {
                        PCEServerParameters.this.actingAsBGP4Peer = Boolean.parseBoolean(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("BGP4File")) {
                        PCEServerParameters.this.BGP4File = this.tempVal.trim();
                    } else if (PCEServerParameters.this.isCompletedAuxGraph) {
                        if (qName.equalsIgnoreCase("idAlgo")) {
                            PCEServerParameters.this.idAlgo = Integer.parseInt(this.tempVal.trim());
                        }
                    } else if (qName.equalsIgnoreCase("ipPrimaryPCE")) {
                        PCEServerParameters.this.collaborativePCEs = true;
                        PCEServerParameters.this.ipPrimaryPCE = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("isPrimaryPCE")) {
                        PCEServerParameters.this.primary = Boolean.parseBoolean(this.tempVal.trim());
                        PCEServerParameters.this.collaborativePCEs = true;
                    } else if (qName.equalsIgnoreCase("portPrimaryPCE")) {
                        PCEServerParameters.this.portPrimaryPCE = Integer.parseInt(this.tempVal.trim());
                    } else if (qName.equalsIgnoreCase("IPBackupPCE")) {
                        try {
                            PCEServerParameters.this.IPBackupPCE = (Inet4Address)Inet4Address.getByName(this.tempVal.trim());
                        }
                        catch (UnknownHostException e) {
                            e.printStackTrace();
                        }
                    } else if (qName.equalsIgnoreCase("dbType")) {
                        PCEServerParameters.this.dbType = this.tempVal.trim();
                    } else if (qName.equalsIgnoreCase("dbName")) {
                        PCEServerParameters.this.dbName = this.tempVal.trim();
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    this.tempVal = new String(ch, start, length);
                }
            };
            saxParser.parse(this.confFile, handler);
        }
        catch (Exception e) {
            System.err.println("Problemas al leer la configuracion");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public String getTEDBParserLogFile() {
        return this.TEDBParserLogFile;
    }

    public void setTEDBParserLogFile(String tEDBLogFile) {
        this.TEDBParserLogFile = tEDBLogFile;
    }

    public String getOSPFParserLogFile() {
        return this.OSPFParserLogFile;
    }

    public void setOSPFParserLogFile(String oSPFParserLogFile) {
        this.OSPFParserLogFile = oSPFParserLogFile;
    }

    public boolean isOptimizedRead() {
        return this.optimizedRead;
    }

    public void setOptimizedRead(boolean optimizedRead) {
        this.optimizedRead = optimizedRead;
    }

    public boolean isNodelay() {
        return this.nodelay;
    }

    public void setNodelay(boolean nodelay) {
        this.nodelay = nodelay;
    }

    public int getPCEServerPort() {
        return this.PCEServerPort;
    }

    public void setPCEServerPort(int pCEServerPort) {
        this.PCEServerPort = pCEServerPort;
    }

    public String getParentPCEAddress() {
        return this.parentPCEAddress;
    }

    public void setParentPCEAddress(String parentPCEAddress) {
        this.parentPCEAddress = parentPCEAddress;
    }

    public int getParentPCEPort() {
        return this.parentPCEPort;
    }

    public void setParentPCEPort(int parentPCEPort) {
        this.parentPCEPort = parentPCEPort;
    }

    public int getPCCRequestsProcessors() {
        return this.PCCRequestsProcessors;
    }

    public void setPCCRequestsProcessors(int pCCRequestsProcessors) {
        this.PCCRequestsProcessors = pCCRequestsProcessors;
    }

    public int getParentPCERequestProcessors() {
        return this.ParentPCERequestProcessors;
    }

    public void setParentPCERequestProcessors(int parentPCERequestProcessors) {
        this.ParentPCERequestProcessors = parentPCERequestProcessors;
    }

    public String getPCEServerLogFile() {
        return this.PCEServerLogFile;
    }

    public void setPCEServerLogFile(String pCEServerLogFile) {
        this.PCEServerLogFile = pCEServerLogFile;
    }

    public String getPCEPParserLogFile() {
        return this.PCEPParserLogFile;
    }

    public void setPCEPParserLogFile(String pCEPParserLogFile) {
        this.PCEPParserLogFile = pCEPParserLogFile;
    }

    public String getNetworkDescriptionFile() {
        return this.networkDescriptionFile;
    }

    public void setNetworkDescriptionFile(String networkDescriptionFile) {
        this.networkDescriptionFile = networkDescriptionFile;
    }

    public String getITNetworkDescriptionFile() {
        return this.ITnetworkDescriptionFile;
    }

    public void setITNetworkDescriptionFile(String ITnetworkDescriptionFile) {
        this.ITnetworkDescriptionFile = ITnetworkDescriptionFile;
    }

    public long getTimeSendTopologyTask() {
        return this.timerOSPFupdatesToParentPCE;
    }

    public long getTimeSendReachabilityTime() {
        return this.timeSendReachabilityTime;
    }

    public int getMinKeepAliveTimerPCCAccepted() {
        return this.minKeepAliveTimerPCCAccepted;
    }

    public void setMinKeepAliveTimerPCCAccepted(int minKeepAliveTimerPCCAccepted) {
        this.minKeepAliveTimerPCCAccepted = minKeepAliveTimerPCCAccepted;
    }

    public int getMaxDeadTimerPCCAccepted() {
        return this.maxDeadTimerPCCAccepted;
    }

    public void setMaxDeadTimerPCCAccepted(int maxDeadTimerPCCAccepted) {
        this.maxDeadTimerPCCAccepted = maxDeadTimerPCCAccepted;
    }

    public boolean isZeroDeadTimerPCCAccepted() {
        return this.zeroDeadTimerPCCAccepted;
    }

    public void setZeroDeadTimerPCCAccepted(boolean zeroDeadTimerPCCAccepted) {
        this.zeroDeadTimerPCCAccepted = zeroDeadTimerPCCAccepted;
    }

    public int getKeepAliveTimer() {
        return this.KeepAliveTimer;
    }

    public void setKeepAliveTimer(int keepAliveTimer) {
        this.KeepAliveTimer = keepAliveTimer;
    }

    public int getOSPFTCPPort() {
        return this.OSPFTCPPort;
    }

    public void setOSPFTCPPort(int oSPFTCPPort) {
        this.OSPFTCPPort = oSPFTCPPort;
    }

    public int getDeadTimer() {
        return this.DeadTimer;
    }

    public void setDeadTimer(int deadTimer) {
        this.DeadTimer = deadTimer;
    }

    public Layer getDefaultPCELayer() {
        return this.defaultPCELayer;
    }

    public void setDefaultPCELayer(Layer defaultPCELayer) {
        this.defaultPCELayer = defaultPCELayer;
    }

    public int getPCEManagementPort() {
        return this.PCEManagementPort;
    }

    public boolean isReservation() {
        return this.reservation;
    }

    public void setReservation(boolean reservation) {
        this.reservation = reservation;
    }

    public boolean isUseMaxReqTime() {
        return this.useMaxQueingTime;
    }

    public void setUseMaxReqTime(boolean useMaxReqTime) {
        this.useMaxQueingTime = useMaxReqTime;
    }

    public boolean isOSPFSession() {
        return this.OSPFSession;
    }

    public void setOSPFSession(boolean oSPFSession) {
        this.OSPFSession = oSPFSession;
    }

    public boolean isOSPFTCPSession() {
        return this.OSPFTCPSession;
    }

    public void setOSPFTCPSession(boolean oSPFTCPSession) {
        this.OSPFTCPSession = oSPFTCPSession;
    }

    public String getOSPFListenerIP() {
        return this.OSPFListenerIP;
    }

    public void setOSPFListenerIP(String oSPFListenerIP) {
        this.OSPFListenerIP = oSPFListenerIP;
    }

    public boolean isOSPFMulticast() {
        return this.OSPFMulticast;
    }

    public void setOSPFMulticast(boolean oSPFMulticast) {
        this.OSPFMulticast = oSPFMulticast;
    }

    public boolean isOSPFUnicast() {
        return this.OSPFUnicast;
    }

    public void setOSPFUnicast(boolean oSPFUnicast) {
        this.OSPFUnicast = oSPFUnicast;
    }

    public boolean isAnalyzeRequestTime() {
        return this.analyzeRequestTime;
    }

    public void setAnalyzeRequestTime(boolean analyzeRequestTime) {
        this.analyzeRequestTime = analyzeRequestTime;
    }

    public boolean isSetTraces() {
        return this.setTraces;
    }

    public boolean isMultilayer() {
        return this.multilayer;
    }

    public void setMultilayer(boolean multilayer) {
        this.multilayer = multilayer;
    }

    public boolean isMultidomain() {
        return this.multidomain;
    }

    public void setMultidomain(boolean multidomain) {
        this.multidomain = multidomain;
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public int getLambdaIni() {
        return this.lambdaIni;
    }

    public void setLambdaIni(int lambdaIni) {
        this.lambdaIni = lambdaIni;
    }

    public int getLambdaEnd() {
        return this.lambdaEnd;
    }

    public void setLambdaEnd(int lambdaEnd) {
        this.lambdaEnd = lambdaEnd;
    }

    public boolean isCollaborativePCEs() {
        return this.collaborativePCEs;
    }

    public void setCollaborativePCEs(boolean collaborativePCEs) {
        this.collaborativePCEs = collaborativePCEs;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public String getIpPrimaryPCE() {
        return this.ipPrimaryPCE;
    }

    public void setIpPrimaryPCE(String ipPrimaryPCE) {
        this.ipPrimaryPCE = ipPrimaryPCE;
    }

    public int getPortPrimaryPCE() {
        return this.portPrimaryPCE;
    }

    public void setPortPrimaryPCE(int portPrimaryPCE) {
        this.portPrimaryPCE = portPrimaryPCE;
    }

    public Inet4Address getIPBackupPCE() {
        return this.IPBackupPCE;
    }

    public boolean isTopologyModuleOption() {
        return this.topologyModuleOption;
    }

    public boolean isCompletedAuxGraph() {
        return this.isCompletedAuxGraph;
    }

    public void setCompletedAuxGraph(boolean isCompletedAuxGraph) {
        this.isCompletedAuxGraph = isCompletedAuxGraph;
    }

    public int getIdAlgo() {
        return this.idAlgo;
    }

    public void setIdAlgo(int idAlgo) {
        this.idAlgo = idAlgo;
    }

    public boolean isStateful() {
        return this.isStateful;
    }

    public void setStateful(boolean isStateful) {
        this.isStateful = isStateful;
    }

    public boolean isSRCapable() {
        return this.isSRCapable;
    }

    public int getMSD() {
        return this.MSD;
    }

    public void setSRCapable(boolean isSRCapable) {
        this.isSRCapable = isSRCapable;
    }

    public void setSRCapable(int MSD) {
        this.isSRCapable = MSD >= 0;
        this.MSD = MSD;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isActingAsBGP4Peer() {
        return this.actingAsBGP4Peer;
    }

    public String getBGP4File() {
        return this.BGP4File;
    }

    public String getLocalPceAddress() {
        return this.localPceAddress;
    }

    public void setLocalPceAddress(String localPceAddress) {
        this.localPceAddress = localPceAddress;
    }

    public ReportDB_Handler getLspDB() {
        return this.lspDB;
    }

    public void setLspDB(ReportDB_Handler lspDB) {
        this.lspDB = lspDB;
    }

    public boolean isWLAN() {
        return this.isWLAN;
    }

    public void setWLAN(boolean isWLAN) {
        this.isWLAN = isWLAN;
    }

    public String getControllerIP() {
        return this.controllerIP;
    }

    public void setControllerIP(String controllerIP) {
        this.controllerIP = controllerIP;
    }

    public String getControllerPORT() {
        return this.controllerPORT;
    }

    public void setControllerPORT(String controllerPORT) {
        this.controllerPORT = controllerPORT;
    }

    public String getTopologyPath() {
        return this.topologyPath;
    }

    public void setTopologyPath(String topologyPath) {
        this.topologyPath = topologyPath;
    }

    public String getInterDomainFile() {
        return this.interDomainFile;
    }

    public void setInterDomainFile(String interDomainFile) {
        this.interDomainFile = interDomainFile;
    }

    public String getControllerListFile() {
        return this.controllerListFile;
    }

    public void setControllerListFile(String controllerListFile) {
        this.controllerListFile = controllerListFile;
    }

    public boolean isStatefulDFlag() {
        return this.statefulDFlag;
    }

    public void setStatefulDFlag(boolean statefulDFlag) {
        this.statefulDFlag = statefulDFlag;
    }

    public boolean isStatefulTFlag() {
        return this.statefulTFlag;
    }

    public void setStatefulTFlag(boolean statefulTFlag) {
        this.statefulTFlag = statefulTFlag;
    }

    public boolean isStatefulSFlag() {
        return this.statefulSFlag;
    }

    public void setStatefulSFlag(boolean statefulSFlag) {
        this.statefulSFlag = statefulSFlag;
    }
}

