/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.pcep.constructs.Notify;
import es.tid.pce.pcep.objects.Notification;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationProcessorThread
extends Thread {
    private boolean running = true;
    private LinkedBlockingQueue<Notify> notificationList;
    private Logger log;

    public NotificationProcessorThread(LinkedBlockingQueue<Notify> notificationList) {
        this.notificationList = notificationList;
        this.log = LoggerFactory.getLogger("PCEServer");
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Notify notify = this.notificationList.take();
                LinkedList<Notification> notificationList = notify.getNotificationList();
                block13: for (int i = 0; i < notificationList.size(); ++i) {
                    Notification notif = notificationList.get(i);
                    switch (notif.getNotificationType()) {
                        case 100: {
                            this.log.info("PCEP NOTIFICATION TYPE: REACHABILITY");
                            continue block13;
                        }
                        case 101: {
                            this.log.info("PCEP NOTIFICATION TYPE: TOPOLOGY");
                            continue block13;
                        }
                        case 4: {
                            this.log.info("PCEP NOTIFICATION TYPE: IT RESOURCE INFORMATION");
                            continue block13;
                        }
                        case 120: {
                            this.log.info("PCEP NOTIFICATION TYPE: CANCEL RESERVATION");
                            continue block13;
                        }
                        case 0: {
                            this.log.info("PCEP NOTIFICATION VALUE: QUERY");
                            continue block13;
                        }
                        case 2: {
                            this.log.info("PCEP NOTIFICATION VALUE: CANCEL ALL RESERVATIONS");
                            continue block13;
                        }
                        case 1: {
                            this.log.info("PCEP NOTIFICATION VALUE: PATH RESERVATION");
                            continue block13;
                        }
                        case 121: {
                            this.log.info("PCEP NOTIFICATION TYPE: PRERESERVE");
                            LinkedList<Object> sourceVertexList = new LinkedList<Object>();
                            LinkedList<Object> targetVertexList = new LinkedList<Object>();
                            DWDMWavelengthLabel dwdmWavelengthLabel = new DWDMWavelengthLabel();
                            boolean lambdaToModify = false;
                            this.initializeVariables(notificationList.get(i).getNotificationTLV().geteRO().getEROSubobjectList(), sourceVertexList, targetVertexList, dwdmWavelengthLabel);
                            long time = notificationList.get(i).getNotificationTLV().getTime();
                            boolean bidirectional = notificationList.get(i).getNotificationTLV().isBidirectional();
                            continue block13;
                        }
                        default: {
                            this.log.error("Error: Unexpected Message");
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean initializeVariables(LinkedList<EROSubobject> erolist, LinkedList<Object> src, LinkedList<Object> dst, DWDMWavelengthLabel dwdmWavelengthLabel) {
        int number_lambdas = 0;
        boolean labelFound = false;
        for (int i = 0; i < erolist.size() - 1; ++i) {
            if (erolist.get(i).getType() == 3) {
                if (!labelFound) {
                    labelFound = true;
                    dwdmWavelengthLabel = ((GeneralizedLabelEROSubobject)erolist.get(i)).getDwdmWavelengthLabel();
                }
                ++number_lambdas;
            }
            if (erolist.get(i).getType() == 1) {
                src.add(i - number_lambdas, ((IPv4prefixEROSubobject)erolist.get(i)).getIpv4address());
            } else if (erolist.get(i).getType() == 4) {
                src.add(i - number_lambdas, ((UnnumberIfIDEROSubobject)erolist.get(i)).getRouterID());
            }
            if (erolist.get(i + 1).getType() == 1) {
                dst.add(i - number_lambdas, ((IPv4prefixEROSubobject)erolist.get(i + 1)).getIpv4address());
                continue;
            }
            if (erolist.get(i + 1).getType() == 4) {
                dst.add(i - number_lambdas, ((UnnumberIfIDEROSubobject)erolist.get(i + 1)).getRouterID());
                continue;
            }
            if (erolist.get(i + 1).getType() != 3) continue;
            if (erolist.get(i + 2).getType() == 1) {
                dst.add(i - number_lambdas, ((IPv4prefixEROSubobject)erolist.get(i + 2)).getIpv4address());
            } else if (erolist.get(i + 2).getType() == 4) {
                dst.add(i - number_lambdas, ((UnnumberIfIDEROSubobject)erolist.get(i + 2)).getRouterID());
            }
            return true;
        }
        return false;
    }
}

