/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPIntiatedLSP;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.pcep.objects.AssociationIPv4;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.LSP;
import es.tid.pce.pcep.objects.Metric;
import es.tid.pce.pcep.objects.SRP;
import es.tid.pce.pcep.objects.tlvs.ExtendedAssociationIDTLV;
import es.tid.pce.pcep.objects.tlvs.IPv4LSPIdentifiersTLV;
import es.tid.pce.pcep.objects.tlvs.PathProtectionAssociationTLV;
import es.tid.pce.pcep.objects.tlvs.PathSetupTLV;
import es.tid.pce.pcep.objects.tlvs.SRPolicyCandidatePathIdentifiersTLV;
import es.tid.pce.pcep.objects.tlvs.SRPolicyCandidatePathPreferenceTLV;
import es.tid.pce.pcep.objects.tlvs.SymbolicPathNameTLV;
import es.tid.pce.server.delegation.DelegationManager;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniPCCManager {
    private int nextId = 0;
    private Hashtable<Inet4Address, DataOutputStream> pccOutputStream;
    public Hashtable<Long, Object> inilocks = new Hashtable();
    private Hashtable<Long, StateReport> reports;
    private Logger log;

    public IniPCCManager() {
        this.pccOutputStream = new Hashtable();
        this.reports = new Hashtable();
        this.log = LoggerFactory.getLogger("PCEServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateReport newIni(PCEPInitiate pcini, Object node) {
        Object object_lock = new Object();
        long idSRP = pcini.getPcepIntiatedLSPList().get(0).getRsp().getSRP_ID_number();
        this.log.warn("SRP ID: " + idSRP);
        this.log.info("Sending PCEPInitiate to node " + node + "srp_id " + idSRP + " : " + pcini.toString());
        this.inilocks.put(new Long(idSRP), object_lock);
        try {
            this.sendInitiate(pcini, node);
        }
        catch (IOException e1) {
            this.log.warn("Problem with response from node " + node + " to initiate with srp_id " + idSRP);
            this.inilocks.remove(object_lock);
            return null;
        }
        Object e1 = object_lock;
        synchronized (e1) {
            try {
                this.log.debug("Request sent, waiting for response");
                object_lock.wait(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        StateReport resp = this.reports.get(new Long(idSRP));
        if (resp == null) {
            this.log.warn("No response from node " + node + " to initiate with srp_id " + idSRP);
        } else {
            this.log.info("Node " + node + " replied to Initiate with srp_id " + idSRP + " : " + resp.toString());
        }
        return resp;
    }

    public synchronized void sendInitiate(PCEPInitiate ini, Object node) throws IOException {
        try {
            ini.encode();
        }
        catch (PCEPProtocolViolationException e1) {
            e1.printStackTrace();
        }
        DataOutputStream out = this.pccOutputStream.get(node);
        if (out == null) {
            this.log.warn("There is no PCE for node " + node);
            throw new IOException();
        }
        try {
            this.log.info("Sending Initiate message to node " + node);
            out.write(ini.getBytes());
            out.flush();
        }
        catch (IOException e) {
            this.log.warn("Error sending Init: " + e.getMessage());
            throw e;
        }
    }

    public void notifyReport(StateReport sr) {
        long idRequest = sr.getSrp().getSRP_ID_number();
        this.log.info("Entrando en Notify Report de id " + idRequest);
        Object object_lock = this.inilocks.get(new Long(idRequest));
        this.reports.put(new Long(idRequest), sr);
        if (object_lock != null) {
            object_lock.notifyAll();
        }
        this.inilocks.remove(object_lock);
    }

    public Hashtable<Inet4Address, DataOutputStream> getPccOutputStream() {
        return this.pccOutputStream;
    }

    public void setPccOutputStream(Hashtable<Inet4Address, DataOutputStream> pccOutputStream) {
        this.pccOutputStream = pccOutputStream;
    }

    public synchronized void initiateLSP(EndPoints endPoints, ExplicitRouteObject ero, Object node, int signalingType, String name) {
        PCEPInitiate ini = new PCEPInitiate();
        PCEPIntiatedLSP inilsp = new PCEPIntiatedLSP();
        Metric metric = new Metric();
        BandwidthRequested bandwith = new BandwidthRequested();
        ini.getPcepIntiatedLSPList().add(inilsp);
        SRP srp = new SRP();
        srp.setSRP_ID_number(DelegationManager.getNextSRPID());
        inilsp.setEro(ero);
        endPoints.setPbit(true);
        inilsp.setEndPoint(endPoints);
        inilsp.setSrp(srp);
        LSP lsp = new LSP();
        lsp.setPbit(true);
        lsp.setAdministrativeFlag(true);
        lsp.setLspId(0);
        IPv4LSPIdentifiersTLV ta_good = new IPv4LSPIdentifiersTLV();
        String str = "1.1.1.1";
        Inet4Address ip_pcc = null;
        try {
            ip_pcc = (Inet4Address)Inet4Address.getByName(str);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        ta_good.setTunnelSenderIPAddress(ip_pcc);
        str = "1.1.1.2";
        Inet4Address ip_dest = null;
        try {
            ip_dest = (Inet4Address)Inet4Address.getByName(str);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        ta_good.setTunnelEndPointIPAddress(ip_dest);
        lsp.setLspIdentifiers_tlv(ta_good);
        PathSetupTLV path2 = new PathSetupTLV();
        path2.setPST(signalingType);
        srp.setPathSetupTLV(path2);
        inilsp.setLsp(lsp);
        bandwith.setBw(0.0f);
        inilsp.setBandwidth(bandwith);
        SymbolicPathNameTLV spn = new SymbolicPathNameTLV();
        spn.setSymbolicPathNameID(name.getBytes());
        lsp.setSymbolicPathNameTLV_tlv(spn);
        this.newIni(ini, node);
    }

    public synchronized int getNextId() {
        ++this.nextId;
        return this.nextId;
    }

    public void terminateLSP(int lsp_number, Object node) {
        PCEPInitiate terminate = new PCEPInitiate();
        PCEPIntiatedLSP inlsp = new PCEPIntiatedLSP();
        SRP srp = new SRP();
        srp.setSRP_ID_number(DelegationManager.getNextSRPID());
        srp.setRFlag(true);
        LSP lsp = new LSP();
        lsp.setRemoveFlag(true);
        lsp.setAdministrativeFlag(true);
        lsp.setLspId(lsp_number);
        inlsp.setLsp(lsp);
        inlsp.setSrp(srp);
        terminate.getPcepIntiatedLSPList().add(inlsp);
        this.newIni(terminate, node);
    }

    public void createCandidatePath(Object node, int color, Inet4Address ip_dest, int lsp_id, String policyName, String candidatePathName, String preference, ExplicitRouteObject ero) {
        Inet4Address ipp;
        PCEPInitiate initiate = new PCEPInitiate();
        PCEPIntiatedLSP inlsp = new PCEPIntiatedLSP();
        SRP srp = new SRP();
        srp.setSRP_ID_number(DelegationManager.getNextSRPID());
        PathSetupTLV path = new PathSetupTLV();
        path.setPST(1);
        srp.setPathSetupTLV(path);
        inlsp.setSrp(srp);
        this.log.warn("SRP: " + srp.toString());
        LSP lsp = new LSP();
        lsp.setAdministrativeFlag(true);
        lsp.setOpFlags(1);
        lsp.setLspId(0);
        SymbolicPathNameTLV spn = new SymbolicPathNameTLV();
        String name = "PCE-INI-2CPs-" + srp.getSRP_ID_number();
        spn.setSymbolicPathNameID(name.getBytes());
        lsp.setSymbolicPathNameTLV_tlv(spn);
        this.log.warn("LSP: " + lsp.toString());
        inlsp.setLsp(lsp);
        EndPointsIPv4 ep = new EndPointsIPv4();
        String src_ip = "10.95.90.56";
        try {
            ipp = (Inet4Address)Inet4Address.getByName(src_ip);
            ep.setSourceIP(ipp);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String dst_ip = "1.1.1.2";
        try {
            ipp = (Inet4Address)Inet4Address.getByName(dst_ip);
            ep.setDestIP(ipp);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        inlsp.setEndPoint(ep);
        AssociationIPv4 aso = new AssociationIPv4();
        String string_ip_source = "10.95.47.193";
        Inet4Address ip_source = null;
        SRPolicyCandidatePathIdentifiersTLV policyIds = new SRPolicyCandidatePathIdentifiersTLV();
        ExtendedAssociationIDTLV extended_aso = new ExtendedAssociationIDTLV();
        try {
            ip_source = (Inet4Address)InetAddress.getByName(string_ip_source);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        aso.setAssociationSource(ip_source);
        aso.setAssocType(6);
        aso.setAssocID(1);
        extended_aso.setColor(color);
        extended_aso.setEndpoint(ip_dest);
        aso.setExtended_ssociation_id_tlv(extended_aso);
        policyIds.setOriginatorAddress(ip_source);
        policyIds.setDiscriminator(0L);
        policyIds.setOriginatorASN(0L);
        policyIds.setProtocol(10);
        aso.setSr_policy_candidate_path_identifiers_tlv(policyIds);
        inlsp.getAssociationList().add(aso);
        candidatePathName = "PCE-INIPOL-CP-" + srp.getSRP_ID_number();
        if (preference != null) {
            SRPolicyCandidatePathPreferenceTLV pathPreference = new SRPolicyCandidatePathPreferenceTLV();
            pathPreference.setPreference(Long.parseLong(preference) + srp.getSRP_ID_number());
            aso.setSr_policy_candidate_path_preference_tlv(pathPreference);
        }
        this.log.warn("ASO: " + aso.toString());
        inlsp.setEro(ero);
        this.log.warn("ERO: " + ero.toString());
        initiate.getPcepIntiatedLSPList().add(inlsp);
        this.newIni(initiate, node);
    }

    public void deleteCandidatePath(Object node, int lsp_id) {
        PCEPInitiate initiate = new PCEPInitiate();
        PCEPIntiatedLSP inlsp = new PCEPIntiatedLSP();
        SRP srp = new SRP();
        srp.setSRP_ID_number(DelegationManager.getNextSRPID());
        srp.setRFlag(true);
        LSP lsp = new LSP();
        lsp.setRemoveFlag(true);
        lsp.setAdministrativeFlag(true);
        lsp.setLspId(lsp_id);
        inlsp.setLsp(lsp);
        inlsp.setSrp(srp);
        initiate.getPcepIntiatedLSPList().add(inlsp);
        this.newIni(initiate, node);
    }

    public void initiateLSPWP(EndPoints endPoints, ExplicitRouteObject ero, Object node, int signalingType, String name, String exclude, String id) {
        PCEPInitiate ini = new PCEPInitiate();
        PCEPIntiatedLSP inilsp = new PCEPIntiatedLSP();
        Metric metric = new Metric();
        BandwidthRequested bandwith = new BandwidthRequested();
        ini.getPcepIntiatedLSPList().add(inilsp);
        SRP srp = new SRP();
        srp.setSRP_ID_number(DelegationManager.getNextSRPID());
        PathSetupTLV path2 = new PathSetupTLV();
        path2.setPST(signalingType);
        srp.setPathSetupTLV(path2);
        inilsp.setEro(ero);
        inilsp.setEndPoint(endPoints);
        inilsp.setSrp(srp);
        LSP lsp = new LSP();
        lsp.setAdministrativeFlag(true);
        lsp.setOpFlags(1);
        lsp.setLspId(0);
        inilsp.setLsp(lsp);
        AssociationIPv4 aso = new AssociationIPv4();
        aso.setAssocID(0);
        aso.setAssocType(1);
        PathProtectionAssociationTLV path = new PathProtectionAssociationTLV();
        path.setData(Long.parseLong(exclude));
        ExtendedAssociationIDTLV ext = new ExtendedAssociationIDTLV();
        ext.setColor(Long.parseLong(id));
        ext.setEndpoint(null);
        aso.setExtended_ssociation_id_tlv(ext);
        String str = "10.95.45.107";
        Inet4Address ip_pcc = null;
        try {
            ip_pcc = (Inet4Address)Inet4Address.getByName(str);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        aso.setAssociationSource(ip_pcc);
        this.log.info("ASSO: " + aso.toString());
        inilsp.getAssociationList().add(aso);
        SymbolicPathNameTLV spn = new SymbolicPathNameTLV();
        spn.setSymbolicPathNameID(name.getBytes());
        lsp.setSymbolicPathNameTLV_tlv(spn);
        this.newIni(ini, node);
    }
}

