/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.computingEngine.ReportDispatcher;
import es.tid.pce.computingEngine.ReportProcessTask;
import es.tid.pce.computingEngine.RequestDispatcher;
import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.messages.PCEPClose;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.messages.PCEPMonReq;
import es.tid.pce.pcep.messages.PCEPNotification;
import es.tid.pce.pcep.messages.PCEPReport;
import es.tid.pce.pcep.messages.PCEPRequest;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.EndPointsUnnumberedIntf;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.OPEN;
import es.tid.pce.pcep.objects.P2PGeneralizedEndPoints;
import es.tid.pce.pcepsession.DeadTimerThread;
import es.tid.pce.pcepsession.GenericPCEPSession;
import es.tid.pce.pcepsession.KeepAliveThread;
import es.tid.pce.pcepsession.PCEPSessionsInformation;
import es.tid.pce.server.IniPCCManager;
import es.tid.pce.server.NotificationDispatcher;
import es.tid.pce.server.PCEServerParameters;
import es.tid.pce.server.SingleDomainInitiateDispatcher;
import es.tid.pce.server.management.PCEManagementSession;
import es.tid.util.UtilsFunctions;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Timer;
import org.slf4j.LoggerFactory;

public class DomainPCESession
extends GenericPCEPSession {
    private static HashMap<DataOutputStream, DataOutputStream> initiate_report_pair = new HashMap();
    private PCEServerParameters params;
    private RequestDispatcher requestDispatcher;
    private NotificationDispatcher notificationDispatcher;
    private long internalSessionID;
    private static long lastInternalSessionID = 0L;
    private SingleDomainInitiateDispatcher iniDispatcher;
    ReportDispatcher reportDispatcher = null;
    private IniPCCManager iniManager;

    public DomainPCESession(Socket s2, PCEServerParameters params, RequestDispatcher requestDispatcher, NotificationDispatcher notificationDispatcher, PCEPSessionsInformation pcepSessionInformation, ReportDispatcher reportDispatcher, SingleDomainInitiateDispatcher iniDispatcher) {
        super(pcepSessionInformation);
        this.setFSMstate(0);
        this.log = LoggerFactory.getLogger("PCEServer");
        this.log.info("New Domain PCESession: " + s2);
        this.socket = s2;
        try {
            s2.setTcpNoDelay(params.isNodelay());
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        this.requestDispatcher = requestDispatcher;
        this.params = params;
        this.timer = new Timer();
        this.keepAliveLocal = params.getKeepAliveTimer();
        this.deadTimerLocal = params.getDeadTimer();
        this.notificationDispatcher = notificationDispatcher;
        this.internalSessionID = this.getNewInternalSessionID();
        this.reportDispatcher = reportDispatcher;
        this.iniDispatcher = iniDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        PCEManagementSession.oneSession.add(this);
        this.remotePCEId = (Inet4Address)this.socket.getInetAddress();
        this.initializePCEPSession(this.params.isZeroDeadTimerPCCAccepted(), this.params.getMinKeepAliveTimerPCCAccepted(), this.params.getMaxDeadTimerPCCAccepted(), false, false, null, null, this.params.getLspDB() == null ? 0 : this.params.getLspDB().getPCCDatabaseVersion(this.remotePCEId));
        if (this.iniDispatcher != null) {
            this.iniManager = this.iniDispatcher.getIniManager();
            if (this.iniManager != null) {
                this.iniManager.getPccOutputStream().put(this.remotePeerIP, this.getOut());
            }
        }
        if (this.isSessionStateful && this.pcepSessionManager.isStateful()) {
            this.processOpen(this.open);
        }
        this.log.info("PCE Session succesfully established!!");
        this.deadTimerT = new DeadTimerThread(this, this.deadTimerLocal);
        this.startDeadTimer();
        this.keepAliveT = new KeepAliveThread(this.out, this.keepAliveLocal);
        this.startKeepAlive();
        try {
            while (this.FSMstate == 4) {
                try {
                    this.msg = this.params.isOptimizedRead() ? this.readMsgOptimized(this.in) : this.readMsg(this.in);
                }
                catch (IOException e) {
                    this.cancelDeadTimer();
                    this.cancelKeepAlive();
                    this.timer.cancel();
                    try {
                        this.in.close();
                        this.out.close();
                    }
                    catch (Exception e1) {
                        this.log.warn("AYAYAYYA Domain PCE Session");
                    }
                    this.log.warn("Finishing PCEP Session abruptly!");
                    this.log.error("SESSION " + this.internalSessionID + " IS KILLED");
                    this.FSMstate = 0;
                    this.endSession();
                    return;
                }
                if (this.msg == null) continue;
                pceMsg = true;
                switch (PCEPMessage.getMessageType(this.msg)) {
                    case 1: {
                        this.log.debug("OPEN message received");
                        this.log.warn("OPEN message ignored");
                        break;
                    }
                    case 2: {
                        this.log.debug("KEEPALIVE message received");
                        break;
                    }
                    case 7: {
                        this.log.debug("CLOSE message received");
                        try {
                            m_close = new PCEPClose(this.msg);
                            this.log.warn("Closing due to reason " + m_close.getReason());
                            this.killSession();
                        }
                        catch (PCEPProtocolViolationException e1) {
                            this.log.warn("Problem decoding message, closing session" + e1.getMessage());
                            this.killSession();
                            this.log.error("SESSION " + this.internalSessionID + " IS KILLED");
                            this.FSMstate = 0;
                            this.endSession();
                            return;
                        }
                        return;
                    }
                    case 6: {
                        this.log.debug("ERROR message received");
                        break;
                    }
                    case 5: {
                        this.log.info("Received NOTIFY message");
                        try {
                            m_not = new PCEPNotification(this.msg);
                            this.notificationDispatcher.dispatchNotification(m_not);
                        }
                        catch (PCEPProtocolViolationException e1) {
                            this.log.warn("Problem decoding notify message, ignoring message" + e1.getMessage());
                            e1.printStackTrace();
                        }
                        break;
                    }
                    case 10: {
                        this.log.info("Received Report message");
                        m_report = null;
                        try {
                            m_report = new PCEPReport(this.msg);
                            this.log.info("Report from " + this.remotePeerIP + ": " + m_report);
                            if (!this.localPcepCapability.isStateful()) ** GOTO lbl119
                            this.log.info("Received report from " + this.remotePeerIP);
                            try {
                                pcrpt = new PCEPReport(this.msg);
                                it = pcrpt.getStateReportList().iterator();
                                reportProcessed = false;
                                while (it.hasNext()) {
                                    sr = (StateReport)it.next();
                                    srp = sr.getSrp();
                                    if (srp != null) {
                                        this.log.info("SRP Id: " + sr.getSrp().getSRP_ID_number());
                                        lock = this.iniManager.inilocks.get(sr.getSrp().getSRP_ID_number());
                                        if (lock != null) {
                                            var10_21 = lock;
                                            synchronized (var10_21) {
                                                this.iniManager.notifyReport(sr);
                                                continue;
                                            }
                                        }
                                        if (this.reportDispatcher == null || reportProcessed) continue;
                                        rpt = new ReportProcessTask();
                                        rpt.setOut(this.out);
                                        rpt.setReportMessage(m_report);
                                        this.reportDispatcher.dispatchReport(rpt);
                                        reportProcessed = true;
                                        continue;
                                    }
                                    if (this.reportDispatcher == null || reportProcessed) continue;
                                    rpt = new ReportProcessTask();
                                    rpt.setOut(this.out);
                                    rpt.setReportMessage(m_report);
                                    this.reportDispatcher.dispatchReport(rpt);
                                    reportProcessed = true;
                                }
                                ** GOTO lbl124
                            }
                            catch (PCEPProtocolViolationException e) {
                                e.printStackTrace();
                                break;
                            }
lbl119:
                            // 1 sources

                            this.log.warn("PCE is NOT stateful, ignored report from " + this.remotePeerIP);
                        }
                        catch (PCEPProtocolViolationException e1) {
                            this.log.warn("Problem decoding report message, ignoring message" + e1.getMessage());
                            e1.printStackTrace();
                        }
lbl124:
                        // 3 sources

                        this.log.info("Report message decoded!");
                        if (DomainPCESession.initiate_report_pair.get(this.out) == null) break;
                        out_master = DomainPCESession.initiate_report_pair.get(this.out);
                        try {
                            m_report.encode();
                            out_master.write(m_report.getBytes());
                            out_master.flush();
                        }
                        catch (Exception e) {
                            this.log.error(UtilsFunctions.exceptionToString(e));
                            this.killSession();
                        }
                        break;
                    }
                    case 4: {
                        this.log.info("Received PC RESPONSE message");
                        break;
                    }
                    case 3: {
                        this.log.info("PCREQ message received");
                        try {
                            p_req = new PCEPRequest(this.msg);
                        }
                        catch (PCEPProtocolViolationException e) {
                            e.printStackTrace();
                            break;
                        }
                        this.requestDispatcher.dispathRequests(p_req, this.out);
                        break;
                    }
                    case 8: {
                        this.log.info("PCMonREQ message received");
                        try {
                            p_mon_req = new PCEPMonReq(this.msg);
                            p_mon_req.decode();
                        }
                        catch (PCEPProtocolViolationException e1) {
                            e1.printStackTrace();
                        }
                    }
                    case 12: {
                        this.log.info("INITIATE RECEIVED");
                        pcepInitiate = null;
                        try {
                            pcepInitiate = new PCEPInitiate(this.msg);
                            this.log.info("Initiate from " + this.remotePeerIP + ": " + pcepInitiate);
                        }
                        catch (PCEPProtocolViolationException e) {
                            this.log.info(UtilsFunctions.exceptionToString(e));
                        }
                        if (this.iniDispatcher == null) break;
                        this.iniDispatcher.dispathInitiate(pcepInitiate, this.out, this.remotePeerIP);
                        break;
                    }
                    case 9: {
                        this.log.info("PCMonREP message received");
                        break;
                    }
                    default: {
                        this.log.warn("ERROR: unexpected message received");
                        pceMsg = false;
                    }
                }
                if (!pceMsg) continue;
                this.log.debug("Reseting Dead Timer as PCEP Message has arrived");
                this.resetDeadTimer();
            }
        }
        finally {
            this.log.error("SESSION " + this.internalSessionID + " IS KILLED");
            this.FSMstate = 0;
            this.endSession();
        }
    }

    private void processOpen(OPEN open) {
        this.params.getLspDB().proccessOpen(open, this.remotePCEId);
    }

    @Override
    public void endSession() {
    }

    public synchronized long getNewInternalSessionID() {
        long num = ++lastInternalSessionID;
        return num;
    }

    public long getInternalSessionID() {
        return this.internalSessionID;
    }

    public String getSourceIP(Object endPoint) {
        String sourceIP = null;
        if (endPoint == null) {
            this.log.info("jm endPoint es null");
        } else if (endPoint instanceof EndPointsIPv4) {
            this.log.info("jm endPoint es de tipo EndPointsIPv4");
            sourceIP = ((EndPointsIPv4)endPoint).getSourceIP().toString();
        } else if (endPoint instanceof EndPointsUnnumberedIntf) {
            this.log.info("jm endPoint es de tipo EndPointsUnnumberedIntf");
            sourceIP = ((EndPointsUnnumberedIntf)endPoint).getSourceIP().toString();
        } else if (endPoint instanceof GeneralizedEndPoints) {
            this.log.info("jm endPoint es de tipo GeneralizedEndPoints");
            sourceIP = ((P2PGeneralizedEndPoints)endPoint).getSourceEndpoint().toString();
        } else {
            this.log.info("jm endPoint NO es de tipo conocido");
        }
        return sourceIP;
    }

    public String getDestinationIP(Object endPoint) {
        String destinationIP = null;
        if (endPoint == null) {
            this.log.info("jm endPoint es null");
        } else if (endPoint instanceof EndPointsIPv4) {
            this.log.info("jm endPoint es de tipo EndPointsIPv4");
            destinationIP = ((EndPointsIPv4)endPoint).getDestIP().toString();
        } else if (endPoint instanceof EndPointsUnnumberedIntf) {
            this.log.info("jm endPoint es de tipo EndPointsUnnumberedIntf");
            destinationIP = ((EndPointsUnnumberedIntf)endPoint).getDestIP().toString();
        } else if (endPoint instanceof GeneralizedEndPoints) {
            this.log.info("jm endPoint es de tipo GeneralizedEndPoints");
            destinationIP = ((P2PGeneralizedEndPoints)endPoint).getDestinationEndpoint().toString();
        } else {
            this.log.info("jm endPoint NO es de tipo conocido");
        }
        return destinationIP;
    }

    public RequestDispatcher getRequestDispatcher() {
        return this.requestDispatcher;
    }

    public void setRequestDispatcher(RequestDispatcher requestDispatcher) {
        this.requestDispatcher = requestDispatcher;
    }

    public ReportDispatcher getReportDispatcher() {
        return this.reportDispatcher;
    }

    public void setReportDispatcher(ReportDispatcher reportDispatcher) {
        this.reportDispatcher = reportDispatcher;
    }
}

