/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.computingEngine.ReportDispatcher;
import es.tid.pce.computingEngine.RequestDispatcher;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.subobjects.SREROSubobject;
import es.tid.pce.pcepsession.PCEPSessionsInformation;
import es.tid.pce.server.DomainPCESession;
import es.tid.pce.server.IniPCCManager;
import es.tid.pce.server.NotificationDispatcher;
import es.tid.pce.server.PCEServerParameters;
import es.tid.pce.server.SingleDomainInitiateDispatcher;
import es.tid.pce.server.lspdb.ReportDB_Handler;
import es.tid.pce.server.lspdb.SingleDomainLSPDB;
import es.tid.pce.server.management.PCEManagementSever;
import es.tid.pce.utils.StringToPCEP;
import io.grpc.stub.StreamObserver;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import src.main.proto.GrpcService;
import src.main.proto.pceServiceGrpc;

public class DomainPCEServer
extends pceServiceGrpc.pceServiceImplBase
implements Runnable {
    public static final Logger log = LoggerFactory.getLogger("PCEServer");
    private PCEPSessionsInformation pcepSessionsInformation;
    private static ReportDB_Handler rptdb;
    private static boolean listening;
    PCEServerParameters params;
    ServerSocket serverSocket;
    PCEManagementSever pms;
    SingleDomainLSPDB singleDomainLSPDB;
    RequestDispatcher PCCRequestDispatcher;
    IniPCCManager iniManager = null;
    ReportDispatcher PCCReportDispatcher = null;
    private GrpcService.commandRequest request;
    private GrpcService.commandRequest response;
    private GrpcService.LSPdb_Request lsp_request;
    private GrpcService.LSPdb_Response lsp_response;
    private GrpcService.Session_Request session_request;
    private GrpcService.Session_Response sessions_response;

    public void configure(String configFile) {
        this.params = configFile != null ? new PCEServerParameters(configFile) : new PCEServerParameters();
        this.params.initialize();
        log.info("Configuration file: " + configFile);
        log.info("Inizializing Netphony Domain PCE Server!!");
    }

    @Override
    public void update(GrpcService.commandRequest request, StreamObserver<GrpcService.commandResponse> responseObserver) {
        GrpcService.commandResponse response;
        this.request = request;
        String command = request.getCommand();
        System.out.println("Comando recibido: " + command);
        try {
            if (command.startsWith("update lsp")) {
                this.update_command(command.substring(11));
            } else if (command.startsWith("terminate lsp")) {
                this.terminate_command(command.substring(14));
            } else if (command.startsWith("initiate lsp")) {
                this.initiate_command(command.substring(13));
            } else {
                String errorMessage = "Invalid request: Unexistent method";
                System.out.println(errorMessage);
                throw new IllegalArgumentException(errorMessage);
            }
            response = this.buildSuccessResponse();
        }
        catch (Exception e) {
            e.printStackTrace();
            response = this.buildErrorResponse(e.getMessage());
        }
        responseObserver.onNext(response);
        try {
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private GrpcService.commandResponse buildSuccessResponse() {
        return GrpcService.commandResponse.newBuilder().setSuccess(true).build();
    }

    private GrpcService.commandResponse buildErrorResponse(String errorMessage) {
        return GrpcService.commandResponse.newBuilder().setSuccess(false).setErrorMessage(errorMessage).build();
    }

    @Override
    public void getLSPdb(GrpcService.LSPdb_Request lspreq, StreamObserver<GrpcService.LSPdb_Response> responseObserver) {
        this.lsp_request = lspreq;
        System.out.println("Comando GETLSPDB recibido: " + lspreq);
        String lspdb_data = null;
        try {
            lspdb_data = this.getSingleDomainLSPDB().toString();
        }
        catch (Exception e) {
            responseObserver.onError(e);
        }
        GrpcService.LSPdb_Response lspres = GrpcService.LSPdb_Response.newBuilder().setLSPdbData(lspdb_data).build();
        responseObserver.onNext(lspres);
        try {
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void getSessionsInfo(GrpcService.Session_Request sessreq, StreamObserver<GrpcService.Session_Response> responseObserver) {
        this.session_request = sessreq;
        System.out.println("Comando SessionRequest recibido: " + sessreq);
        String session_data = null;
        try {
            session_data = this.getPcepSessionsInformation().toString();
        }
        catch (Exception e) {
            responseObserver.onError(e);
        }
        GrpcService.Session_Response sessresp = GrpcService.Session_Response.newBuilder().setSessionData(session_data).build();
        responseObserver.onNext(sessresp);
        try {
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initiate_command(String command) {
        Inet4Address ipp;
        int offset = 0;
        StringTokenizer st = new StringTokenizer(command, " ");
        String name = st.nextToken();
        offset += name.length() + 1;
        String pcc = st.nextToken();
        Inet4Address ip_pcc = null;
        try {
            ip_pcc = (Inet4Address)Inet4Address.getByName(pcc);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        offset += pcc.length();
        EndPointsIPv4 ep = new EndPointsIPv4();
        String src_ip = st.nextToken();
        try {
            ipp = (Inet4Address)Inet4Address.getByName(src_ip);
            ep.setSourceIP(ipp);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String dst_ip = st.nextToken();
        try {
            ipp = (Inet4Address)Inet4Address.getByName(dst_ip);
            ep.setDestIP(ipp);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        ExplicitRouteObject ero = StringToPCEP.stringToExplicitRouteObject(command.substring(offset += src_ip.length() + 1 + dst_ip.length() + 1));
        int signalingType = 0;
        if (ero.getEROSubobjectList().getFirst() instanceof SREROSubobject) {
            signalingType = 1;
        }
        this.getIniManager().initiateLSP(ep, ero, ip_pcc, signalingType, name);
    }

    private void terminate_command(String command) {
        StringTokenizer st = new StringTokenizer(command, " ");
        String pcc = st.nextToken();
        Inet4Address ip_pcc = null;
        try {
            ip_pcc = (Inet4Address)Inet4Address.getByName(pcc);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String number = st.nextToken();
        int int_lsp_number = Integer.parseInt(number);
        this.getIniManager().terminateLSP(int_lsp_number, ip_pcc);
    }

    private void update_command(String command) throws UnknownHostException {
        int offset = 0;
        StringTokenizer st = new StringTokenizer(command, " ");
        String id_lsp_s = st.nextToken();
        offset += id_lsp_s.length() + 1;
        int id_lsp = Integer.parseInt(id_lsp_s);
        DataOutputStream out = null;
        Set<Long> keys = this.getPcepSessionsInformation().sessionList.keySet();
        for (Long key : keys) {
            System.out.println("Value of " + key + " is: " + this.getPcepSessionsInformation().sessionList.get(key));
            out = this.getPcepSessionsInformation().sessionList.get(key).getOut();
        }
        if (st.hasMoreTokens()) {
            ExplicitRouteObject ero = StringToPCEP.stringToExplicitRouteObject(command.substring(offset));
            this.getPCCReportDispatcher().getDm().updateDelegatedPath(id_lsp, false, ero, out);
        } else {
            this.getPCCReportDispatcher().getDm().updateDelegatedPath(id_lsp, true, null, out);
        }
    }

    @Override
    public void run() {
        this.pcepSessionsInformation = new PCEPSessionsInformation();
        this.pcepSessionsInformation.setStateful(this.params.isStateful());
        this.pcepSessionsInformation.setStatefulDFlag(this.params.isStatefulDFlag());
        this.pcepSessionsInformation.setStatefulSFlag(this.params.isStatefulSFlag());
        this.pcepSessionsInformation.setStatefulTFlag(this.params.isStatefulTFlag());
        this.pcepSessionsInformation.setActive(this.params.isActive());
        this.pcepSessionsInformation.setSRCapable(this.params.isSRCapable());
        this.pcepSessionsInformation.setMSD(this.params.getMSD());
        SingleDomainInitiateDispatcher iniDispatcher = null;
        if (this.params.isSRCapable()) {
            log.info("PCEServer: PCE is SR capable with MSD=" + this.pcepSessionsInformation.getMSD());
        }
        if (this.params.isStateful()) {
            log.info("Stateful PCE with T=" + this.params.isStatefulTFlag() + " D=" + this.params.isStatefulDFlag() + " S=" + this.params.isStatefulSFlag() + " U=true I=" + this.params.isActive());
            this.singleDomainLSPDB = new SingleDomainLSPDB();
            if (this.params.getDbType().equals("_")) {
                this.singleDomainLSPDB.setExportDb(false);
            }
            this.iniManager = new IniPCCManager();
            iniDispatcher = new SingleDomainInitiateDispatcher(this.singleDomainLSPDB, this.iniManager);
        }
        log.info("Initializing Request Dispatcher");
        NotificationDispatcher nd = new NotificationDispatcher();
        if (this.params.algorithmRuleList.size() == 0) {
            log.warn("There are no registered algorithms besides the default");
        }
        this.pms = new PCEManagementSever(this);
        this.pms.start();
        listening = true;
        try {
            log.info("Listening on port: " + this.params.getPCEServerPort());
            log.info("Listening on address: " + this.params.getLocalPceAddress());
            this.serverSocket = new ServerSocket(this.params.getPCEServerPort(), 0, (Inet4Address)InetAddress.getByName(this.params.getLocalPceAddress()));
            log.info("Socket Address: " + this.serverSocket.getInetAddress().getHostAddress());
        }
        catch (IOException e) {
            System.err.println("Could not listen on port: " + this.params.getPCEServerPort());
            System.exit(-1);
        }
        try {
            if (this.pcepSessionsInformation.isStateful()) {
                log.info("redis: " + this.params.getDbType() + " " + this.params.getDbName());
                if (this.params.getDbType().equals("redis") && this.params.getDbName().length() > 0) {
                    log.info("redis: redis db with id: " + this.params.getDbName());
                    rptdb = new ReportDB_Handler(this.params.getDbName(), "localhost");
                    rptdb.fillFromDB();
                } else {
                    rptdb = new ReportDB_Handler();
                }
                this.params.setLspDB(rptdb);
                log.info("Creando dispatchers para el LSP DB");
                this.PCCReportDispatcher = new ReportDispatcher(rptdb, 1, this.singleDomainLSPDB);
            }
            while (listening) {
                new DomainPCESession(this.serverSocket.accept(), this.params, this.PCCRequestDispatcher, nd, this.pcepSessionsInformation, this.PCCReportDispatcher, iniDispatcher).start();
            }
            this.serverSocket.close();
        }
        catch (SocketException e) {
            if (!listening) {
                log.info("Socket closed due to controlled close");
            } else {
                log.error("Problem with the socket, exiting");
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stopServer() {
        this.pms.stopServer();
        listening = false;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public PCEPSessionsInformation getPcepSessionsInformation() {
        return this.pcepSessionsInformation;
    }

    public void setPcepSessionsInformation(PCEPSessionsInformation pcepSessionsInformation) {
        this.pcepSessionsInformation = pcepSessionsInformation;
    }

    public static ReportDB_Handler getRptdb() {
        return rptdb;
    }

    public static void setRptdb(ReportDB_Handler rptdb) {
        DomainPCEServer.rptdb = rptdb;
    }

    public static boolean isListening() {
        return listening;
    }

    public static void setListening(boolean listening) {
        DomainPCEServer.listening = listening;
    }

    public PCEServerParameters getParams() {
        return this.params;
    }

    public void setParams(PCEServerParameters params) {
        this.params = params;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public PCEManagementSever getPms() {
        return this.pms;
    }

    public void setPms(PCEManagementSever pms) {
        this.pms = pms;
    }

    public SingleDomainLSPDB getSingleDomainLSPDB() {
        return this.singleDomainLSPDB;
    }

    public void setSingleDomainLSPDB(SingleDomainLSPDB singleDomainLSPDB) {
        this.singleDomainLSPDB = singleDomainLSPDB;
    }

    public static Logger getLog() {
        return log;
    }

    public RequestDispatcher getPCCRequestDispatcher() {
        return this.PCCRequestDispatcher;
    }

    public void setPCCRequestDispatcher(RequestDispatcher pCCRequestDispatcher) {
        this.PCCRequestDispatcher = pCCRequestDispatcher;
    }

    public IniPCCManager getIniManager() {
        return this.iniManager;
    }

    public void setIniManager(IniPCCManager iniManager) {
        this.iniManager = iniManager;
    }

    public ReportDispatcher getPCCReportDispatcher() {
        return this.PCCReportDispatcher;
    }

    public void setPCCReportDispatcher(ReportDispatcher pCCReportDispatcher) {
        this.PCCReportDispatcher = pCCReportDispatcher;
    }

    static {
        listening = false;
    }
}

