/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcepsession;

import es.tid.pce.management.PcepCapability;
import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.ErrorConstruct;
import es.tid.pce.pcep.messages.PCEPClose;
import es.tid.pce.pcep.messages.PCEPError;
import es.tid.pce.pcep.messages.PCEPKeepalive;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.messages.PCEPOpen;
import es.tid.pce.pcep.objects.OPEN;
import es.tid.pce.pcep.objects.PCEPErrorObject;
import es.tid.pce.pcep.objects.tlvs.EmptyDomainIDTLV;
import es.tid.pce.pcep.objects.tlvs.GMPLSCapabilityTLV;
import es.tid.pce.pcep.objects.tlvs.LSPDatabaseVersionTLV;
import es.tid.pce.pcep.objects.tlvs.OSPFDomainIDTLV;
import es.tid.pce.pcep.objects.tlvs.PCE_ID_TLV;
import es.tid.pce.pcep.objects.tlvs.SRCapabilityTLV;
import es.tid.pce.pcep.objects.tlvs.StatefulCapabilityTLV;
import es.tid.pce.pcepsession.DeadTimerThread;
import es.tid.pce.pcepsession.KeepAliveThread;
import es.tid.pce.pcepsession.KeepWaitTimerTask;
import es.tid.pce.pcepsession.OpenWaitTimerTask;
import es.tid.pce.pcepsession.PCEPSession;
import es.tid.pce.pcepsession.PCEPSessionsInformation;
import es.tid.pce.server.RequestQueue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Socket;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericPCEPSession
extends Thread
implements PCEPSession {
    protected PcepCapability localPcepCapability;
    protected PcepCapability peerPcepCapability;
    protected PCEPSessionsInformation pcepSessionManager;
    protected KeepAliveThread keepAliveT = null;
    protected int keepAliveLocal;
    protected int keepAlivePeer;
    protected DeadTimerThread deadTimerT = null;
    protected int deadTimerLocal;
    protected int deadTimerPeer;
    protected Socket socket = null;
    protected Inet4Address remotePeerIP;
    protected DataOutputStream out = null;
    protected DataInputStream in = null;
    protected RequestQueue req;
    protected Logger log;
    protected Timer timer;
    protected int FSMstate;
    protected Inet4Address remotePCEId = null;
    protected Inet4Address remoteDomainId = null;
    protected LinkedList<Integer> remoteOfCodes;
    protected boolean remoteOK = false;
    protected boolean localOK = false;
    protected int openRetry = 0;
    protected byte[] msg = null;
    public static long sessionIdCounter = 0L;
    private long sessionId;
    protected OPEN open;
    private boolean sendErrorStateful = false;
    protected boolean isSessionStateful = false;
    protected boolean isSessionSRCapable = false;
    protected int sessionMSD = 0;
    private long dbVersion;

    public GenericPCEPSession(PCEPSessionsInformation pcepSessionManager) {
        this.pcepSessionManager = pcepSessionManager;
        this.newSessionId();
        this.localPcepCapability = pcepSessionManager.getLocalPcepCapability();
        this.pcepSessionManager.addSession(this.sessionId, this);
        this.log = LoggerFactory.getLogger("PCCClient");
    }

    protected byte[] readMsg(DataInputStream in) throws IOException {
        byte[] ret = null;
        byte[] hdr = new byte[4];
        byte[] temp = null;
        boolean endHdr = false;
        int r = 0;
        int length = 0;
        boolean endMsg = false;
        int offset = 0;
        while (!endMsg) {
            try {
                r = endHdr ? in.read(temp, offset, 1) : in.read(hdr, offset, 1);
            }
            catch (IOException e) {
                this.log.info("Mistake reading data: " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.log.info("readMsg Oops: " + e.getMessage());
                throw new IOException();
            }
            if (r > 0) {
                if (offset == 2) {
                    length = (hdr[offset] & 0xFF) << 8;
                }
                if (offset == 3) {
                    temp = new byte[length |= hdr[offset] & 0xFF];
                    endHdr = true;
                    System.arraycopy(hdr, 0, temp, 0, 4);
                }
                if (length > 0 && offset == length - 1) {
                    endMsg = true;
                }
                ++offset;
                continue;
            }
            if (r != -1) continue;
            this.log.info("End of stream has been reached from " + this.remotePeerIP);
            throw new IOException();
        }
        if (length > 0) {
            ret = new byte[length];
            System.arraycopy(temp, 0, ret, 0, length);
        }
        return ret;
    }

    protected byte[] readMsgOptimized(DataInputStream in) throws IOException {
        byte[] ret = null;
        byte[] hdr = new byte[4];
        byte[] temp = null;
        boolean endHdr = false;
        int r = 0;
        int length = 0;
        boolean endMsg = false;
        int offset = 0;
        while (!endMsg) {
            try {
                if (endHdr) {
                    r = in.read(temp, offset, length - offset);
                    if (r > 0) {
                        if (offset + r >= length) {
                            endMsg = true;
                            continue;
                        }
                        offset += r;
                        continue;
                    }
                    if (r >= 0) continue;
                    this.log.error("End of stream has been reached reading data");
                    throw new IOException();
                }
                r = in.read(hdr, offset, 4 - offset);
                if (r < 0) {
                    this.log.error("End of stream has been reached reading header");
                    throw new IOException();
                }
                if (r <= 0) continue;
                if (offset + r >= 4) {
                    length = (hdr[offset + 2] & 0xFF) << 8 | hdr[offset + 3] & 0xFF;
                    offset = 4;
                    temp = new byte[length];
                    endHdr = true;
                    System.arraycopy(hdr, 0, temp, 0, 4);
                    if (length != 4) continue;
                    endMsg = true;
                    continue;
                }
                offset += r;
            }
            catch (IOException e) {
                this.log.error("Error reading data: " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.log.error("readMsg Oops: " + e.getMessage());
                this.log.error("FALLO POR : " + e.getStackTrace());
                throw new IOException();
            }
        }
        if (length > 0) {
            ret = new byte[length];
            System.arraycopy(temp, 0, ret, 0, length);
        }
        return ret;
    }

    @Override
    public void close(int reason) {
        this.log.info("Closing PCEP Session with " + this.remotePeerIP);
        PCEPClose p_close = new PCEPClose();
        p_close.setReason(reason);
        this.sendPCEPMessage(p_close);
        this.killSession();
    }

    public DataOutputStream getOut() {
        return this.out;
    }

    public void setOut(DataOutputStream out) {
        this.out = out;
    }

    protected void startDeadTimer() {
        this.deadTimerT.start();
    }

    protected void resetDeadTimer() {
        if (this.deadTimerT != null) {
            this.deadTimerT.interrupt();
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    protected void cancelDeadTimer() {
        this.log.debug("Cancelling DeadTimer from " + this.remotePeerIP);
        if (this.deadTimerT != null) {
            this.deadTimerT.stopRunning();
            this.deadTimerT.interrupt();
            this.deadTimerT = null;
        }
    }

    public void startKeepAlive() {
        this.keepAliveT.start();
    }

    public void cancelKeepAlive() {
        this.log.debug("Cancelling KeepAliveTimer from " + this.remotePeerIP);
        if (this.keepAliveT != null) {
            this.keepAliveT.stopRunning();
            this.keepAliveT.interrupt();
            this.keepAliveT = null;
        }
    }

    protected void endConnections() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.socket != null) {
                this.log.info("Closing socket with " + this.remotePeerIP);
                this.socket.close();
            }
        }
        catch (Exception e) {
            this.log.info("Error closing connections: " + e.getMessage());
        }
    }

    public int getFSMstate() {
        return this.FSMstate;
    }

    protected void setFSMstate(int fSMstate) {
        this.FSMstate = fSMstate;
    }

    @Override
    public void killSession() {
        this.log.info("Killing Session with " + this.remotePeerIP);
        this.pcepSessionManager.notifyPeerSessionInactive((Inet4Address)this.socket.getInetAddress());
        this.timer.cancel();
        this.endConnections();
        this.cancelDeadTimer();
        this.cancelKeepAlive();
        this.endSession();
        this.pcepSessionManager.deleteSession(this.sessionId);
        this.interrupt();
    }

    protected abstract void endSession();

    protected void initializePCEPSession(boolean zeroDeadTimerAccepted, int minimumKeepAliveTimerAccepted, int maxDeadTimerAccepted, boolean isParentPCE, boolean requestsParentPCE, Inet4Address domainId, Inet4Address pceId, int databaseVersion) {
        this.remotePeerIP = (Inet4Address)this.socket.getInetAddress();
        byte[] msg = null;
        try {
            this.out = new DataOutputStream(this.socket.getOutputStream());
            this.in = new DataInputStream(this.socket.getInputStream());
        }
        catch (IOException e) {
            this.log.info("Problem in the sockets, ending PCEPSession");
            this.killSession();
            return;
        }
        this.pcepSessionManager.notifyPeer((Inet4Address)this.socket.getInetAddress());
        this.setFSMstate(2);
        this.log.info("Entering PCEP_STATE_OPEN_WAIT");
        this.log.info("Scheduling Open Wait Timer");
        OpenWaitTimerTask owtt = new OpenWaitTimerTask(this);
        this.timer.schedule((TimerTask)owtt, 60000L);
        KeepWaitTimerTask kwtt = new KeepWaitTimerTask(this);
        this.log.info("Sending OPEN Message");
        PCEPOpen p_open_snd = new PCEPOpen();
        p_open_snd.setKeepalive(this.keepAliveLocal);
        p_open_snd.setDeadTimer(this.deadTimerLocal);
        if (isParentPCE) {
            p_open_snd.getOpen().setParentPCEIndicationBit(true);
        }
        if (requestsParentPCE) {
            p_open_snd.getOpen().setParentPCERequestBit(true);
            OSPFDomainIDTLV domain_id_tlv = new OSPFDomainIDTLV();
            domain_id_tlv.setDomainId(domainId);
            p_open_snd.getOpen().setDomain_id_tlv(domain_id_tlv);
            PCE_ID_TLV pce_id_tlv = new PCE_ID_TLV();
            pce_id_tlv.setPceId(pceId);
            p_open_snd.getOpen().setPce_id_tlv(pce_id_tlv);
        }
        if (this.pcepSessionManager.getLocalPcepCapability().isStateful()) {
            this.log.info("Stateful: " + this.pcepSessionManager.isStateful() + " Active: " + this.pcepSessionManager.isActive() + " Trigger sync: " + this.pcepSessionManager.isStatefulTFlag() + " Incremental sync: " + this.pcepSessionManager.isStatefulDFlag() + " include the LSP-DB-VERSION: " + this.pcepSessionManager.isStatefulSFlag());
            StatefulCapabilityTLV stateful_capability_tlv = new StatefulCapabilityTLV();
            stateful_capability_tlv.setUFlag(true);
            stateful_capability_tlv.setDFlag(this.pcepSessionManager.isStatefulDFlag());
            stateful_capability_tlv.setTFlag(this.pcepSessionManager.isStatefulTFlag());
            stateful_capability_tlv.setSFlag(this.pcepSessionManager.isStatefulSFlag());
            stateful_capability_tlv.setIFlag(this.pcepSessionManager.getLocalPcepCapability().isInstantiationCapability());
            p_open_snd.getOpen().setStateful_capability_tlv(stateful_capability_tlv);
            if (this.pcepSessionManager.isStatefulSFlag()) {
                LSPDatabaseVersionTLV lsp_database_version = new LSPDatabaseVersionTLV();
                lsp_database_version.setLSPStateDBVersion(databaseVersion);
                p_open_snd.getOpen().setLsp_database_version_tlv(lsp_database_version);
            }
        }
        if (this.pcepSessionManager.isSRCapable()) {
            SRCapabilityTLV SR_capability_tlv = new SRCapabilityTLV();
            SR_capability_tlv.setMSD(this.pcepSessionManager.getMSD());
            p_open_snd.getOpen().setSR_capability_tlv(SR_capability_tlv);
            this.log.info("SR: " + this.pcepSessionManager.isSRCapable() + " MSD: " + this.pcepSessionManager.getMSD());
        }
        if (this.pcepSessionManager.isRsvpCapable()) {
            SRCapabilityTLV Rsvp_capability_tlv = new SRCapabilityTLV();
            Rsvp_capability_tlv.setMSD(this.pcepSessionManager.getMSD());
        }
        if (this.pcepSessionManager.getLocalPcepCapability().isGmpls()) {
            GMPLSCapabilityTLV gmplsCapabilityTLV = new GMPLSCapabilityTLV();
            p_open_snd.getOpen().setGmplsCapabilityTLV(gmplsCapabilityTLV);
        }
        this.sendPCEPMessage(p_open_snd);
        block13: while (this.FSMstate != 4) {
            PCEPErrorObject perrorObject;
            PCEPError perror;
            try {
                msg = this.readMsg(this.in);
            }
            catch (IOException e) {
                this.log.info("Error reading message, ending session" + e.getMessage());
                this.killSession();
                return;
            }
            if (msg != null) {
                switch (PCEPMessage.getMessageType(msg)) {
                    case 1: {
                        this.log.info("OPEN Message Received");
                        if (this.FSMstate == 2) {
                            try {
                                PCEPOpen p_open = new PCEPOpen(msg);
                                this.log.debug(p_open.toString());
                                owtt.cancel();
                                if (this.openRetry == 1) {
                                    boolean checkOK = true;
                                    boolean stateFulOK = true;
                                    boolean SROK = true;
                                    boolean updateEffective = false;
                                    int MSD = -1;
                                    this.deadTimerPeer = p_open.getDeadTimer();
                                    this.keepAlivePeer = p_open.getKeepalive();
                                    if (this.deadTimerPeer > maxDeadTimerAccepted) {
                                        checkOK = false;
                                    }
                                    if (this.deadTimerPeer == 0 && !zeroDeadTimerAccepted) {
                                        checkOK = false;
                                    }
                                    if (this.keepAlivePeer < minimumKeepAliveTimerAccepted) {
                                        checkOK = false;
                                    }
                                    if (!(this.pcepSessionManager.isStateful() || p_open.getOpen().getRedundancy_indetifier_tlv() == null && p_open.getOpen().getLsp_database_version_tlv() == null && p_open.getOpen().getStateful_capability_tlv() == null)) {
                                        this.log.info("I'm not expeting Stateful session");
                                        stateFulOK = false;
                                    } else if (this.pcepSessionManager.isStateful() && p_open.getOpen().getStateful_capability_tlv() == null) {
                                        this.log.info("I'm expeting Stateful session");
                                        stateFulOK = false;
                                    } else if (this.pcepSessionManager.isStateful() && p_open.getOpen().getStateful_capability_tlv() != null) {
                                        updateEffective = p_open.getOpen().getStateful_capability_tlv().isUFlag();
                                        this.log.info("Other PCEP speaker is also stateful");
                                    } else {
                                        this.log.info("Both PCEP speakers aren't stateful");
                                    }
                                    if (!this.pcepSessionManager.isSRCapable() && p_open.getOpen().getSR_capability_tlv() != null) {
                                        this.log.info("I'm not expecting SR session");
                                        SROK = false;
                                    } else if (this.pcepSessionManager.isSRCapable() && p_open.getOpen().getSR_capability_tlv() == null) {
                                        this.log.info("I'm expeting SR capable session");
                                        SROK = false;
                                    } else if (this.pcepSessionManager.isSRCapable() && p_open.getOpen().getSR_capability_tlv() != null) {
                                        this.sessionMSD = MSD = p_open.getOpen().getSR_capability_tlv().getMSD();
                                        this.log.info("Other component is also SR capable with MSD= " + p_open.getOpen().getSR_capability_tlv().getMSD());
                                    } else {
                                        this.log.info("Neither of us are SR capable :(");
                                    }
                                    if (!stateFulOK) {
                                        // empty if block
                                    }
                                    if (!this.pcepSessionManager.isStateful() || !updateEffective) {
                                        // empty if block
                                    }
                                    if (!checkOK) {
                                        this.log.info("Dont accept deadTimerPeer " + this.deadTimerPeer + "keepAlivePeer " + this.keepAlivePeer);
                                        PCEPError perror2 = new PCEPError();
                                        PCEPErrorObject perrorObject2 = new PCEPErrorObject();
                                        perrorObject2.setErrorType(1);
                                        perrorObject2.setErrorValue(5);
                                        ErrorConstruct error_c = new ErrorConstruct();
                                        error_c.getErrorObjList().add(perrorObject2);
                                        LinkedList<ErrorConstruct> ec = new LinkedList<ErrorConstruct>();
                                        ec.add(error_c);
                                        perror2.setErrorList(ec);
                                        this.log.info("Sending Error and ending PCEPSession");
                                        this.sendPCEPMessage(perror2);
                                        continue block13;
                                    }
                                    this.log.info("Accept deadTimerPeer " + this.deadTimerPeer + "keepAlivePeer " + this.keepAlivePeer);
                                    if (p_open.getOpen().getPce_id_tlv() != null) {
                                        this.remotePCEId = p_open.getOpen().getPce_id_tlv().getPceId();
                                    }
                                    if (p_open.getOpen().getDomain_id_tlv() != null && !(p_open.getOpen().getDomain_id_tlv() instanceof EmptyDomainIDTLV) && p_open.getOpen().getDomain_id_tlv() instanceof OSPFDomainIDTLV) {
                                        this.remoteDomainId = ((OSPFDomainIDTLV)p_open.getOpen().getDomain_id_tlv()).getDomainId();
                                    }
                                    if (p_open.getOpen().getOf_list_tlv() != null) {
                                        this.remoteOfCodes = p_open.getOpen().getOf_list_tlv().getOfCodes();
                                    }
                                    this.log.debug("Sending KA to confirm");
                                    PCEPKeepalive p_ka = new PCEPKeepalive();
                                    this.log.debug("Sending Keepalive message");
                                    this.sendPCEPMessage(p_ka);
                                    this.deadTimerPeer = p_open.getDeadTimer();
                                    this.keepAlivePeer = p_open.getKeepalive();
                                    this.remoteOK = true;
                                    if (this.localOK) {
                                        this.log.info("Entering STATE_SESSION_UP");
                                        this.setFSMstate(4);
                                    } else {
                                        this.log.info("Entering STATE_KEEP_WAIT");
                                        this.log.debug("Scheduling KeepwaitTimer");
                                        this.timer.schedule((TimerTask)kwtt, 60000L);
                                        this.setFSMstate(3);
                                    }
                                    if (this.pcepSessionManager.isStateful()) {
                                        this.log.info("open object saved: " + p_open.getOpen());
                                        this.open = p_open.getOpen();
                                        this.isSessionStateful = true;
                                    }
                                    if (!this.pcepSessionManager.isSRCapable()) continue block13;
                                    this.isSessionSRCapable = true;
                                    this.sessionMSD = this.pcepSessionManager.getMSD();
                                    continue block13;
                                }
                                boolean dtOK = true;
                                boolean kaOK = true;
                                boolean stateFulOK = true;
                                boolean SROK = true;
                                boolean updateEffective = false;
                                int MSD = -1;
                                if (!(this.pcepSessionManager.isStateful() || p_open.getOpen().getRedundancy_indetifier_tlv() == null && p_open.getOpen().getLsp_database_version_tlv() == null && p_open.getOpen().getStateful_capability_tlv() == null)) {
                                    this.log.info("I'm not expeting Stateful session");
                                    stateFulOK = false;
                                } else if (this.pcepSessionManager.isStateful() && p_open.getOpen().getStateful_capability_tlv() == null) {
                                    this.log.info("I'm expeting Stateful session");
                                    stateFulOK = false;
                                } else if (this.pcepSessionManager.isStateful() && p_open.getOpen().getStateful_capability_tlv() != null) {
                                    updateEffective = p_open.getOpen().getStateful_capability_tlv().isUFlag();
                                    this.log.info("Other PCEP speaker is also stateful");
                                } else {
                                    this.log.info("Both PCEP speakers aren't stateful");
                                }
                                if (!this.pcepSessionManager.isSRCapable() && p_open.getOpen().getSR_capability_tlv() != null) {
                                    this.log.info("I'm not expecting SR session");
                                    SROK = false;
                                } else if (this.pcepSessionManager.isSRCapable() && p_open.getOpen().getSR_capability_tlv() == null) {
                                    this.log.info("I'm expeting SR capable session");
                                    SROK = false;
                                } else if (this.pcepSessionManager.isSRCapable() && p_open.getOpen().getSR_capability_tlv() != null) {
                                    this.sessionMSD = MSD = p_open.getOpen().getSR_capability_tlv().getMSD();
                                    this.log.info("Other component is also SR capable with MSD= " + p_open.getOpen().getSR_capability_tlv().getMSD());
                                } else {
                                    this.log.info("Neither of us are SR capable :(");
                                }
                                if (!stateFulOK) {
                                    // empty if block
                                }
                                if (!this.pcepSessionManager.isStateful() || !updateEffective) {
                                    // empty if block
                                }
                                if (p_open.getDeadTimer() > maxDeadTimerAccepted) {
                                    dtOK = false;
                                }
                                if (p_open.getDeadTimer() == 0 && !zeroDeadTimerAccepted) {
                                    dtOK = false;
                                }
                                if (p_open.getKeepalive() < minimumKeepAliveTimerAccepted) {
                                    kaOK = false;
                                }
                                if (!kaOK || !dtOK) {
                                    this.log.info("PEER PCC Open parameters are unaccpetable, but negotiable");
                                    PCEPError perror3 = new PCEPError();
                                    PCEPErrorObject perrorObject3 = new PCEPErrorObject();
                                    perrorObject3.setErrorType(1);
                                    perrorObject3.setErrorValue(4);
                                    if (!dtOK) {
                                        p_open.setDeadTimer(this.deadTimerLocal);
                                    }
                                    if (!kaOK) {
                                        p_open.setKeepalive(this.keepAliveLocal);
                                    }
                                    if (!stateFulOK) {
                                        p_open.setKeepalive(this.keepAliveLocal);
                                    }
                                    if (!SROK) {
                                        p_open.setKeepalive(this.keepAliveLocal);
                                    }
                                    LinkedList<PCEPErrorObject> perrobjlist = new LinkedList<PCEPErrorObject>();
                                    perrobjlist.add(perrorObject3);
                                    perror3.setErrorObjList(perrobjlist);
                                    perror3.setOpen(p_open.getOpen());
                                    this.log.info("Sending Error with new proposal");
                                    this.sendPCEPMessage(perror3);
                                    ++this.openRetry;
                                    if (this.localOK) {
                                        this.log.info("Local ok esta a true, vamos a open wait");
                                        owtt.cancel();
                                        owtt = new OpenWaitTimerTask(this);
                                        this.timer.schedule((TimerTask)owtt, 60000L);
                                        this.setFSMstate(2);
                                        continue block13;
                                    }
                                    this.log.info("Local ok esta a false, vamos a keep wait");
                                    owtt.cancel();
                                    this.setFSMstate(3);
                                    this.timer.schedule((TimerTask)kwtt, 60000L);
                                    continue block13;
                                }
                                if (p_open.getOpen().getPce_id_tlv() != null) {
                                    this.remotePCEId = p_open.getOpen().getPce_id_tlv().getPceId();
                                }
                                if (p_open.getOpen().getDomain_id_tlv() != null && !(p_open.getOpen().getDomain_id_tlv() instanceof EmptyDomainIDTLV) && p_open.getOpen().getDomain_id_tlv() instanceof OSPFDomainIDTLV) {
                                    this.remoteDomainId = ((OSPFDomainIDTLV)p_open.getOpen().getDomain_id_tlv()).getDomainId();
                                }
                                if (p_open.getOpen().getOf_list_tlv() != null) {
                                    this.remoteOfCodes = p_open.getOpen().getOf_list_tlv().getOfCodes();
                                }
                                this.log.debug("Sending KA to confirm");
                                PCEPKeepalive p_ka = new PCEPKeepalive();
                                this.log.debug("Sending Keepalive message");
                                this.sendPCEPMessage(p_ka);
                                this.deadTimerPeer = p_open.getDeadTimer();
                                this.keepAlivePeer = p_open.getKeepalive();
                                this.remoteOK = true;
                                if (this.localOK) {
                                    this.log.info("Entering STATE_SESSION_UP");
                                    this.setFSMstate(4);
                                } else {
                                    this.log.info("Entering STATE_KEEP_WAIT");
                                    this.log.debug("Scheduling KeepwaitTimer");
                                    this.timer.schedule((TimerTask)kwtt, 60000L);
                                    this.setFSMstate(3);
                                }
                                if (this.pcepSessionManager.isStateful()) {
                                    this.log.info("open object saved: " + p_open.getOpen());
                                    this.open = p_open.getOpen();
                                    this.isSessionStateful = true;
                                }
                                if (!this.pcepSessionManager.isSRCapable()) continue block13;
                                this.isSessionSRCapable = true;
                                this.sessionMSD = this.pcepSessionManager.getMSD();
                            }
                            catch (PCEPProtocolViolationException e1) {
                                this.log.info("Malformed OPEN, INFORM ERROR and close");
                                e1.printStackTrace();
                                PCEPError perror4 = new PCEPError();
                                PCEPErrorObject perrorObject4 = new PCEPErrorObject();
                                perrorObject4.setErrorType(1);
                                perrorObject4.setErrorValue(1);
                                perror4.getErrorObjList().add(perrorObject4);
                                this.log.info("Sending Error and ending PCEPSession");
                                this.sendPCEPMessage(perror4);
                                this.pcepSessionManager.notifyPeerSessionFail((Inet4Address)this.socket.getInetAddress());
                                this.killSession();
                            }
                            continue block13;
                        }
                        this.log.info("Ignore OPEN message, already one received!!");
                        continue block13;
                    }
                    case 2: {
                        this.log.info("KeepAlive Message Received");
                        this.localOK = true;
                        if (this.FSMstate != 3) continue block13;
                        if (this.remoteOK) {
                            kwtt.cancel();
                            this.log.info("Entering STATE_SESSION_UP");
                            this.setFSMstate(4);
                            continue block13;
                        }
                        kwtt.cancel();
                        this.log.info("Entering OPEN WAIT STATE");
                        owtt = new OpenWaitTimerTask(this);
                        this.timer.schedule((TimerTask)owtt, 60000L);
                        this.setFSMstate(2);
                        continue block13;
                    }
                    case 6: {
                        this.log.info("ERROR Message Received");
                        try {
                            PCEPError msg_error = new PCEPError(msg);
                            if (this.FSMstate == 3) {
                                int errorValue = msg_error.getErrorObjList().get(0).getErrorValue();
                                if (errorValue != 4) continue block13;
                                this.log.info("ERROR_ESTABLISHMENT_UNACCEPTABLE_NEGOTIABLE_SESSION_CHARACTERISTICS");
                                boolean checkOK = true;
                                if (msg_error.getOpen().getDeadtimer() > maxDeadTimerAccepted) {
                                    checkOK = false;
                                }
                                if (msg_error.getOpen().getDeadtimer() == 0 && !zeroDeadTimerAccepted) {
                                    checkOK = false;
                                }
                                if (msg_error.getOpen().getKeepalive() < minimumKeepAliveTimerAccepted) {
                                    checkOK = false;
                                }
                                if (!checkOK) {
                                    PCEPError perror5 = new PCEPError();
                                    PCEPErrorObject perrorObject5 = new PCEPErrorObject();
                                    perrorObject5.setErrorType(1);
                                    perrorObject5.setErrorValue(6);
                                    perror5.getErrorObjList().add(perrorObject5);
                                    this.log.info("Sending Error and ending PCEPSession");
                                    this.sendPCEPMessage(perror5);
                                    this.killSession();
                                    return;
                                }
                                this.deadTimerLocal = msg_error.getOpen().getDeadtimer();
                                this.keepAliveLocal = msg_error.getOpen().getKeepalive();
                                PCEPOpen p_open_snd2 = new PCEPOpen();
                                p_open_snd2.setKeepalive(this.keepAliveLocal);
                                p_open_snd2.setDeadTimer(this.deadTimerLocal);
                                this.sendPCEPMessage(p_open_snd2);
                                if (this.remoteOK) {
                                    kwtt.cancel();
                                    this.setFSMstate(3);
                                    continue block13;
                                }
                                kwtt.cancel();
                                this.timer.schedule((TimerTask)owtt, 60000L);
                                this.setFSMstate(2);
                                continue block13;
                            }
                            this.log.info("Received PCErr and paramaters cant't be negotiated. PCEP Channel will be closed");
                        }
                        catch (PCEPProtocolViolationException e1) {
                            this.log.info("problem decoding error, finishing PCEPSession " + e1);
                            this.killSession();
                        }
                        continue block13;
                    }
                }
                this.log.info("UNEXPECTED Message Received");
                if (this.FSMstate != 2) {
                    this.log.info("Ignore OPEN message, already one received!!");
                    continue;
                }
                this.log.info("Unexpected message RECEIVED, closing");
                perror = new PCEPError();
                perrorObject = new PCEPErrorObject();
                perrorObject.setErrorType(1);
                perrorObject.setErrorValue(1);
                this.log.info("Sending Error and ending PCEPSession");
                perror.getErrorObjList().add(perrorObject);
                this.sendPCEPMessage(perror);
                continue;
            }
            if (this.FSMstate != 2) {
                this.log.info("Ignore message, already one received!!");
                continue;
            }
            this.log.info("Unexpected message RECEIVED, closing");
            perror = new PCEPError();
            perrorObject = new PCEPErrorObject();
            perrorObject.setErrorType(1);
            perrorObject.setErrorValue(1);
            perror.getErrorObjList().add(perrorObject);
            this.sendPCEPMessage(perror);
        }
        this.pcepSessionManager.notifyPeerSessionOK((Inet4Address)this.socket.getInetAddress());
    }

    @Override
    public void sendPCEPMessage(PCEPMessage message) {
        try {
            message.encode();
        }
        catch (PCEPProtocolViolationException e11) {
            this.log.error("ERROR ENCODING ERROR OBJECT, BUG DETECTED, INFORM!!! " + e11.getMessage());
            this.log.error("Ending Session");
            e11.printStackTrace();
            this.killSession();
        }
        try {
            this.out.write(message.getBytes());
            this.out.flush();
        }
        catch (IOException e) {
            this.log.error("Problem writing message, finishing session " + e.getMessage());
            this.killSession();
        }
    }

    public Inet4Address getRemotePCEId() {
        return this.remotePCEId;
    }

    public void setRemotePCEId(Inet4Address remotePCEId) {
        this.remotePCEId = remotePCEId;
    }

    public LinkedList<Integer> getRemoteOfCodes() {
        return this.remoteOfCodes;
    }

    public String shortInfo() {
        StringBuffer sb = new StringBuffer(1000);
        if (this.socket != null) {
            sb.append("remAddr: ");
            sb.append(this.socket.getRemoteSocketAddress());
            sb.append(" state: ");
            if (this.FSMstate == 2) {
                sb.append("OPEN_WAIT");
            } else if (this.FSMstate == 0) {
                sb.append("IDLE");
            } else if (this.FSMstate == 3) {
                sb.append("KEEP_WAIT");
            } else if (this.FSMstate == 4) {
                sb.append("SESSION_UP");
            } else if (this.FSMstate == 4) {
                sb.append("TCP_PENDING");
            } else {
                sb.append("UNKNOWN");
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        return sb.toString();
    }

    public void newSessionId() {
        this.sessionId = sessionIdCounter + 1L;
        ++sessionIdCounter;
    }

    private void processNotStateful(PCEPOpen p_open, KeepWaitTimerTask kwtt) {
        if (this.sendErrorStateful) {
            PCEPError perror = new PCEPError();
            PCEPErrorObject perrorObject = new PCEPErrorObject();
            perrorObject.setErrorType(19);
            perrorObject.setErrorValue(555);
            perror.getErrorObjList().add(perrorObject);
            this.sendPCEPMessage(perror);
        } else {
            this.log.debug("Sending KA to confirm");
            PCEPKeepalive p_ka = new PCEPKeepalive();
            this.log.debug("Sending Keepalive message");
            this.sendPCEPMessage(p_ka);
            this.deadTimerPeer = p_open.getDeadTimer();
            this.keepAlivePeer = p_open.getKeepalive();
            this.remoteOK = true;
            if (this.localOK) {
                this.log.info("Entering STATE_SESSION_UP");
                this.setFSMstate(4);
            } else {
                this.log.info("Entering STATE_KEEP_WAIT");
                this.log.debug("Scheduling KeepwaitTimer");
                this.timer.schedule((TimerTask)kwtt, 60000L);
                this.setFSMstate(3);
            }
        }
        this.isSessionStateful = false;
    }

    private boolean checkLSPsync(PCEPOpen p_open) {
        if (!this.pcepSessionManager.isStatefulSFlag() || p_open.getOpen().getStateful_capability_tlv().isSFlag()) {
            // empty if block
        }
        return false;
    }

    private void processNotSRCapable(PCEPOpen p_open, KeepWaitTimerTask kwtt) {
    }
}

