/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.protocol.commons.ByteHandler;

public class SymbolicPathNameTLV
extends PCEPTLV {
    private byte[] SymbolicPathNameID;

    public SymbolicPathNameTLV() {
        this.setTLVType(17);
    }

    public SymbolicPathNameTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        log.debug("Encoding SymbolicPathName TLV");
        this.setTLVValueLength(this.SymbolicPathNameID.length);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        System.arraycopy(this.SymbolicPathNameID, 0, this.tlv_bytes, offset, this.SymbolicPathNameID.length);
    }

    public void decode() throws MalformedPCEPObjectException {
        boolean firstBit;
        log.debug("Decoding SymbolicPathName TLV");
        int offset = 4;
        if (this.getTLVValueLength() == 0) {
            throw new MalformedPCEPObjectException();
        }
        this.SymbolicPathNameID = new byte[this.getTLVValueLength()];
        try {
            System.arraycopy(this.tlv_bytes, offset, this.SymbolicPathNameID, 0, this.getTLVValueLength());
        }
        catch (Exception e) {
            log.error("Exception occurred, Possibly TLV size is not what expected");
            throw new MalformedPCEPObjectException();
        }
        boolean isZero = true;
        for (int i = 0; i < this.SymbolicPathNameID.length; ++i) {
            if (this.SymbolicPathNameID[i] == 0) continue;
            isZero = false;
            break;
        }
        if (isZero) {
            log.error("Received redundancy group identifier value can not be zero");
        }
        boolean bl = firstBit = ByteHandler.easyCopy(0, 0, this.SymbolicPathNameID[0]) == 1;
        if (firstBit) {
            log.error("Received redundancy group identifier value can not be negative");
            throw new MalformedPCEPObjectException();
        }
    }

    public byte[] getSymbolicPathNameID() {
        return this.SymbolicPathNameID;
    }

    public void setSymbolicPathNameID(byte[] symbolicPathNameID) {
        this.SymbolicPathNameID = symbolicPathNameID;
    }

    public String toString() {
        return "SymbolicPathNameTLV [SymbolicPathNameID=" + new String(this.SymbolicPathNameID) + "]";
    }
}

