/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.protocol.commons.ByteHandler;

public class StatefulCapabilityTLV
extends PCEPTLV {
    protected boolean uFlag;
    protected boolean sFlag;
    protected boolean iFlag;
    protected boolean tFlag;
    protected boolean dFlag;

    public StatefulCapabilityTLV() {
        this.TLVType = 16;
    }

    public StatefulCapabilityTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        log.debug("Encoding StatefulCapabilityTLV");
        int length = 4;
        this.setTLVValueLength(length);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int Zero = 0;
        int offset = 4;
        ByteHandler.IntToBuffer(0, offset * 8, 64, Zero, this.tlv_bytes);
        ByteHandler.BoolToBuffer(3 + (offset += 3) * 8, this.dFlag, this.tlv_bytes);
        ByteHandler.BoolToBuffer(4 + offset * 8, this.tFlag, this.tlv_bytes);
        ByteHandler.BoolToBuffer(5 + offset * 8, this.iFlag, this.tlv_bytes);
        ByteHandler.BoolToBuffer(6 + offset * 8, this.sFlag, this.tlv_bytes);
        ByteHandler.BoolToBuffer(7 + offset * 8, this.uFlag, this.tlv_bytes);
    }

    public void decode() {
        log.debug("Decoding StatefulCapabilityTLV");
        int offset = 4;
        this.dFlag = ByteHandler.easyCopy(3, 3, this.tlv_bytes[offset + 3]) == 1;
        this.tFlag = ByteHandler.easyCopy(4, 4, this.tlv_bytes[offset + 3]) == 1;
        this.iFlag = ByteHandler.easyCopy(5, 5, this.tlv_bytes[offset + 3]) == 1;
        this.sFlag = ByteHandler.easyCopy(6, 6, this.tlv_bytes[offset + 3]) == 1;
        this.uFlag = ByteHandler.easyCopy(7, 7, this.tlv_bytes[offset + 3]) == 1;
    }

    public boolean isSFlag() {
        return this.sFlag;
    }

    public boolean isUFlag() {
        return this.uFlag;
    }

    public void setSFlag(boolean sFlag) {
        this.sFlag = sFlag;
    }

    public void setUFlag(boolean uFlag) {
        this.uFlag = uFlag;
    }

    public boolean isIFlag() {
        return this.iFlag;
    }

    public void setIFlag(boolean iFlag) {
        this.iFlag = iFlag;
    }

    public boolean isTFlag() {
        return this.tFlag;
    }

    public void setTFlag(boolean tFlag) {
        this.tFlag = tFlag;
    }

    public boolean isDFlag() {
        return this.dFlag;
    }

    public void setDFlag(boolean dFlag) {
        this.dFlag = dFlag;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dFlag ? 1231 : 1237);
        result = 31 * result + (this.iFlag ? 1231 : 1237);
        result = 31 * result + (this.sFlag ? 1231 : 1237);
        result = 31 * result + (this.tFlag ? 1231 : 1237);
        result = 31 * result + (this.uFlag ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatefulCapabilityTLV other = (StatefulCapabilityTLV)obj;
        if (this.dFlag != other.dFlag) {
            return false;
        }
        if (this.iFlag != other.iFlag) {
            return false;
        }
        if (this.sFlag != other.sFlag) {
            return false;
        }
        if (this.tFlag != other.tFlag) {
            return false;
        }
        return this.uFlag == other.uFlag;
    }
}

