/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.protocol.commons.ByteHandler;

public class SpeakerEntityIdentifierTLV
extends PCEPTLV {
    private byte[] speakerEntityIdentifier;

    public SpeakerEntityIdentifierTLV() {
        this.setTLVType(24);
    }

    public SpeakerEntityIdentifierTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        log.debug("Encoding Speaker Entity Identifier TLV");
        this.setTLVValueLength(this.speakerEntityIdentifier.length);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        log.debug("TOTA  " + this.getTotalTLVLength() + " SW " + this.speakerEntityIdentifier.length);
        this.encodeHeader();
        int offset = 4;
        System.arraycopy(this.speakerEntityIdentifier, 0, this.tlv_bytes, offset, this.speakerEntityIdentifier.length);
    }

    public void decode() throws MalformedPCEPObjectException {
        boolean firstBit;
        log.debug("Decoding Speaker Entity Identifier TLV");
        int offset = 4;
        if (this.getTLVValueLength() == 0) {
            throw new MalformedPCEPObjectException();
        }
        this.speakerEntityIdentifier = new byte[this.getTLVValueLength()];
        try {
            System.arraycopy(this.tlv_bytes, offset, this.speakerEntityIdentifier, 0, this.getTLVValueLength());
        }
        catch (Exception e) {
            log.error("Exception occurred, Possibly TLV size is not what expected");
            throw new MalformedPCEPObjectException();
        }
        boolean isZero = true;
        for (int i = 0; i < this.speakerEntityIdentifier.length; ++i) {
            if (this.speakerEntityIdentifier[i] == 0) continue;
            isZero = false;
            break;
        }
        if (isZero) {
            log.error("Received Speaker Entity Identifier  value can not be zero");
        }
        boolean bl = firstBit = ByteHandler.easyCopy(0, 0, this.speakerEntityIdentifier[0]) == 1;
        if (firstBit) {
            log.error("Received redundancy group identifier value can not be negative");
            throw new MalformedPCEPObjectException();
        }
    }

    public byte[] getSpeakerEntityIdentifier() {
        return this.speakerEntityIdentifier;
    }

    public void setSpeakerEntityIdentifier(byte[] speakerEntityIdentifier) {
        this.speakerEntityIdentifier = speakerEntityIdentifier;
    }

    public String toString() {
        String speakerEntityIdentifierBytes = "Speaker Entity Id: " + ByteHandler.ByteMACToString(this.speakerEntityIdentifier);
        return speakerEntityIdentifierBytes;
    }
}

