/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.protocol.commons.ByteHandler;

public class SRCapabilityTLV
extends PCEPTLV {
    protected int MSD;

    public SRCapabilityTLV() {
        this.TLVType = 26;
    }

    public SRCapabilityTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int length = 4;
        this.setTLVValueLength(length);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int Zero = 0;
        int offset = 4;
        log.debug("Encoding SRCapabilityTLV: MSD =" + this.MSD + " bytes: " + this.getTotalTLVLength());
        ByteHandler.IntToBuffer(0, offset * 8, 32, Zero, this.tlv_bytes);
        byte[] aux = new byte[]{(byte)(this.MSD & 0xFF)};
        System.arraycopy(aux, 0, this.tlv_bytes, 7, 1);
        log.debug("finished Encoding SRCapabilityTLV: MSD =" + this.MSD);
    }

    public void decode() {
        log.debug("Decoding SRCapabilityTLV");
        int offset = 7;
        byte[] aux = new byte[1];
        System.arraycopy(this.tlv_bytes, offset, aux, 0, 1);
        this.MSD = aux[0] & 0xFF;
        log.debug("MSD decoded, value: " + this.MSD);
    }

    public int getMSD() {
        return this.MSD;
    }

    public void setMSD(int MSD) {
        this.MSD = MSD;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.MSD;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SRCapabilityTLV other = (SRCapabilityTLV)obj;
        return this.MSD == other.MSD;
    }
}

