/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.protocol.commons.ByteHandler;
import java.util.Objects;

public class PathProtectionAssociationTLV
extends PCEPTLV {
    private long data;

    public PathProtectionAssociationTLV() {
        this.setTLVType(38);
    }

    public PathProtectionAssociationTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    public long getData() {
        return this.data;
    }

    public void setData(long data) {
        this.data = data;
    }

    @Override
    public void encode() {
        log.debug("Encoding PathProtectionAssociation TLV");
        this.setTLVValueLength(4);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        ByteHandler.encode4bytesLong(this.data, this.tlv_bytes, offset);
    }

    public void decode() throws MalformedPCEPObjectException {
        log.debug("Decoding SymbolicPathName TLV");
        int offset = 4;
        try {
            this.data = ByteHandler.decode4bytesLong(this.tlv_bytes, offset);
        }
        catch (Exception e) {
            log.error("Exception occurred, Possibly TLV size is not what expected");
            throw new MalformedPCEPObjectException();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.data);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathProtectionAssociationTLV other = (PathProtectionAssociationTLV)obj;
        return this.data == other.data;
    }

    public String toString() {
        return "PathProtectionAssociationTLV [data=" + this.data + "]";
    }
}

