/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.protocol.commons.ByteHandler;
import java.util.Arrays;

public class PCE_Redundancy_Group_Identifier_TLV
extends PCEPTLV {
    private byte[] redundancyId;

    public PCE_Redundancy_Group_Identifier_TLV() {
        this.TLVType = 5557;
    }

    public PCE_Redundancy_Group_Identifier_TLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        log.debug("Encoding PCE_Redundancy_Group_Identifier_TLV TLV");
        int length = this.redundancyId.length;
        this.setTLVValueLength(length);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        log.debug("Redundancy ID length is: " + this.redundancyId.length);
        System.arraycopy(this.redundancyId, 0, this.tlv_bytes, offset, this.redundancyId.length);
    }

    public void decode() throws MalformedPCEPObjectException {
        boolean firstBit;
        log.debug("Decoding PCE_Redundancy_Group_Identifier_TLV TLV");
        this.redundancyId = new byte[this.getTLVValueLength()];
        int offset = 4;
        try {
            System.arraycopy(this.tlv_bytes, offset, this.redundancyId, 0, this.redundancyId.length);
            log.debug("Redundancy ID is : " + ByteHandler.ByteMACToString(this.redundancyId));
        }
        catch (Exception e) {
            log.error("Exception occurred, Possibly TLV size is not what expected");
            throw new MalformedPCEPObjectException();
        }
        boolean isZero = true;
        for (int i = 0; i < this.redundancyId.length; ++i) {
            if (this.redundancyId[i] == 0) continue;
            isZero = false;
            break;
        }
        if (isZero) {
            log.debug("Received redundancy group identifier value can not be zero");
        }
        boolean bl = firstBit = ByteHandler.easyCopy(0, 0, this.redundancyId[0]) == 1;
        if (firstBit) {
            log.debug("Received redundancy group identifier value can not be negative");
            throw new MalformedPCEPObjectException();
        }
    }

    public byte[] getRedundancyId() {
        return this.redundancyId;
    }

    public void setRedundancyId(byte[] redundancyId) {
        this.redundancyId = redundancyId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.redundancyId);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCE_Redundancy_Group_Identifier_TLV other = (PCE_Redundancy_Group_Identifier_TLV)obj;
        return Arrays.equals(this.redundancyId, other.redundancyId);
    }
}

