/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;

public class MaxRequestTimeTLV
extends PCEPTLV {
    private long maxRequestTime;

    public MaxRequestTimeTLV() {
        this.setTLVType(3000);
    }

    public MaxRequestTimeTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    public void decode() {
        this.maxRequestTime = 0L;
        for (int k = 0; k < 4; ++k) {
            this.maxRequestTime = this.maxRequestTime << 8 | (long)(this.tlv_bytes[k + 4] & 0xFF);
        }
    }

    @Override
    public void encode() {
        log.debug("codificando Max Request Time TLV");
        this.setTLVValueLength(4);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        this.tlv_bytes[4] = (byte)(this.maxRequestTime >>> 24);
        this.tlv_bytes[5] = (byte)(this.maxRequestTime >>> 16);
        this.tlv_bytes[6] = (byte)(this.maxRequestTime >>> 8);
        this.tlv_bytes[7] = (byte)this.maxRequestTime;
    }

    public long getMaxRequestTime() {
        return this.maxRequestTime;
    }

    public void setMaxRequestTime(long maxRequestTime) {
        this.maxRequestTime = maxRequestTime;
    }
}

