/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.protocol.commons.ByteHandler;

public class LabelRequestTLV
extends PCEPTLV {
    private int lspEncodingType;
    private int switchingType;
    private int gpid;

    public LabelRequestTLV() {
        this.setTLVType(42);
    }

    public LabelRequestTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(4);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int currentIndex = 4;
        this.tlv_bytes[currentIndex] = (byte)(this.lspEncodingType & 0xFF);
        this.tlv_bytes[currentIndex + 1] = (byte)(this.switchingType & 0xFF);
        this.tlv_bytes[currentIndex + 2] = (byte)(this.gpid >> 8 & 0xFF);
        this.tlv_bytes[currentIndex + 3] = (byte)(this.gpid & 0xFF);
    }

    public void decode() {
        int offset = 4;
        this.lspEncodingType = ByteHandler.decode1byteInteger(this.tlv_bytes, offset);
        this.switchingType = ByteHandler.decode1byteInteger(this.tlv_bytes, offset + 1);
        this.gpid = ByteHandler.decode2bytesInteger(this.tlv_bytes, offset + 2);
    }

    public int getLspEncodingType() {
        return this.lspEncodingType;
    }

    public void setLspEncodingType(int lspEncodingType) {
        this.lspEncodingType = lspEncodingType;
    }

    public int getSwitchingType() {
        return this.switchingType;
    }

    public void setSwitchingType(int switchingType) {
        this.switchingType = switchingType;
    }

    public int getGpid() {
        return this.gpid;
    }

    public void setGpid(int gpid) {
        this.gpid = gpid;
    }

    public String toString() {
        return "LabelRequestTLV [lspEncodingType=" + this.lspEncodingType + ", switchingType=" + this.switchingType + ", gpid=" + this.gpid + "]";
    }
}

