/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.protocol.commons.ByteHandler;

public class LSPDatabaseVersionTLV
extends PCEPTLV {
    private long LSPStateDBVersion;

    public LSPDatabaseVersionTLV() {
        this.TLVType = 23;
    }

    public LSPDatabaseVersionTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        log.debug("Encoding LSPDatabaseVersionTLV TLV");
        int length = 8;
        this.setTLVValueLength(length);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        ByteHandler.LongToBuffer(0, offset * 8, 64, this.LSPStateDBVersion, this.tlv_bytes);
    }

    public void decode() throws MalformedPCEPObjectException {
        log.debug("Decoding LSPDatabaseVersionTLV TLV");
        int offset = 4;
        this.LSPStateDBVersion = ByteHandler.easyCopyL(0, 63, this.tlv_bytes[offset + 0], this.tlv_bytes[offset + 1], this.tlv_bytes[offset + 2], this.tlv_bytes[offset + 3], this.tlv_bytes[offset + 4], this.tlv_bytes[offset + 5], this.tlv_bytes[offset + 6], this.tlv_bytes[offset + 7]);
        log.debug("Databse Version TLV ID: " + this.LSPStateDBVersion);
    }

    public long getLSPStateDBVersion() {
        return this.LSPStateDBVersion;
    }

    public void setLSPStateDBVersion(long lSPStateDBVersion) {
        this.LSPStateDBVersion = lSPStateDBVersion;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.LSPStateDBVersion ^ this.LSPStateDBVersion >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LSPDatabaseVersionTLV other = (LSPDatabaseVersionTLV)obj;
        return this.LSPStateDBVersion == other.LSPStateDBVersion;
    }
}

