/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.subobjects;

import es.tid.pce.pcep.objects.subobjects.XROSubobject;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class IPv4PrefixXROSubobject
extends XROSubobject {
    public Inet4Address ipv4address;
    public int prefix;

    public IPv4PrefixXROSubobject() {
        this.setType(1);
    }

    public IPv4PrefixXROSubobject(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.erosolength = 8;
        this.subobject_bytes = new byte[this.erosolength];
        this.encodeSoHeader();
        System.arraycopy(this.ipv4address.getAddress(), 0, this.subobject_bytes, 2, 4);
        this.subobject_bytes[6] = (byte)this.prefix;
        this.subobject_bytes[7] = (byte)this.attribute;
    }

    @Override
    public void decode() {
        byte[] ipadd = new byte[4];
        System.arraycopy(this.subobject_bytes, 2, ipadd, 0, 4);
        try {
            this.ipv4address = (Inet4Address)Inet4Address.getByAddress(ipadd);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.prefix = this.subobject_bytes[6] & 0xFF;
        this.attribute = this.subobject_bytes[7] & 0xFF;
    }

    public Inet4Address getIpv4address() {
        return this.ipv4address;
    }

    public void setIpv4address(Inet4Address ipv4address) {
        this.ipv4address = ipv4address;
    }

    public int getPrefix() {
        return this.prefix;
    }

    public void setPrefix(int prefix) {
        this.prefix = prefix;
    }

    public String toString() {
        String resp = this.ipv4address + "/" + this.prefix;
        return resp;
    }
}

