/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.tlvs.MaxRequestTimeTLV;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.pce.pcep.objects.tlvs.PathSetupTLV;

public class RequestParameters
extends PCEPObject {
    private int prio;
    private boolean reopt;
    private boolean bidirect;
    private boolean loose;
    private boolean supplyOF;
    public long requestID;
    private boolean retry;
    MaxRequestTimeTLV maxRequestTimeTLV;
    private PathSetupTLV pathSetupTLV;
    private boolean Fbit = false;
    private boolean Nbit = false;
    private boolean Ebit = false;

    public RequestParameters() {
        this.setObjectClass(2);
        this.setOT(1);
        this.prio = 0;
        this.reopt = false;
        this.bidirect = false;
        this.loose = false;
        this.retry = false;
    }

    public RequestParameters(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 12;
        if (this.maxRequestTimeTLV != null) {
            try {
                this.maxRequestTimeTLV.encode();
                this.ObjectLength += this.maxRequestTimeTLV.getTotalTLVLength();
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        if (this.pathSetupTLV != null) {
            try {
                this.pathSetupTLV.encode();
                this.ObjectLength += this.pathSetupTLV.getTotalTLVLength();
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        this.object_bytes[4] = (byte)((this.retry ? 1 : 0) << 7);
        this.object_bytes[5] = 0;
        this.object_bytes[6] = (byte)((this.Fbit ? 1 : 0) << 5 & 0x20 | (this.Nbit ? 1 : 0) << 4 & 0x10 | (this.Ebit ? 1 : 0) << 3 & 8);
        this.object_bytes[7] = (byte)((this.loose ? 1 : 0) << 5 & 0x20 | (this.bidirect ? 1 : 0) << 4 & 0x10 | (this.reopt ? 1 : 0) << 3 & 8 | this.prio & 7 | (this.supplyOF ? 1 : 0) << 6);
        this.object_bytes[8] = (byte)(this.requestID >> 24 & 0xFFL);
        this.object_bytes[9] = (byte)(this.requestID >> 16 & 0xFFL);
        this.object_bytes[10] = (byte)(this.requestID >> 8 & 0xFFL);
        this.object_bytes[11] = (byte)(this.requestID & 0xFFL);
        int offset = 12;
        if (this.maxRequestTimeTLV != null) {
            System.arraycopy(this.maxRequestTimeTLV.getTlv_bytes(), 0, this.object_bytes, offset, this.maxRequestTimeTLV.getTotalTLVLength());
            offset += this.maxRequestTimeTLV.getTotalTLVLength();
        }
        if (this.pathSetupTLV != null) {
            System.arraycopy(this.pathSetupTLV.getTlv_bytes(), 0, this.object_bytes, offset, this.pathSetupTLV.getTotalTLVLength());
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        this.retry = (this.object_bytes[4] & 0x80) == 128;
        this.loose = (this.object_bytes[7] & 0x20) == 32;
        this.bidirect = (this.object_bytes[7] & 0x10) == 16;
        this.reopt = (this.object_bytes[7] & 8) == 8;
        this.prio = this.object_bytes[7] & 7;
        this.supplyOF = (this.object_bytes[7] & 0x40) == 64;
        this.requestID = ((long)this.object_bytes[8] & 0xFFL) << 24 | ((long)this.object_bytes[9] & 0xFFL) << 16 | ((long)this.object_bytes[10] & 0xFFL) << 8 | (long)this.object_bytes[11] & 0xFFL;
        this.Fbit = (this.object_bytes[6] & 0x20) == 32;
        this.Nbit = (this.object_bytes[6] & 0x10) == 16;
        this.Ebit = (this.object_bytes[6] & 8) == 8;
        boolean endObject = false;
        if (this.ObjectLength < 12) {
            throw new MalformedPCEPObjectException();
        }
        if (this.ObjectLength == 12) {
            endObject = true;
        }
        int offset = 12;
        while (!endObject) {
            int tlvtype = PCEPTLV.getType(this.getObject_bytes(), offset);
            int tlvlength = PCEPTLV.getTotalTLVLength(this.getObject_bytes(), offset);
            switch (tlvtype) {
                case 3000: {
                    this.maxRequestTimeTLV = new MaxRequestTimeTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 28: {
                    this.pathSetupTLV = new PathSetupTLV(this.getObject_bytes(), offset);
                    break;
                }
            }
            if ((offset += tlvlength) < this.ObjectLength) continue;
            endObject = true;
        }
    }

    public boolean isReopt() {
        return this.reopt;
    }

    public void setReopt(boolean reopt) {
        this.reopt = reopt;
    }

    public boolean isBidirect() {
        return this.bidirect;
    }

    public void setBidirect(boolean bidirect) {
        this.bidirect = bidirect;
    }

    public boolean isLoose() {
        return this.loose;
    }

    public void setLoose(boolean loose) {
        this.loose = loose;
    }

    public void setRequestID(long requestID) {
        this.requestID = requestID;
    }

    public int getPrio() {
        return this.prio;
    }

    public void setPrio(int prio) {
        this.prio = prio;
    }

    public long getRequestID() {
        return this.requestID;
    }

    public boolean isFbit() {
        return this.Fbit;
    }

    public void setFbit(boolean fbit) {
        this.Fbit = fbit;
    }

    public boolean isNbit() {
        return this.Nbit;
    }

    public void setNbit(boolean nbit) {
        this.Nbit = nbit;
    }

    public boolean isEbit() {
        return this.Ebit;
    }

    public void setEbit(boolean ebit) {
        this.Ebit = ebit;
    }

    public boolean isSupplyOF() {
        return this.supplyOF;
    }

    public void setSupplyOF(boolean supplyOF) {
        this.supplyOF = supplyOF;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    public MaxRequestTimeTLV getMaxRequestTimeTLV() {
        return this.maxRequestTimeTLV;
    }

    public PathSetupTLV getPathSetupTLV() {
        return this.pathSetupTLV;
    }

    public void setPathSetupTLV(PathSetupTLV pathSetupTLV) {
        this.pathSetupTLV = pathSetupTLV;
    }

    public void setMaxRequestTimeTLV(MaxRequestTimeTLV maxRequestTimeTLV) {
        this.maxRequestTimeTLV = maxRequestTimeTLV;
    }

    public String toString() {
        String str = "<RP ReqID: " + this.requestID + " Prio: " + this.prio + " Reopt: " + (this.reopt ? 1 : 0) + " Bid: " + (this.bidirect ? 1 : 0) + " Loose: " + (this.loose ? 1 : 0) + " SupOF: " + this.supplyOF + " retry " + this.retry;
        if (this.pathSetupTLV != null) {
            str = str + "<PathSetupTLV " + this.pathSetupTLV.toString() + ">";
        }
        str = str + ">";
        return str;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.Ebit ? 1231 : 1237);
        result = 31 * result + (this.Fbit ? 1231 : 1237);
        result = 31 * result + (this.Nbit ? 1231 : 1237);
        result = 31 * result + (this.bidirect ? 1231 : 1237);
        result = 31 * result + (this.loose ? 1231 : 1237);
        result = 31 * result + (this.maxRequestTimeTLV == null ? 0 : this.maxRequestTimeTLV.hashCode());
        result = 31 * result + (this.pathSetupTLV == null ? 0 : this.pathSetupTLV.hashCode());
        result = 31 * result + this.prio;
        result = 31 * result + (this.reopt ? 1231 : 1237);
        result = 31 * result + (int)(this.requestID ^ this.requestID >>> 32);
        result = 31 * result + (this.retry ? 1231 : 1237);
        result = 31 * result + (this.supplyOF ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestParameters other = (RequestParameters)obj;
        if (this.Ebit != other.Ebit) {
            return false;
        }
        if (this.Fbit != other.Fbit) {
            return false;
        }
        if (this.Nbit != other.Nbit) {
            return false;
        }
        if (this.bidirect != other.bidirect) {
            return false;
        }
        if (this.loose != other.loose) {
            return false;
        }
        if (this.maxRequestTimeTLV == null ? other.maxRequestTimeTLV != null : !this.maxRequestTimeTLV.equals(other.maxRequestTimeTLV)) {
            return false;
        }
        if (this.pathSetupTLV == null ? other.pathSetupTLV != null : !this.pathSetupTLV.equals(other.pathSetupTLV)) {
            return false;
        }
        if (this.prio != other.prio) {
            return false;
        }
        if (this.reopt != other.reopt) {
            return false;
        }
        if (this.requestID != other.requestID) {
            return false;
        }
        if (this.retry != other.retry) {
            return false;
        }
        return this.supplyOF == other.supplyOF;
    }
}

