/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PceId;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class PceIdIPv4
extends PceId {
    private Inet4Address pceIPAddress;

    public PceIdIPv4() {
        this.setObjectClass(25);
        this.setOT(1);
    }

    public PceIdIPv4(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 8;
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        System.arraycopy(this.pceIPAddress.getAddress(), 0, this.object_bytes, 4, 4);
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        if (this.ObjectLength != 8) {
            throw new MalformedPCEPObjectException();
        }
        byte[] ip = new byte[4];
        System.arraycopy(this.object_bytes, 4, ip, 0, 4);
        try {
            this.pceIPAddress = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public Inet4Address getPceIPAddress() {
        return this.pceIPAddress;
    }

    public void setPceIPAddress(Inet4Address pceIPAddress) {
        this.pceIPAddress = pceIPAddress;
    }

    public String toString() {
        String ret = "<PCE_ID ";
        ret = this.pceIPAddress != null ? ret + this.pceIPAddress + " >" : ret + ">";
        return ret;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.pceIPAddress == null ? 0 : this.pceIPAddress.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PceIdIPv4 other = (PceIdIPv4)obj;
        return !(this.pceIPAddress == null ? other.pceIPAddress != null : !this.pceIPAddress.equals(other.pceIPAddress));
    }
}

