/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class PccReqId
extends PCEPObject {
    private Inet4Address PCCIpAddress;

    public PccReqId() {
        this.setObjectClass(20);
        this.setOT(1);
    }

    public PccReqId(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 8;
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        System.arraycopy(this.PCCIpAddress.getAddress(), 0, this.object_bytes, 4, 4);
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        if (this.ObjectLength != 8) {
            throw new MalformedPCEPObjectException();
        }
        byte[] ip = new byte[4];
        System.arraycopy(this.object_bytes, 4, ip, 0, 4);
        try {
            this.PCCIpAddress = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public void setPCCIpAddress(Inet4Address address) {
        this.PCCIpAddress = address;
    }

    public String toString() {
        return "PCC IP: " + this.PCCIpAddress;
    }

    public Inet4Address getPCCIpAddress() {
        return this.PCCIpAddress;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.PCCIpAddress == null ? 0 : this.PCCIpAddress.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PccReqId other = (PccReqId)obj;
        return !(this.PCCIpAddress == null ? other.PCCIpAddress != null : !this.PCCIpAddress.equals(other.PCCIpAddress));
    }
}

