/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.pce.pcep.objects.tlvs.ReqMissingTLV;

public class PCEPErrorObject
extends PCEPObject {
    private int errorType;
    private int errorValue;
    private ReqMissingTLV reqMissing;

    public PCEPErrorObject() {
        this.setObjectClass(13);
        this.setOT(1);
    }

    public PCEPErrorObject(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int len = 8;
        if (this.reqMissing != null) {
            this.reqMissing.encode();
            len += this.reqMissing.getTotalTLVLength();
        }
        this.ObjectLength = len;
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        this.object_bytes[4] = 0;
        this.object_bytes[5] = 0;
        this.object_bytes[6] = (byte)this.errorType;
        this.object_bytes[7] = (byte)this.errorValue;
        int pos = 8;
        if (this.reqMissing != null) {
            System.arraycopy(this.reqMissing.getTlv_bytes(), 0, this.object_bytes, pos, this.reqMissing.getTotalTLVLength());
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        if (this.ObjectLength < 8) {
            throw new MalformedPCEPObjectException();
        }
        this.errorType = this.object_bytes[6];
        this.errorValue = this.object_bytes[7];
        if (this.ObjectLength > 8) {
            boolean fin = false;
            int offset = 8;
            while (!fin) {
                int tlvtype = PCEPTLV.getType(this.getObject_bytes(), offset);
                int tlvlength = PCEPTLV.getTotalTLVLength(this.getObject_bytes(), offset);
                if (tlvtype == 3) {
                    this.reqMissing = new ReqMissingTLV(this.getObject_bytes(), offset);
                }
                if ((offset += tlvlength) < this.ObjectLength) continue;
                fin = true;
            }
        }
    }

    public int getErrorType() {
        return this.errorType;
    }

    public void setErrorType(int errorType) {
        this.errorType = errorType;
    }

    public int getErrorValue() {
        return this.errorValue;
    }

    public void setErrorValue(int errorValue) {
        this.errorValue = errorValue;
    }

    public ReqMissingTLV getReqMissing() {
        return this.reqMissing;
    }

    public void setReqMissing(ReqMissingTLV reqMissing) {
        this.reqMissing = reqMissing;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.errorType;
        result = 31 * result + this.errorValue;
        result = 31 * result + (this.reqMissing == null ? 0 : this.reqMissing.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCEPErrorObject other = (PCEPErrorObject)obj;
        if (this.errorType != other.errorType) {
            return false;
        }
        if (this.errorValue != other.errorValue) {
            return false;
        }
        return !(this.reqMissing == null ? other.reqMissing != null : !this.reqMissing.equals(other.reqMissing));
    }
}

