/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.tlvs.OF_LIST_TLV;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;

public class ObjectiveFunction
extends PCEPObject {
    private int OFcode;
    private OF_LIST_TLV oflist;

    public ObjectiveFunction() {
        this.setObjectClass(21);
        this.setOT(1);
    }

    public ObjectiveFunction(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 8;
        if (this.oflist != null) {
            this.oflist.encode();
            this.ObjectLength += this.oflist.getTotalTLVLength();
        }
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        this.object_bytes[4] = (byte)(this.OFcode >> 8 & 0xFF);
        this.object_bytes[5] = (byte)(this.OFcode & 0xFF);
        this.object_bytes[6] = 0;
        this.object_bytes[7] = 0;
        int offset = 8;
        if (this.oflist != null) {
            System.arraycopy(this.oflist.getTlv_bytes(), 0, this.object_bytes, offset, this.oflist.getTotalTLVLength());
            offset += this.oflist.getTotalTLVLength();
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        if (this.ObjectLength < 8) {
            throw new MalformedPCEPObjectException();
        }
        this.OFcode = (this.object_bytes[4] & 0xFF) << 8 & 0xFF00 | this.object_bytes[5] & 0xFF;
        boolean fin = false;
        if (this.ObjectLength == 8) {
            fin = true;
        }
        int offset = 8;
        while (!fin) {
            int tlvtype = PCEPTLV.getType(this.getObject_bytes(), offset);
            int tlvlength = PCEPTLV.getTotalTLVLength(this.getObject_bytes(), offset);
            switch (tlvtype) {
                case 4: {
                    this.oflist = new OF_LIST_TLV(this.getObject_bytes(), offset);
                    log.debug(this.oflist.toString());
                    break;
                }
                default: {
                    log.warn("UNKNOWN TLV found: " + tlvtype);
                }
            }
            if ((offset += tlvlength) < this.ObjectLength) continue;
            fin = true;
        }
    }

    public void setOFcode(int oFcode) {
        this.OFcode = oFcode;
    }

    public int getOFcode() {
        return this.OFcode;
    }

    public OF_LIST_TLV getOflist() {
        return this.oflist;
    }

    public void setOflist(OF_LIST_TLV oflist) {
        this.oflist = oflist;
    }

    public String toString() {
        String ret = "<OF code= " + this.OFcode;
        if (this.getOflist() != null) {
            ret = ret + ret.toString();
        }
        ret = ret + ">";
        return ret;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.OFcode;
        result = 31 * result + (this.oflist == null ? 0 : this.oflist.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectiveFunction other = (ObjectiveFunction)obj;
        if (this.OFcode != other.OFcode) {
            return false;
        }
        return !(this.oflist == null ? other.oflist != null : !this.oflist.equals(other.oflist));
    }
}

