/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.tlvs.OSPFTE_LSA_TLV;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.pce.pcep.objects.tlvs.PathReservationTLV;
import es.tid.pce.pcep.objects.tlvs.ReachabilityTLV;
import es.tid.pce.pcep.objects.tlvs.ReservationIDTLV;
import java.util.LinkedList;

public class Notification
extends PCEPObject {
    private int notificationType;
    private int notificationValue;
    private LinkedList<ReachabilityTLV> reachabilityTLVList;
    private LinkedList<OSPFTE_LSA_TLV> LSATLVList;
    private ReservationIDTLV reservationIDTLV;
    private PathReservationTLV notificationTLV;

    public Notification() {
        this.setObjectClass(12);
        this.setOT(1);
        this.reachabilityTLVList = new LinkedList();
        this.LSATLVList = new LinkedList();
    }

    public Notification(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.reachabilityTLVList = new LinkedList();
        this.LSATLVList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        int i;
        int i2;
        int len = 8;
        if (this.reachabilityTLVList != null) {
            for (i2 = 0; i2 < this.reachabilityTLVList.size(); ++i2) {
                this.reachabilityTLVList.get(i2).encode();
                len += this.reachabilityTLVList.get(i2).getTotalTLVLength();
            }
        }
        if (this.LSATLVList != null) {
            for (i2 = 0; i2 < this.LSATLVList.size(); ++i2) {
                this.LSATLVList.get(i2).encode();
                len += this.LSATLVList.get(i2).getTotalTLVLength();
            }
        }
        if (this.reservationIDTLV != null) {
            this.reservationIDTLV.encode();
            len += this.reservationIDTLV.getTotalTLVLength();
        }
        if (this.notificationTLV != null) {
            this.notificationTLV.encode();
            len += this.notificationTLV.getTotalTLVLength();
        }
        this.ObjectLength = len;
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        this.object_bytes[4] = 0;
        this.object_bytes[5] = 0;
        this.object_bytes[6] = (byte)this.notificationType;
        this.object_bytes[7] = (byte)this.notificationValue;
        int offset = 8;
        if (this.reachabilityTLVList != null) {
            for (i = 0; i < this.reachabilityTLVList.size(); ++i) {
                System.arraycopy(this.reachabilityTLVList.get(i).getTlv_bytes(), 0, this.object_bytes, offset, this.reachabilityTLVList.get(i).getTotalTLVLength());
                offset += this.reachabilityTLVList.get(i).getTotalTLVLength();
            }
        }
        if (this.LSATLVList != null) {
            for (i = 0; i < this.LSATLVList.size(); ++i) {
                System.arraycopy(this.LSATLVList.get(i).getTlv_bytes(), 0, this.object_bytes, offset, this.LSATLVList.get(i).getTotalTLVLength());
                offset += this.LSATLVList.get(i).getTotalTLVLength();
            }
        }
        if (this.reservationIDTLV != null) {
            System.arraycopy(this.reservationIDTLV.getTlv_bytes(), 0, this.object_bytes, offset, this.reservationIDTLV.getTotalTLVLength());
            offset += this.reservationIDTLV.getTotalTLVLength();
        }
        if (this.notificationTLV != null) {
            System.arraycopy(this.notificationTLV.getTlv_bytes(), 0, this.object_bytes, offset, this.notificationTLV.getTotalTLVLength());
            offset += this.notificationTLV.getTotalTLVLength();
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        this.notificationType = this.object_bytes[6] & 0xFF;
        this.notificationValue = this.object_bytes[7] & 0xFF;
        boolean fin = false;
        int offset = 8;
        if (this.ObjectLength == 8) {
            fin = true;
        }
        while (!fin) {
            int tlvtype = PCEPTLV.getType(this.getObject_bytes(), offset);
            int tlvlength = PCEPTLV.getTotalTLVLength(this.getObject_bytes(), offset);
            switch (tlvtype) {
                case 32777: {
                    if (this.reachabilityTLVList == null) {
                        this.reachabilityTLVList = new LinkedList();
                    }
                    ReachabilityTLV rtlv = new ReachabilityTLV(this.getObject_bytes(), offset);
                    this.reachabilityTLVList.add(rtlv);
                    break;
                }
                case 32779: {
                    if (this.LSATLVList == null) {
                        this.LSATLVList = new LinkedList();
                    }
                    OSPFTE_LSA_TLV lsa_tlv = new OSPFTE_LSA_TLV(this.getObject_bytes(), offset);
                    this.LSATLVList.add(lsa_tlv);
                    break;
                }
                case 14: {
                    break;
                }
                case 32769: {
                    break;
                }
                case 20000: {
                    this.reservationIDTLV = new ReservationIDTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 30003: {
                    this.notificationTLV = new PathReservationTLV(this.getObject_bytes(), offset);
                    break;
                }
                default: {
                    log.warn("Unknown or unexpected TLV found");
                }
            }
            if ((offset += tlvlength) < this.ObjectLength) continue;
            fin = true;
        }
    }

    public int getNotificationType() {
        return this.notificationType;
    }

    public void setNotificationType(int notificationType) {
        this.notificationType = notificationType;
    }

    public int getNotificationValue() {
        return this.notificationValue;
    }

    public void setNotificationValue(int notificationValue) {
        this.notificationValue = notificationValue;
    }

    public LinkedList<ReachabilityTLV> getReachabilityTLVList() {
        return this.reachabilityTLVList;
    }

    public void setReachabilityTLVList(LinkedList<ReachabilityTLV> reachabilityTLVList) {
        this.reachabilityTLVList = reachabilityTLVList;
    }

    public LinkedList<OSPFTE_LSA_TLV> getLSATLVList() {
        return this.LSATLVList;
    }

    public void setLSATLVList(LinkedList<OSPFTE_LSA_TLV> lSATLVList) {
        this.LSATLVList = lSATLVList;
    }

    public void addOSPFTE_LSA_TLV(OSPFTE_LSA_TLV ospfte_lsa_tlv) {
        if (this.LSATLVList == null) {
            this.LSATLVList = new LinkedList();
        }
        this.LSATLVList.add(ospfte_lsa_tlv);
    }

    public void addReachabilityTLV(ReachabilityTLV reachabilityTLV) {
        if (this.reachabilityTLVList == null) {
            this.reachabilityTLVList = new LinkedList();
        }
        this.reachabilityTLVList.add(reachabilityTLV);
    }

    public ReservationIDTLV getReservationIDTLV() {
        return this.reservationIDTLV;
    }

    public void setReservationIDTLV(ReservationIDTLV reservationIDTLV) {
        this.reservationIDTLV = reservationIDTLV;
    }

    public PathReservationTLV getNotificationTLV() {
        return this.notificationTLV;
    }

    public void setNotificationTLV(PathReservationTLV notificationTLV) {
        this.notificationTLV = notificationTLV;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.notificationTLV == null ? 0 : this.notificationTLV.hashCode());
        result = 31 * result + this.notificationType;
        result = 31 * result + this.notificationValue;
        result = 31 * result + (this.reachabilityTLVList == null ? 0 : this.reachabilityTLVList.hashCode());
        result = 31 * result + (this.reservationIDTLV == null ? 0 : this.reservationIDTLV.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Notification other = (Notification)obj;
        if (this.LSATLVList == null ? other.LSATLVList != null : !this.LSATLVList.equals(other.LSATLVList)) {
            return false;
        }
        if (this.notificationTLV == null ? other.notificationTLV != null : !this.notificationTLV.equals(other.notificationTLV)) {
            return false;
        }
        if (this.notificationType != other.notificationType) {
            return false;
        }
        if (this.notificationValue != other.notificationValue) {
            return false;
        }
        if (this.reachabilityTLVList == null ? other.reachabilityTLVList != null : !this.reachabilityTLVList.equals(other.reachabilityTLVList)) {
            return false;
        }
        return !(this.reservationIDTLV == null ? other.reservationIDTLV != null : !this.reservationIDTLV.equals(other.reservationIDTLV));
    }
}

