/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;

public class NoPath
extends PCEPObject {
    private int natureOfIssue;
    private boolean cFlag;
    private NoPathTLV noPathTLV;

    public NoPath() {
        this.setObjectClass(3);
        this.setOT(1);
    }

    public NoPath(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 8;
        if (this.noPathTLV != null) {
            this.noPathTLV.encode();
            this.ObjectLength += this.noPathTLV.getTotalTLVLength();
        }
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        this.object_bytes[4] = (byte)this.natureOfIssue;
        this.object_bytes[5] = (byte)((this.cFlag ? 1 : 0) << 7);
        this.object_bytes[6] = 0;
        this.object_bytes[7] = 0;
        if (this.noPathTLV != null) {
            System.arraycopy(this.noPathTLV.getTlv_bytes(), 0, this.object_bytes, 8, this.noPathTLV.getTotalTLVLength());
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        if (this.ObjectLength < 8) {
            throw new MalformedPCEPObjectException();
        }
        this.natureOfIssue = this.object_bytes[4];
        this.cFlag = (this.object_bytes[5] & 0x80) == 128;
        int offset = 8;
        if (this.ObjectLength > 8) {
            int tlvType = PCEPTLV.getType(this.getObject_bytes(), offset);
            if (tlvType == 1) {
                this.noPathTLV = new NoPathTLV(this.object_bytes, offset);
            } else {
                throw new MalformedPCEPObjectException();
            }
        }
    }

    public int getNatureOfIssue() {
        return this.natureOfIssue;
    }

    public void setNatureOfIssue(int natureOfIssue) {
        this.natureOfIssue = natureOfIssue;
    }

    public boolean isCFlag() {
        return this.cFlag;
    }

    public void setCFlag(boolean cFlag) {
        this.cFlag = cFlag;
    }

    public NoPathTLV getNoPathTLV() {
        return this.noPathTLV;
    }

    public void setNoPathTLV(NoPathTLV noPathTLV) {
        this.noPathTLV = noPathTLV;
    }

    public String toString() {
        String returnString = this.noPathTLV != null ? "<NOPATH nof: " + this.natureOfIssue + this.noPathTLV.toString() + ">" : "<NOPATH nof: " + this.natureOfIssue + ">";
        return returnString;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.cFlag ? 1231 : 1237);
        result = 31 * result + this.natureOfIssue;
        result = 31 * result + (this.noPathTLV == null ? 0 : this.noPathTLV.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NoPath other = (NoPath)obj;
        if (this.cFlag != other.cFlag) {
            return false;
        }
        if (this.natureOfIssue != other.natureOfIssue) {
            return false;
        }
        return !(this.noPathTLV == null ? other.noPathTLV != null : !this.noPathTLV.equals(other.noPathTLV));
    }
}

