/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;

public class Metric
extends PCEPObject {
    private boolean computedMetricBit;
    private boolean boundBit;
    private int metricType;
    private float metricValue;

    public Metric() {
        this.setObjectClass(6);
        this.setOT(1);
    }

    public Metric(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 12;
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        this.object_bytes[4] = 0;
        this.object_bytes[5] = 0;
        this.object_bytes[6] = (byte)((this.boundBit ? 1 : 0) | (this.computedMetricBit ? 1 : 0) << 1 & 2);
        this.object_bytes[7] = (byte)(this.metricType & 0xFF);
        int metricValuei = Float.floatToIntBits(this.metricValue);
        this.object_bytes[8] = (byte)(metricValuei >>> 24);
        this.object_bytes[9] = (byte)(metricValuei >> 16 & 0xFF);
        this.object_bytes[10] = (byte)(metricValuei >> 8 & 0xFF);
        this.object_bytes[11] = (byte)(metricValuei & 0xFF);
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        if (this.ObjectLength != 12) {
            throw new MalformedPCEPObjectException();
        }
        this.boundBit = (this.object_bytes[6] & 1) == 1;
        this.computedMetricBit = (this.object_bytes[6] & 2) == 2;
        this.metricType = this.object_bytes[7];
        int metricValuei = 0;
        for (int k = 0; k < 4; ++k) {
            metricValuei = metricValuei << 8 | this.object_bytes[k + 8] & 0xFF;
        }
        this.metricValue = Float.intBitsToFloat(metricValuei);
    }

    public void setComputedMetricBit(boolean computedMetricBit) {
        this.computedMetricBit = computedMetricBit;
    }

    public void setBoundBit(boolean boundBit) {
        this.boundBit = boundBit;
    }

    public void setMetricType(int metricType) {
        this.metricType = metricType;
    }

    public void setMetricValue(float metricValue) {
        this.metricValue = metricValue;
    }

    public boolean isBoundBit() {
        return this.boundBit;
    }

    public int getMetricType() {
        return this.metricType;
    }

    public float getMetricValue() {
        return this.metricValue;
    }

    public boolean isComputedMetricBit() {
        return this.computedMetricBit;
    }

    public String toString() {
        if (this.metricType == 1) {
            return "<METRIC type=1(IGP) val:" + this.metricValue + " Bound: " + (this.boundBit ? 1 : 0) + "CompMet: " + (this.computedMetricBit ? Integer.valueOf(1) : "0>");
        }
        if (this.metricType == 2) {
            return "<METRIC type=2(TE) val:" + this.metricValue + " Bound: " + (this.boundBit ? 1 : 0) + "CompMet: " + (this.computedMetricBit ? Integer.valueOf(1) : "0>");
        }
        if (this.metricType == 3) {
            return "<METRIC type=3(HOP COUNT) val:" + this.metricValue + " Bound: " + (this.boundBit ? 1 : 0) + "CompMet: " + (this.computedMetricBit ? Integer.valueOf(1) : "0>");
        }
        if (this.metricType == 12) {
            return "<METRIC type=12(DELAY) val:" + this.metricValue + " Bound: " + (this.boundBit ? 1 : 0) + "CompMet: " + (this.computedMetricBit ? Integer.valueOf(1) : "0>");
        }
        return "<METRIC type=" + this.metricType + "(UNK) val:" + this.metricValue + " Bound: " + (this.boundBit ? 1 : 0) + "CompMet: " + (this.computedMetricBit ? Integer.valueOf(1) : "0>");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.boundBit ? 1231 : 1237);
        result = 31 * result + (this.computedMetricBit ? 1231 : 1237);
        result = 31 * result + this.metricType;
        result = 31 * result + Float.floatToIntBits(this.metricValue);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Metric other = (Metric)obj;
        if (this.boundBit != other.boundBit) {
            return false;
        }
        if (this.computedMetricBit != other.computedMetricBit) {
            return false;
        }
        if (this.metricType != other.metricType) {
            return false;
        }
        return Float.floatToIntBits(this.metricValue) == Float.floatToIntBits(other.metricValue);
    }
}

