/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.NCF;
import es.tid.pce.pcep.objects.LabelSet;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import java.util.LinkedList;

public class LabelSetInclusiveList
extends LabelSet {
    private LinkedList<NCF> ncfList;

    public LabelSetInclusiveList() {
        this.setOT(2);
        this.ncfList = new LinkedList();
    }

    public LabelSetInclusiveList(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int length = 8;
        for (int i = 0; i < this.ncfList.size(); ++i) {
            try {
                this.ncfList.get(i).encode();
            }
            catch (PCEPProtocolViolationException e) {
                e.printStackTrace();
            }
            length += this.ncfList.get(i).getLength();
        }
        this.setObjectLength(length);
        this.object_bytes = new byte[length];
        this.encode_header();
        int offset = 4;
        this.getBytes()[offset] = 0;
        this.getBytes()[offset + 1] = 0;
        this.getBytes()[offset + 2] = 0;
        this.getBytes()[offset + 3] = 0;
        offset += 4;
        for (int i = 0; i < this.ncfList.size(); ++i) {
            System.arraycopy(this.ncfList.get(i).getBytes(), 0, this.object_bytes, offset, this.ncfList.get(i).getLength());
            offset += this.ncfList.get(i).getLength();
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        this.ncfList = new LinkedList();
        int offset = 8;
        if (offset >= this.getLength()) {
            return;
        }
        boolean fin = false;
        while (!fin) {
            NCF ncf = new NCF(this.getBytes(), offset);
            this.ncfList.add(ncf);
            if ((offset += ncf.getLength()) < this.getLength()) continue;
            fin = true;
        }
    }

    public LinkedList<NCF> getNcfList() {
        return this.ncfList;
    }

    public void setNcfList(LinkedList<NCF> nCFList) {
        this.ncfList = nCFList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<ILS ");
        for (int i = 0; i < this.ncfList.size(); ++i) {
            sb.append(this.ncfList.get(i).toString());
        }
        sb.append(">");
        return sb.toString();
    }
}

