/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.subobjects.SREROSubobject;
import es.tid.rsvp.objects.subobjects.ASNumberEROSubobject;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv6prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.LabelEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.rsvp.objects.subobjects.WavebandLabelEROSubobject;
import java.util.LinkedList;
import java.util.Vector;

public class IncludeRouteObject
extends PCEPObject {
    private LinkedList<EROSubobject> IROList;

    public IncludeRouteObject() {
        this.setObjectClass(10);
        this.setOT(1);
        this.IROList = new LinkedList();
    }

    public IncludeRouteObject(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.IROList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        int len = 4;
        for (int k = 0; k < this.IROList.size(); ++k) {
            this.IROList.get(k).encode();
            len += this.IROList.get(k).getErosolength();
        }
        this.ObjectLength = len;
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        int pos = 4;
        for (int k = 0; k < this.IROList.size(); ++k) {
            System.arraycopy(this.IROList.get(k).getSubobject_bytes(), 0, this.object_bytes, pos, this.IROList.get(k).getErosolength());
            pos += this.IROList.get(k).getErosolength();
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        boolean fin = false;
        int offset = 4;
        if (this.ObjectLength == 4) {
            fin = true;
        }
        while (!fin) {
            int subojectclass = EROSubobject.getType(this.getObject_bytes(), offset);
            int subojectlength = EROSubobject.getLength(this.getObject_bytes(), offset);
            switch (subojectclass) {
                case 1: {
                    IPv4prefixEROSubobject sobjt4 = new IPv4prefixEROSubobject(this.getObject_bytes(), offset);
                    this.IROList.add(sobjt4);
                    break;
                }
                case 2: {
                    IPv6prefixEROSubobject sobjt6 = new IPv6prefixEROSubobject(this.getObject_bytes(), offset);
                    this.IROList.add(sobjt6);
                    break;
                }
                case 32: {
                    ASNumberEROSubobject sobjas = new ASNumberEROSubobject(this.getObject_bytes(), offset);
                    this.IROList.add(sobjas);
                    break;
                }
                case 4: {
                    UnnumberIfIDEROSubobject subun = new UnnumberIfIDEROSubobject(this.getObject_bytes(), offset);
                    this.IROList.add(subun);
                    break;
                }
                case 36: {
                    SREROSubobject srero = new SREROSubobject(this.getObject_bytes(), offset);
                    this.IROList.add(srero);
                    break;
                }
                case 3: {
                    int ctype = LabelEROSubobject.getCType(this.getObject_bytes(), offset);
                    switch (ctype) {
                        case 2: {
                            GeneralizedLabelEROSubobject subgl = new GeneralizedLabelEROSubobject(this.getObject_bytes(), offset);
                            this.IROList.add(subgl);
                        }
                        case 3: {
                            WavebandLabelEROSubobject subwl = new WavebandLabelEROSubobject(this.getObject_bytes(), offset);
                            this.IROList.add(subwl);
                        }
                    }
                    log.warn("ERO LABEL Subobject Ctype Unknown: " + ctype);
                    break;
                }
                default: {
                    log.warn("ERO Subobject Unknown subojectclass: " + subojectclass);
                }
            }
            if ((offset += subojectlength) < this.ObjectLength) continue;
            fin = true;
        }
    }

    public void addIROSubobject(EROSubobject eroso) {
        this.IROList.add(eroso);
    }

    public void addEROSubobjectVector(Vector<EROSubobject> erosovec) {
        this.IROList.addAll(erosovec);
    }

    public LinkedList<EROSubobject> getIROList() {
        return this.IROList;
    }

    public void setIROList(LinkedList<EROSubobject> iROList) {
        this.IROList = iROList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.IROList == null ? 0 : this.IROList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncludeRouteObject other = (IncludeRouteObject)obj;
        return !(this.IROList == null ? other.IROList != null : !this.IROList.equals(other.IROList));
    }
}

