/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.subobjects.SREROSubobject;
import es.tid.rsvp.objects.subobjects.ASNumberEROSubobject;
import es.tid.rsvp.objects.subobjects.DataPathIDEROSubobject;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.ETCEROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv6prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.LabelEROSubobject;
import es.tid.rsvp.objects.subobjects.OBSMAINSLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.OpenFlowIDEROSubobject;
import es.tid.rsvp.objects.subobjects.OpenFlowUnnumberIfIDEROSubobject;
import es.tid.rsvp.objects.subobjects.ServerLayerInfo;
import es.tid.rsvp.objects.subobjects.SwitchIDEROSubobject;
import es.tid.rsvp.objects.subobjects.SwitchIDEROSubobjectEdge;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberedDataPathIDEROSubobject;
import es.tid.rsvp.objects.subobjects.WavebandLabelEROSubobject;
import java.util.LinkedList;

public class ExplicitRouteObject
extends PCEPObject {
    public LinkedList<EROSubobject> EROSubobjectList;

    public ExplicitRouteObject() {
        this.setObjectClass(7);
        this.setOT(1);
        this.EROSubobjectList = new LinkedList();
    }

    public ExplicitRouteObject(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.EROSubobjectList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        int len = 4;
        for (int k = 0; k < this.EROSubobjectList.size(); ++k) {
            this.EROSubobjectList.get(k).encode();
            len += this.EROSubobjectList.get(k).getErosolength();
        }
        this.ObjectLength = len;
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        int pos = 4;
        for (int k = 0; k < this.EROSubobjectList.size(); ++k) {
            System.arraycopy(this.EROSubobjectList.get(k).getSubobject_bytes(), 0, this.object_bytes, pos, this.EROSubobjectList.get(k).getErosolength());
            pos += this.EROSubobjectList.get(k).getErosolength();
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        boolean fin = false;
        int offset = 4;
        if (this.ObjectLength == 4) {
            fin = true;
        }
        while (!fin) {
            int subojectclass = EROSubobject.getType(this.getObject_bytes(), offset);
            int subojectlength = EROSubobject.getLength(this.getObject_bytes(), offset);
            block0 : switch (subojectclass) {
                case 36: {
                    log.debug("SR ERO");
                    SREROSubobject sreroso = new SREROSubobject(this.getObject_bytes(), offset);
                    log.debug("FIN");
                    this.addEROSubobject(sreroso);
                    break;
                }
                case 1: {
                    IPv4prefixEROSubobject sobjt4 = new IPv4prefixEROSubobject(this.getObject_bytes(), offset);
                    this.addEROSubobject(sobjt4);
                    break;
                }
                case 2: {
                    IPv6prefixEROSubobject sobjt6 = new IPv6prefixEROSubobject(this.getObject_bytes(), offset);
                    this.addEROSubobject(sobjt6);
                    break;
                }
                case 32: {
                    ASNumberEROSubobject sobjas = new ASNumberEROSubobject(this.getObject_bytes(), offset);
                    this.addEROSubobject(sobjas);
                    break;
                }
                case 4: {
                    UnnumberIfIDEROSubobject subun = new UnnumberIfIDEROSubobject(this.getObject_bytes(), offset);
                    this.addEROSubobject(subun);
                    break;
                }
                case 58: {
                    DataPathIDEROSubobject subdp = new DataPathIDEROSubobject(this.getObject_bytes(), offset);
                    this.addEROSubobject(subdp);
                    break;
                }
                case 59: {
                    UnnumberedDataPathIDEROSubobject subudp = new UnnumberedDataPathIDEROSubobject(this.getObject_bytes(), offset);
                    this.addEROSubobject(subudp);
                    break;
                }
                case 40: {
                    ServerLayerInfo sli = new ServerLayerInfo(this.getObject_bytes(), offset);
                    this.addEROSubobject(sli);
                    break;
                }
                case 55: {
                    SwitchIDEROSubobject macS = new SwitchIDEROSubobject(this.getObject_bytes(), offset);
                    this.addEROSubobject(macS);
                    break;
                }
                case 56: {
                    SwitchIDEROSubobjectEdge macSE = new SwitchIDEROSubobjectEdge(this.getObject_bytes(), offset);
                    this.addEROSubobject(macSE);
                    break;
                }
                case 92: {
                    OpenFlowUnnumberIfIDEROSubobject unifOF = new OpenFlowUnnumberIfIDEROSubobject(this.getObject_bytes(), offset);
                    this.addEROSubobject(unifOF);
                    break;
                }
                case 90: {
                    OpenFlowIDEROSubobject idOF = new OpenFlowIDEROSubobject(this.getObject_bytes(), offset);
                    this.addEROSubobject(idOF);
                    break;
                }
                case 10: {
                    ETCEROSubobject etcSERO = new ETCEROSubobject(this.getObject_bytes(), offset);
                    this.addEROSubobject(etcSERO);
                    break;
                }
                case 3: {
                    int ctype = LabelEROSubobject.getCType(this.getObject_bytes(), offset);
                    switch (ctype) {
                        case 2: {
                            GeneralizedLabelEROSubobject subgl = new GeneralizedLabelEROSubobject(this.getObject_bytes(), offset);
                            this.addEROSubobject(subgl);
                            break block0;
                        }
                        case 3: {
                            WavebandLabelEROSubobject subwl = new WavebandLabelEROSubobject(this.getObject_bytes(), offset);
                            this.addEROSubobject(subwl);
                            break block0;
                        }
                        case 254: {
                            OBSMAINSLabelEROSubobject oles = new OBSMAINSLabelEROSubobject(this.getObject_bytes(), offset);
                            this.addEROSubobject(oles);
                            break block0;
                        }
                    }
                    log.warn("ERO LABEL Subobject Ctype Unknown");
                    break;
                }
                default: {
                    log.warn("ERO Subobject Unknown subojectclass: " + subojectclass);
                }
            }
            if ((offset += subojectlength) < this.ObjectLength) continue;
            fin = true;
        }
    }

    public void addEROSubobject(EROSubobject eroso) {
        this.EROSubobjectList.add(eroso);
    }

    public void addEROSubobjectList(LinkedList<EROSubobject> erosovec) {
        this.EROSubobjectList.addAll(erosovec);
    }

    public LinkedList<EROSubobject> getEROSubobjectList() {
        return this.EROSubobjectList;
    }

    public void setEROSubobjectList(LinkedList<EROSubobject> eROSubobjectList) {
        this.EROSubobjectList = eROSubobjectList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.EROSubobjectList.size() * 100);
        sb.append("<ERO: ");
        for (int i = 0; i < this.EROSubobjectList.size(); ++i) {
            sb.append(this.EROSubobjectList.get(i).toString());
            sb.append(" ");
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.EROSubobjectList == null ? 0 : this.EROSubobjectList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExplicitRouteObject other = (ExplicitRouteObject)obj;
        return !(this.EROSubobjectList == null ? other.EROSubobjectList != null : !this.EROSubobjectList.equals(other.EROSubobjectList));
    }
}

