/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class EndPointsUnnumberedIntf
extends EndPoints {
    private Inet4Address sourceIP;
    private long sourceIF;
    private Inet4Address destIP;
    private long destIF;

    public long getSourceIF() {
        return this.sourceIF;
    }

    public void setSourceIF(long sourceIF) {
        this.sourceIF = sourceIF;
    }

    public long getDestIF() {
        return this.destIF;
    }

    public void setDestIF(long destIF) {
        this.destIF = destIF;
    }

    @Override
    public void encode() {
        this.ObjectLength = 20;
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        System.arraycopy(this.sourceIP.getAddress(), 0, this.object_bytes, 4, 4);
        this.object_bytes[8] = (byte)(this.sourceIF >>> 24);
        this.object_bytes[9] = (byte)(this.sourceIF >>> 16 & 0xFFL);
        this.object_bytes[10] = (byte)(this.sourceIF >>> 8 & 0xFFL);
        this.object_bytes[11] = (byte)(this.sourceIF & 0xFFL);
        System.arraycopy(this.destIP.getAddress(), 0, this.object_bytes, 12, 4);
        this.object_bytes[16] = (byte)(this.destIF >>> 24);
        this.object_bytes[17] = (byte)(this.destIF >>> 16 & 0xFFL);
        this.object_bytes[18] = (byte)(this.destIF >>> 8 & 0xFFL);
        this.object_bytes[19] = (byte)(this.destIF & 0xFFL);
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        if (this.ObjectLength != 20) {
            throw new MalformedPCEPObjectException();
        }
        byte[] ip = new byte[4];
        System.arraycopy(this.object_bytes, 4, ip, 0, 4);
        try {
            this.sourceIP = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        for (int k = 0; k < 4; ++k) {
            this.sourceIF = this.sourceIF << 8 | (long)(this.object_bytes[k + 8] & 0xFF);
        }
        System.arraycopy(this.object_bytes, 12, ip, 0, 4);
        try {
            this.destIP = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        for (int k = 0; k < 4; ++k) {
            this.destIF = this.destIF << 8 | (long)(this.object_bytes[k + 16] & 0xFF);
        }
    }

    public EndPointsUnnumberedIntf() {
        this.setObjectClass(4);
        this.setOT(10);
    }

    public EndPointsUnnumberedIntf(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    public Inet4Address getSourceIP() {
        return this.sourceIP;
    }

    public void setSourceIP(Inet4Address sourceIP) {
        this.sourceIP = sourceIP;
    }

    public Inet4Address getDestIP() {
        return this.destIP;
    }

    public void setDestIP(Inet4Address destIP) {
        this.destIP = destIP;
    }

    public String toString() {
        return "Source IP: " + this.sourceIP + "Source If: " + this.sourceIF + " Destination IP: " + this.destIP + " Destination If: " + this.destIF;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.destIF ^ this.destIF >>> 32);
        result = 31 * result + (this.destIP == null ? 0 : this.destIP.hashCode());
        result = 31 * result + (int)(this.sourceIF ^ this.sourceIF >>> 32);
        result = 31 * result + (this.sourceIP == null ? 0 : this.sourceIP.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndPointsUnnumberedIntf other = (EndPointsUnnumberedIntf)obj;
        if (this.destIF != other.destIF) {
            return false;
        }
        if (this.destIP == null ? other.destIP != null : !this.destIP.equals(other.destIP)) {
            return false;
        }
        if (this.sourceIF != other.sourceIF) {
            return false;
        }
        return !(this.sourceIP == null ? other.sourceIP != null : !this.sourceIP.equals(other.sourceIP));
    }
}

