/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import java.net.Inet6Address;
import java.net.UnknownHostException;

public class EndPointsIPv6
extends EndPoints {
    public Inet6Address sourceIP;
    public Inet6Address destIP;

    public EndPointsIPv6() {
        this.setObjectClass(4);
        this.setOT(2);
    }

    public EndPointsIPv6(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 36;
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        System.arraycopy(this.sourceIP.getAddress(), 0, this.object_bytes, 4, 16);
        System.arraycopy(this.destIP.getAddress(), 0, this.object_bytes, 20, 16);
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        if (this.ObjectLength != 36) {
            throw new MalformedPCEPObjectException();
        }
        byte[] ip = new byte[16];
        System.arraycopy(this.object_bytes, 4, ip, 0, 16);
        try {
            this.sourceIP = (Inet6Address)Inet6Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        System.arraycopy(this.object_bytes, 20, ip, 0, 16);
        try {
            this.destIP = (Inet6Address)Inet6Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.destIP == null ? 0 : this.destIP.hashCode());
        result = 31 * result + (this.sourceIP == null ? 0 : this.sourceIP.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndPointsIPv6 other = (EndPointsIPv6)obj;
        if (this.destIP == null ? other.destIP != null : !this.destIP.equals(other.destIP)) {
            return false;
        }
        return !(this.sourceIP == null ? other.sourceIP != null : !this.sourceIP.equals(other.sourceIP));
    }

    public Inet6Address getSourceIP() {
        return this.sourceIP;
    }

    public void setSourceIP(Inet6Address sourceIP) {
        this.sourceIP = sourceIP;
    }

    public Inet6Address getDestIP() {
        return this.destIP;
    }

    public void setDestIP(Inet6Address destIP) {
        this.destIP = destIP;
    }
}

