/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.of.DataPathID;
import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.protocol.commons.ByteHandler;

public class EndPointDataPathID
extends EndPoints {
    private DataPathID sourceSwitchID;
    private DataPathID destSwitchID;

    public EndPointDataPathID() {
        this.setObjectClass(4);
        this.setOT(14);
    }

    public EndPointDataPathID(byte[] bytes, int offset) throws MalformedPCEPObjectException, PCEPProtocolViolationException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 20;
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        System.arraycopy(ByteHandler.MACFormatStringtoByteArray(this.sourceSwitchID.getDataPathID()), 0, this.object_bytes, 4, 8);
        System.arraycopy(ByteHandler.MACFormatStringtoByteArray(this.destSwitchID.getDataPathID()), 0, this.object_bytes, 12, 8);
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        if (this.ObjectLength != 20) {
            throw new MalformedPCEPObjectException();
        }
        byte[] mac = new byte[8];
        System.arraycopy(this.object_bytes, 4, mac, 0, 8);
        this.sourceSwitchID = new DataPathID();
        this.sourceSwitchID.setDataPathID(ByteHandler.ByteMACToString(mac));
        log.debug("EndPointDataPathID decode sourceSwitchID:: " + this.sourceSwitchID);
        this.destSwitchID = new DataPathID();
        System.arraycopy(this.object_bytes, 12, mac, 0, 8);
        this.destSwitchID.setDataPathID(ByteHandler.ByteMACToString(mac));
        log.debug("EndPointDataPathID decode destSwitchID:: " + this.destSwitchID);
    }

    public DataPathID getSourceSwitchID() {
        return this.sourceSwitchID;
    }

    public void setSourceSwitchID(DataPathID sourceSwitchID) {
        this.sourceSwitchID = sourceSwitchID;
    }

    public DataPathID getDestSwitchID() {
        return this.destSwitchID;
    }

    public void setDestSwitchID(DataPathID destSwitchID) {
        this.destSwitchID = destSwitchID;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.destSwitchID == null ? 0 : this.destSwitchID.hashCode());
        result = 31 * result + (this.sourceSwitchID == null ? 0 : this.sourceSwitchID.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndPointDataPathID other = (EndPointDataPathID)obj;
        if (this.destSwitchID == null ? other.destSwitchID != null : !this.destSwitchID.equals(other.destSwitchID)) {
            return false;
        }
        return !(this.sourceSwitchID == null ? other.sourceSwitchID != null : !this.sourceSwitchID.equals(other.sourceSwitchID));
    }
}

